/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.utils;

import io.confluent.kafka.schemaregistry.json.utils.Edge;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MaximumCardinalityMatch<V, T> {
    private final Set<Edge<V, T>> edges;
    private final Set<V> partition1;
    private final Set<V> partition2;
    private Map<V, Set<Edge<V, T>>> adjacencyList;
    private List<V> vertices;
    private Map<V, Integer> vertexIndexMap;
    private int matchedVertices;
    private final int nil = 0;
    private final int infinity = Integer.MAX_VALUE;
    private int[] matching;
    private int[] dist;
    private Queue<Integer> queue;

    public MaximumCardinalityMatch(Set<Edge<V, T>> edges, Set<V> partition1, Set<V> partition2) {
        this.edges = edges;
        if (partition1.size() <= partition2.size()) {
            this.partition1 = partition1;
            this.partition2 = partition2;
        } else {
            this.partition1 = partition2;
            this.partition2 = partition1;
        }
    }

    private Edge<V, T> edge(V source, V target) {
        return this.adjacencyList.getOrDefault(source, Collections.emptySet()).stream().filter(e -> e.source() == target || e.target() == target).findAny().orElse(null);
    }

    private List<V> neighborsOf(V source) {
        return this.adjacencyList.getOrDefault(source, Collections.emptySet()).stream().map(e -> e.source() == source ? e.target() : e.source()).collect(Collectors.toList());
    }

    private void init() {
        this.adjacencyList = new IdentityHashMap<V, Set<Edge<V, T>>>();
        for (Edge<V, T> edge : this.edges) {
            Set adj = this.adjacencyList.computeIfAbsent((Set)edge.source(), (Function<Set, Set<Edge<Set, T>>>)((Function<Object, Set>)k -> new HashSet()));
            adj.add(edge);
            adj = this.adjacencyList.computeIfAbsent((Set)edge.target(), (Function<Set, Set<Edge<Set, T>>>)((Function<Object, Set>)k -> new HashSet()));
            adj.add(edge);
        }
        this.vertices = new ArrayList<V>();
        this.vertices.add(null);
        this.vertices.addAll(this.partition1);
        this.vertices.addAll(this.partition2);
        this.vertexIndexMap = new IdentityHashMap<V, Integer>();
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertexIndexMap.put((Integer)this.vertices.get(i), i);
        }
        this.matching = new int[this.vertices.size() + 1];
        this.dist = new int[this.partition1.size() + 1];
        this.queue = new ArrayDeque<Integer>(this.vertices.size());
    }

    private void computeInitialMatching() {
        block0: for (V u0 : this.partition1) {
            int u = this.vertexIndexMap.get(u0);
            for (V v0 : this.neighborsOf(u0)) {
                int v = this.vertexIndexMap.get(v0);
                if (this.matching[v] != 0) continue;
                this.matching[v] = u;
                this.matching[u] = v;
                ++this.matchedVertices;
                continue block0;
            }
        }
    }

    private boolean bfs() {
        int u;
        this.queue.clear();
        for (u = 1; u <= this.partition1.size(); ++u) {
            if (this.matching[u] == 0) {
                this.dist[u] = 0;
                this.queue.add(u);
                continue;
            }
            this.dist[u] = Integer.MAX_VALUE;
        }
        this.dist[0] = Integer.MAX_VALUE;
        while (!this.queue.isEmpty()) {
            u = this.queue.poll();
            if (this.dist[u] >= this.dist[0]) continue;
            for (V v0 : this.neighborsOf(this.vertices.get(u))) {
                int v = this.vertexIndexMap.get(v0);
                if (this.dist[this.matching[v]] != Integer.MAX_VALUE) continue;
                this.dist[this.matching[v]] = this.dist[u] + 1;
                this.queue.add(this.matching[v]);
            }
        }
        return this.dist[0] != Integer.MAX_VALUE;
    }

    private boolean dfs(int u) {
        if (u != 0) {
            for (V v0 : this.neighborsOf(this.vertices.get(u))) {
                int v = this.vertexIndexMap.get(v0);
                if (this.dist[this.matching[v]] != this.dist[u] + 1 || !this.dfs(this.matching[v])) continue;
                this.matching[v] = u;
                this.matching[u] = v;
                return true;
            }
            this.dist[u] = Integer.MAX_VALUE;
            return false;
        }
        return true;
    }

    public Set<Edge<V, T>> getMatching() {
        this.init();
        this.computeInitialMatching();
        while (this.matchedVertices < this.partition1.size() && this.bfs()) {
            for (int v = 1; v <= this.partition1.size() && this.matchedVertices < this.partition1.size(); ++v) {
                if (this.matching[v] != 0 || !this.dfs(v)) continue;
                ++this.matchedVertices;
            }
        }
        assert (this.matchedVertices <= this.partition1.size());
        HashSet<Edge<V, T>> edges = new HashSet<Edge<V, T>>();
        for (int i = 0; i < this.vertices.size(); ++i) {
            if (this.matching[i] == 0) continue;
            edges.add(this.edge(this.vertices.get(i), this.vertices.get(this.matching[i])));
        }
        return edges;
    }
}

