/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.serializers.KafkaJsonDecoderConfig;
import io.confluent.kafka.serializers.KafkaJsonDeserializerConfig;
import io.confluent.kafka.serializers.jackson.Jackson;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ObjectMapper;

public class KafkaJsonDeserializer<T>
implements Deserializer<T> {
    private ObjectMapper objectMapper;
    private Class<T> type;

    @Override
    public void configure(Map<String, ?> props, boolean isKey) {
        this.configure(new KafkaJsonDeserializerConfig(props), isKey);
    }

    protected void configure(KafkaJsonDecoderConfig config, Class<T> type) {
        this.objectMapper = Jackson.newObjectMapper();
        this.type = type;
        boolean failUnknownProperties = config.getBoolean("json.fail.unknown.properties");
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failUnknownProperties);
    }

    private void configure(KafkaJsonDeserializerConfig config, boolean isKey) {
        if (isKey) {
            this.configure((KafkaJsonDecoderConfig)config, config.getClass("json.key.type"));
        } else {
            this.configure((KafkaJsonDecoderConfig)config, config.getClass("json.value.type"));
        }
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    @Override
    public T deserialize(String ignored, byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            return this.objectMapper.readValue(bytes, this.type);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    protected Class<T> getType() {
        return this.type;
    }

    @Override
    public void close() {
    }
}

