/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConditionalSchema;
import org.everit.json.schema.ConstSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.TrueSchema;
import org.everit.json.schema.Visitor;
import org.everit.json.schema.internal.JSONPrinter;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.regexp.Regexp;
import org.json.JSONException;

class ToStringVisitor
extends Visitor {
    private final JSONPrinter writer;
    private boolean jsonObjectIsOpenForCurrentSchemaInstance = false;
    private boolean skipNextObject = false;
    private SpecificationVersion deducedSpecVersion;

    ToStringVisitor(JSONPrinter writer) {
        this.writer = writer;
    }

    @Override
    void visitSchema(Schema schema2) {
        if (schema2 == null) {
            return;
        }
        if (!this.jsonObjectIsOpenForCurrentSchemaInstance) {
            this.writer.object();
        }
        this.writer.ifPresent("title", schema2.getTitle());
        this.writer.ifPresent("description", schema2.getDescription());
        this.writer.ifPresent("nullable", schema2.isNullable());
        this.writer.ifPresent("default", schema2.getDefaultValue());
        this.writer.ifPresent("readOnly", schema2.isReadOnly());
        this.writer.ifPresent("writeOnly", schema2.isWriteOnly());
        super.visitSchema(schema2);
        Object schemaKeywordValue = schema2.getUnprocessedProperties().get("$schema");
        String idKeyword = this.deduceSpecVersion(schemaKeywordValue).idKeyword();
        this.writer.ifPresent(idKeyword, schema2.getId());
        schema2.getUnprocessedProperties().forEach((key, val) -> this.writer.key((String)key).value(val));
        schema2.describePropertiesTo(this.writer);
        if (!this.jsonObjectIsOpenForCurrentSchemaInstance) {
            this.writer.endObject();
        }
    }

    private SpecificationVersion deduceSpecVersion(Object schemaKeywordValue) {
        if (this.deducedSpecVersion != null) {
            return this.deducedSpecVersion;
        }
        if (schemaKeywordValue instanceof String) {
            this.deducedSpecVersion = SpecificationVersion.lookupByMetaSchemaUrl((String)schemaKeywordValue).orElse(SpecificationVersion.DRAFT_4);
            return this.deducedSpecVersion;
        }
        this.deducedSpecVersion = SpecificationVersion.DRAFT_4;
        return this.deducedSpecVersion;
    }

    private void printInJsonObject(Runnable task) {
        if (this.skipNextObject) {
            this.skipNextObject = false;
            this.jsonObjectIsOpenForCurrentSchemaInstance = true;
            task.run();
            this.jsonObjectIsOpenForCurrentSchemaInstance = false;
        } else {
            this.writer.object();
            this.jsonObjectIsOpenForCurrentSchemaInstance = true;
            task.run();
            this.writer.endObject();
            this.jsonObjectIsOpenForCurrentSchemaInstance = false;
        }
    }

    @Override
    void visitBooleanSchema(BooleanSchema schema2) {
        this.printInJsonObject(() -> {
            super.visitBooleanSchema(schema2);
            this.writer.key("type").value("boolean");
        });
    }

    @Override
    void visitArraySchema(ArraySchema schema2) {
        this.printInJsonObject(() -> {
            if (schema2.requiresArray()) {
                this.writer.key("type").value("array");
            }
            this.writer.ifTrue("uniqueItems", schema2.needsUniqueItems()).ifPresent("minItems", schema2.getMinItems()).ifPresent("maxItems", schema2.getMaxItems()).ifFalse("additionalItems", schema2.permitsAdditionalItems());
            super.visitArraySchema(schema2);
        });
    }

    @Override
    void visit(Schema schema2) {
        boolean orig = this.jsonObjectIsOpenForCurrentSchemaInstance;
        this.jsonObjectIsOpenForCurrentSchemaInstance = false;
        super.visit(schema2);
        this.jsonObjectIsOpenForCurrentSchemaInstance = orig;
    }

    @Override
    void visitAllItemSchema(Schema allItemSchema) {
        this.writer.key("items");
        this.visit(allItemSchema);
    }

    @Override
    void visitEmptySchema(EmptySchema emptySchema) {
        if (emptySchema instanceof TrueSchema) {
            this.writer.value(true);
        } else {
            this.printInJsonObject(() -> super.visitEmptySchema(emptySchema));
        }
    }

    @Override
    void visitItemSchemas(List<Schema> itemSchemas) {
        this.writer.key("items");
        this.writer.array();
        super.visitItemSchemas(itemSchemas);
        this.writer.endArray();
    }

    @Override
    void visitItemSchema(int index, Schema itemSchema) {
        this.visit(itemSchema);
    }

    @Override
    void visitSchemaOfAdditionalItems(Schema schemaOfAdditionalItems) {
        this.writer.key("additionalItems");
        this.visit(schemaOfAdditionalItems);
    }

    @Override
    void visitContainedItemSchema(Schema containedItemSchema) {
        this.writer.key("contains");
        this.visit(containedItemSchema);
    }

    @Override
    void visitConditionalSchema(ConditionalSchema conditionalSchema) {
        this.printInJsonObject(() -> super.visitConditionalSchema(conditionalSchema));
    }

    @Override
    void visitNotSchema(NotSchema notSchema) {
        this.printInJsonObject(() -> {
            this.visitSchema(notSchema);
            this.writer.key("not");
            notSchema.getMustNotMatch().accept(this);
        });
    }

    @Override
    void visitNumberSchema(NumberSchema schema2) {
        this.printInJsonObject(() -> {
            if (schema2.requiresInteger()) {
                this.writer.key("type").value("integer");
            } else if (schema2.isRequiresNumber()) {
                this.writer.key("type").value("number");
            }
            this.writer.ifPresent("minimum", schema2.getMinimum());
            this.writer.ifPresent("maximum", schema2.getMaximum());
            this.writer.ifPresent("multipleOf", schema2.getMultipleOf());
            this.writer.ifTrue("exclusiveMinimum", schema2.isExclusiveMinimum());
            this.writer.ifTrue("exclusiveMaximum", schema2.isExclusiveMaximum());
            try {
                this.writer.ifPresent("exclusiveMinimum", schema2.getExclusiveMinimumLimit());
                this.writer.ifPresent("exclusiveMaximum", schema2.getExclusiveMaximumLimit());
            }
            catch (JSONException e) {
                throw new IllegalStateException("overloaded use of exclusiveMinimum or exclusiveMaximum keyword");
            }
            super.visitNumberSchema(schema2);
        });
    }

    @Override
    void visitConstSchema(ConstSchema constSchema) {
        this.printInJsonObject(() -> {
            this.writer.key("const");
            this.writer.value(constSchema.getPermittedValue());
            super.visitConstSchema(constSchema);
        });
    }

    @Override
    void visitObjectSchema(ObjectSchema schema2) {
        this.printInJsonObject(() -> {
            if (schema2.requiresObject()) {
                this.writer.key("type").value("object");
            }
            this.writer.ifPresent("minProperties", schema2.getMinProperties());
            this.writer.ifPresent("maxProperties", schema2.getMaxProperties());
            if (!schema2.getPropertyDependencies().isEmpty()) {
                this.describePropertyDependencies(schema2.getPropertyDependencies());
            }
            if (!schema2.getSchemaDependencies().isEmpty()) {
                this.writer.key("dependencies");
                this.printSchemaMap(schema2.getSchemaDependencies());
            }
            this.writer.ifFalse("additionalProperties", schema2.permitsAdditionalProperties());
            super.visitObjectSchema(schema2);
        });
    }

    @Override
    void visitRequiredProperties(List<String> requiredProperties) {
        if (!requiredProperties.isEmpty()) {
            this.writer.key("required").value(requiredProperties);
        }
    }

    @Override
    void visitSchemaOfAdditionalProperties(Schema schemaOfAdditionalProperties) {
        this.writer.key("additionalProperties");
        this.visit(schemaOfAdditionalProperties);
    }

    private void describePropertyDependencies(Map<String, Set<String>> propertyDependencies) {
        this.writer.key("dependencies");
        this.writer.object();
        propertyDependencies.forEach((key, value) -> {
            this.writer.key((String)key);
            this.writer.array();
            value.forEach(this.writer::value);
            this.writer.endArray();
        });
        this.writer.endObject();
    }

    @Override
    void visitPropertyNameSchema(Schema propertyNameSchema) {
        this.writer.key("propertyNames");
        this.visit(propertyNameSchema);
    }

    @Override
    void visitPropertySchemas(Map<String, Schema> propertySchemas) {
        if (!propertySchemas.isEmpty()) {
            this.writer.key("properties");
            this.printSchemaMap(propertySchemas);
        }
    }

    private void printSchemaMap(Map<?, Schema> schemas) {
        this.writer.object();
        schemas.forEach((key, value) -> {
            this.writer.key(key.toString());
            this.visit((Schema)value);
        });
        this.writer.endObject();
    }

    @Override
    void visitPatternProperties(Map<Regexp, Schema> patternProperties) {
        if (!patternProperties.isEmpty()) {
            this.writer.key("patternProperties");
            this.printSchemaMap(patternProperties);
        }
    }

    @Override
    void visitCombinedSchema(CombinedSchema combinedSchema) {
        this.printInJsonObject(() -> {
            super.visitCombinedSchema(combinedSchema);
            if (combinedSchema.isSynthetic()) {
                combinedSchema.getSubschemas().forEach(subschema -> {
                    this.skipNextObject = true;
                    super.visit((Schema)subschema);
                });
            } else {
                this.writer.key(combinedSchema.getCriterion().toString());
                this.writer.array();
                combinedSchema.getSubschemas().forEach(subschema -> subschema.accept(this));
                this.writer.endArray();
            }
        });
    }

    @Override
    void visitIfSchema(Schema ifSchema) {
        this.writer.key("if");
        this.visit(ifSchema);
    }

    @Override
    void visitThenSchema(Schema thenSchema) {
        this.writer.key("then");
        this.visit(thenSchema);
    }

    @Override
    void visitElseSchema(Schema elseSchema) {
        this.writer.key("else");
        this.visit(elseSchema);
    }

    @Override
    void visitFalseSchema(FalseSchema falseSchema) {
        this.writer.value(false);
    }

    @Override
    void visitNullSchema(NullSchema nullSchema) {
        this.printInJsonObject(() -> {
            this.writer.key("type");
            this.writer.value("null");
            super.visitNullSchema(nullSchema);
        });
    }

    @Override
    void visitStringSchema(StringSchema schema2) {
        this.printInJsonObject(() -> {
            if (schema2.requireString()) {
                this.writer.key("type").value("string");
            }
            this.writer.ifPresent("minLength", schema2.getMinLength());
            this.writer.ifPresent("maxLength", schema2.getMaxLength());
            this.writer.ifPresent("pattern", schema2.getPattern());
            if (schema2.getFormatValidator() != null && !FormatValidator.NONE.equals(schema2.getFormatValidator())) {
                this.writer.key("format").value(schema2.getFormatValidator().formatName());
            }
            super.visitStringSchema(schema2);
        });
    }

    @Override
    void visitEnumSchema(EnumSchema schema2) {
        this.printInJsonObject(() -> {
            this.writer.key("enum");
            this.writer.array();
            schema2.getPossibleValues().forEach(this.writer::value);
            this.writer.endArray();
            super.visitEnumSchema(schema2);
        });
    }

    @Override
    void visitReferenceSchema(ReferenceSchema referenceSchema) {
        this.printInJsonObject(() -> {
            this.writer.key("$ref");
            this.writer.value(referenceSchema.getReferenceValue());
            super.visitReferenceSchema(referenceSchema);
        });
    }
}

