/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http.rest;

import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.DecodeException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceExistsException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.exception.TooManyRedirectsException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.implementation.ReflectiveInvoker;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.implementation.http.UnexpectedExceptionInformation;
import com.azure.core.implementation.http.rest.ErrorOptions;
import com.azure.core.implementation.http.rest.RequestDataConfiguration;
import com.azure.core.implementation.http.rest.ResponseConstructorsCache;
import com.azure.core.implementation.http.rest.ResponseExceptionConstructorCache;
import com.azure.core.implementation.http.rest.RestProxyUtils;
import com.azure.core.implementation.http.rest.SwaggerInterfaceParser;
import com.azure.core.implementation.http.rest.SwaggerMethodParser;
import com.azure.core.implementation.serializer.HttpResponseDecoder;
import com.azure.core.implementation.serializer.MalformedValueException;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.tracing.Tracer;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.function.Consumer;
import reactor.core.Exceptions;

public abstract class RestProxyBase {
    static final String MUST_IMPLEMENT_PAGE_ERROR = "Unable to create PagedResponse<T>. Body must be of a type that implements: " + Page.class;
    static final ResponseConstructorsCache RESPONSE_CONSTRUCTORS_CACHE = new ResponseConstructorsCache();
    private static final ResponseExceptionConstructorCache RESPONSE_EXCEPTION_CONSTRUCTOR_CACHE = new ResponseExceptionConstructorCache();
    static final ClientLogger LOGGER = new ClientLogger(RestProxyBase.class);
    final HttpPipeline httpPipeline;
    final SerializerAdapter serializer;
    final SwaggerInterfaceParser interfaceParser;
    final HttpResponseDecoder decoder;
    protected final Tracer tracer;

    public RestProxyBase(HttpPipeline httpPipeline, SerializerAdapter serializer, SwaggerInterfaceParser interfaceParser) {
        this.httpPipeline = httpPipeline;
        this.serializer = serializer;
        this.interfaceParser = interfaceParser;
        this.decoder = new HttpResponseDecoder(this.serializer);
        this.tracer = httpPipeline.getTracer();
    }

    public final Object invoke(Object proxy, Method method, RequestOptions options, EnumSet<ErrorOptions> errorOptions, Consumer<HttpRequest> requestCallback, SwaggerMethodParser methodParser, boolean isAsync, Object[] args) {
        try {
            HttpRequest request = this.createHttpRequest(methodParser, this.serializer, isAsync, args);
            Context context = methodParser.setContext(args);
            context = RestProxyUtils.mergeRequestOptionsContext(context, options);
            context = context.addData("caller-method", methodParser.getFullyQualifiedMethodName());
            if (methodParser.isResponseEagerlyRead()) {
                context = context.addData("azure-eagerly-read-response", true);
            }
            if (methodParser.isResponseBodyIgnored()) {
                context = context.addData("azure-ignore-response-body", true);
            }
            if (methodParser.isHeadersEagerlyConverted()) {
                context = context.addData("azure-eagerly-convert-headers", true);
            }
            return this.invoke(proxy, method, options, errorOptions, requestCallback, methodParser, request, context);
        }
        catch (IOException e) {
            if (isAsync) {
                return FluxUtil.monoError(LOGGER, Exceptions.propagate(e));
            }
            throw LOGGER.logExceptionAsError(Exceptions.propagate(e));
        }
    }

    protected abstract Object invoke(Object var1, Method var2, RequestOptions var3, EnumSet<ErrorOptions> var4, Consumer<HttpRequest> var5, SwaggerMethodParser var6, HttpRequest var7, Context var8);

    public abstract void updateRequest(RequestDataConfiguration var1, SerializerAdapter var2) throws IOException;

    public Response createResponse(HttpResponseDecoder.HttpDecodedResponse response, Type entityType, Object bodyAsObject) {
        Class<?> cls = TypeUtil.getRawClass(entityType);
        HttpResponse httpResponse = response.getSourceResponse();
        HttpRequest request = httpResponse.getRequest();
        int statusCode = httpResponse.getStatusCode();
        HttpHeaders headers = httpResponse.getHeaders();
        Object decodedHeaders = response.getDecodedHeaders();
        if (cls.equals(Response.class)) {
            return (Response)cls.cast(new ResponseBase<Object, Object>(request, statusCode, headers, bodyAsObject, decodedHeaders));
        }
        if (cls.equals(PagedResponse.class)) {
            if (bodyAsObject != null && !TypeUtil.isTypeOrSubTypeOf(bodyAsObject.getClass(), Page.class)) {
                throw LOGGER.logExceptionAsError(new RuntimeException(MUST_IMPLEMENT_PAGE_ERROR));
            }
            if (bodyAsObject == null) {
                return (Response)cls.cast(new PagedResponseBase(request, statusCode, headers, null, null, decodedHeaders));
            }
            return (Response)cls.cast(new PagedResponseBase(request, statusCode, headers, (Page)bodyAsObject, decodedHeaders));
        }
        ReflectiveInvoker constructorReflectiveInvoker = RESPONSE_CONSTRUCTORS_CACHE.get(cls);
        return RESPONSE_CONSTRUCTORS_CACHE.invoke(constructorReflectiveInvoker, response, bodyAsObject);
    }

    Context startTracingSpan(SwaggerMethodParser method, Context context) {
        if (this.isTracingEnabled(context)) {
            Object tracingContextObj = context.getData("trace-context").orElse(null);
            Context tracingContext = tracingContextObj instanceof Context ? (Context)tracingContextObj : context;
            return this.tracer.start(method.getSpanName(), tracingContext);
        }
        return context;
    }

    protected boolean isTracingEnabled(Context context) {
        return this.tracer.isEnabled() && (Boolean)context.getData("disable-tracing").orElse(false) == false;
    }

    HttpRequest createHttpRequest(SwaggerMethodParser methodParser, SerializerAdapter serializerAdapter, boolean isAsync, Object[] args) throws IOException {
        UrlBuilder urlBuilder;
        String path = methodParser.setPath(args, this.serializer);
        UrlBuilder pathUrlBuilder = UrlBuilder.parse(path);
        if (pathUrlBuilder.getScheme() != null) {
            urlBuilder = pathUrlBuilder;
        } else {
            urlBuilder = new UrlBuilder();
            methodParser.setSchemeAndHost(args, urlBuilder, this.serializer);
            if (path != null && !path.isEmpty() && !"/".equals(path)) {
                String hostPath = urlBuilder.getPath();
                if (hostPath == null || hostPath.isEmpty() || "/".equals(hostPath) || path.contains("://")) {
                    urlBuilder.setPath(path);
                } else if (path.startsWith("/")) {
                    urlBuilder.setPath(hostPath + path);
                } else {
                    urlBuilder.setPath(hostPath + "/" + path);
                }
            }
        }
        methodParser.setEncodedQueryParameters(args, urlBuilder, this.serializer);
        URL url = urlBuilder.toUrl();
        HttpRequest request = this.configRequest(new HttpRequest(methodParser.getHttpMethod(), url), methodParser, serializerAdapter, isAsync, args);
        HttpHeaders httpHeaders = request.getHeaders();
        methodParser.setHeaders(args, httpHeaders, this.serializer);
        return request;
    }

    private HttpRequest configRequest(HttpRequest request, SwaggerMethodParser methodParser, SerializerAdapter serializerAdapter, boolean isAsync, Object[] args) throws IOException {
        Object bodyContentObject = methodParser.setBody(args, this.serializer);
        if (bodyContentObject == null) {
            request.setHeader(HttpHeaderName.CONTENT_LENGTH, "0");
        } else {
            String[] contentTypeParts;
            String contentType = methodParser.getBodyContentType();
            if (contentType == null || contentType.isEmpty()) {
                contentType = bodyContentObject instanceof byte[] || bodyContentObject instanceof String ? "application/octet-stream" : "application/json";
            }
            request.setHeader(HttpHeaderName.CONTENT_TYPE, contentType);
            if (bodyContentObject instanceof BinaryData) {
                BinaryData binaryData = (BinaryData)bodyContentObject;
                if (binaryData.getLength() != null) {
                    request.setHeader(HttpHeaderName.CONTENT_LENGTH, binaryData.getLength().toString());
                }
                request.setBody(binaryData);
                return request;
            }
            boolean isJson = false;
            for (String contentTypePart : contentTypeParts = contentType.split(";")) {
                if (!contentTypePart.trim().equalsIgnoreCase("application/json")) continue;
                isJson = true;
                break;
            }
            this.updateRequest(new RequestDataConfiguration(request, methodParser, isJson, bodyContentObject), serializerAdapter);
        }
        return request;
    }

    public static HttpResponseException instantiateUnexpectedException(UnexpectedExceptionInformation exception, HttpResponse httpResponse, byte[] responseContent, Object responseDecodedContent) {
        StringBuilder exceptionMessage = new StringBuilder("Status code ").append(httpResponse.getStatusCode()).append(", ");
        String contentType = httpResponse.getHeaderValue(HttpHeaderName.CONTENT_TYPE);
        if ("application/octet-stream".equalsIgnoreCase(contentType)) {
            String contentLength = httpResponse.getHeaderValue(HttpHeaderName.CONTENT_LENGTH);
            exceptionMessage.append("(").append(contentLength).append("-byte body)");
        } else if (responseContent == null || responseContent.length == 0) {
            exceptionMessage.append("(empty body)");
        } else {
            exceptionMessage.append('\"').append(new String(responseContent, StandardCharsets.UTF_8)).append('\"');
        }
        if (responseDecodedContent instanceof IOException || responseDecodedContent instanceof MalformedValueException || responseDecodedContent instanceof IllegalStateException) {
            return new HttpResponseException(exceptionMessage.toString(), httpResponse, (Throwable)responseDecodedContent);
        }
        Class<? extends HttpResponseException> exceptionType = exception.getExceptionType();
        if (exceptionType == HttpResponseException.class) {
            return new HttpResponseException(exceptionMessage.toString(), httpResponse, responseDecodedContent);
        }
        if (exceptionType == ClientAuthenticationException.class) {
            return new ClientAuthenticationException(exceptionMessage.toString(), httpResponse, responseDecodedContent);
        }
        if (exceptionType == DecodeException.class) {
            return new DecodeException(exceptionMessage.toString(), httpResponse, responseDecodedContent);
        }
        if (exceptionType == ResourceExistsException.class) {
            return new ResourceExistsException(exceptionMessage.toString(), httpResponse, responseDecodedContent);
        }
        if (exceptionType == ResourceModifiedException.class) {
            return new ResourceModifiedException(exceptionMessage.toString(), httpResponse, responseDecodedContent);
        }
        if (exceptionType == ResourceNotFoundException.class) {
            return new ResourceNotFoundException(exceptionMessage.toString(), httpResponse, responseDecodedContent);
        }
        if (exceptionType == TooManyRedirectsException.class) {
            return new TooManyRedirectsException(exceptionMessage.toString(), httpResponse, responseDecodedContent);
        }
        try {
            ReflectiveInvoker reflectiveInvoker = RESPONSE_EXCEPTION_CONSTRUCTOR_CACHE.get(exceptionType, exception.getExceptionBodyType());
            return ResponseExceptionConstructorCache.invoke(reflectiveInvoker, exceptionMessage.toString(), httpResponse, responseDecodedContent);
        }
        catch (RuntimeException e) {
            exceptionMessage.append(". An instance of ").append(exceptionType.getCanonicalName()).append(" couldn't be created.");
            HttpResponseException exception1 = new HttpResponseException(exceptionMessage.toString(), httpResponse, responseDecodedContent);
            exception1.addSuppressed(e);
            return exception1;
        }
    }
}

