/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.SemanticVersion;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.cfg.PackageVersion;

final class JacksonVersion {
    private static final String CORE_PACKAGE_NAME = "jackson-core";
    private static final String DATABIND_PACKAGE_NAME = "jackson-databind";
    private static final String XML_PACKAGE_NAME = "jackson-dataformat-xml";
    private static final String JSR310_PACKAGE_NAME = "jackson-datatype-jsr310";
    private static final String TROUBLESHOOTING_DOCS_LINK = "https://aka.ms/azsdk/java/dependency/troubleshoot";
    private static final SemanticVersion MIN_SUPPORTED_VERSION;
    private static final int MAX_SUPPORTED_MAJOR_VERSION = 2;
    private static final String AZURE_CORE_PROPERTIES_NAME = "azure-core.properties";
    private static final String AZURE_CORE_PROPERTIES_VERSION_KEY = "version";
    private static final String AZURE_CORE_VERSION;
    private static final ClientLogger LOGGER;
    private static final String HELP_STRING;

    private JacksonVersion() {
    }

    public static String getHelpInfo() {
        return HELP_STRING;
    }

    private static void checkVersion(SemanticVersion version, String packageName) {
        if (!version.isValid()) {
            LOGGER.log(LogLevel.VERBOSE, () -> "Could not find version of '" + packageName + "'.");
            return;
        }
        if (version.compareTo(MIN_SUPPORTED_VERSION) < 0) {
            LOGGER.log(LogLevel.WARNING, () -> "Version '" + version + "' of package '" + packageName + "' is not supported (older than earliest supported version - '" + MIN_SUPPORTED_VERSION + "'). It may result in runtime exceptions during serialization. Please consider updating Jackson to one of the supported versions " + TROUBLESHOOTING_DOCS_LINK);
        }
        if (version.getMajorVersion() > 2) {
            LOGGER.log(LogLevel.WARNING, () -> "Major version '" + version + "' of package '" + packageName + "' is newer than latest supported version - '" + 2 + "'. It may result in runtime exceptions during serialization.");
        }
    }

    static {
        SemanticVersion xmlVersion1;
        MIN_SUPPORTED_VERSION = SemanticVersion.parse("2.10.0");
        AZURE_CORE_VERSION = CoreUtils.getProperties(AZURE_CORE_PROPERTIES_NAME).getOrDefault(AZURE_CORE_PROPERTIES_VERSION_KEY, "unknown");
        LOGGER = new ClientLogger(JacksonVersion.class);
        SemanticVersion coreVersion = SemanticVersion.parse(org.apache.pinot.shaded.com.fasterxml.jackson.core.json.PackageVersion.VERSION.toString());
        SemanticVersion databindVersion = SemanticVersion.parse(PackageVersion.VERSION.toString());
        SemanticVersion jsr310Version = SemanticVersion.parse(org.apache.pinot.shaded.com.fasterxml.jackson.datatype.jsr310.PackageVersion.VERSION.toString());
        try {
            Class<?> xmlPackageVersion = Class.forName("org.apache.pinot.shaded.com.fasterxml.jackson.dataformat.xml.PackageVersion");
            xmlVersion1 = SemanticVersion.parse(xmlPackageVersion.getDeclaredField("VERSION").get(null).toString());
        }
        catch (ReflectiveOperationException e) {
            xmlVersion1 = SemanticVersion.createInvalid();
        }
        SemanticVersion xmlVersion = xmlVersion1;
        JacksonVersion.checkVersion(coreVersion, CORE_PACKAGE_NAME);
        JacksonVersion.checkVersion(databindVersion, DATABIND_PACKAGE_NAME);
        JacksonVersion.checkVersion(xmlVersion, XML_PACKAGE_NAME);
        JacksonVersion.checkVersion(jsr310Version, JSR310_PACKAGE_NAME);
        HELP_STRING = "Package versions: jackson-core=" + coreVersion.getVersionString() + ", " + DATABIND_PACKAGE_NAME + "=" + databindVersion.getVersionString() + ", " + XML_PACKAGE_NAME + "=" + xmlVersion.getVersionString() + ", " + JSR310_PACKAGE_NAME + "=" + jsr310Version.getVersionString() + ", azure-core=" + AZURE_CORE_VERSION + ", Troubleshooting version conflicts: " + TROUBLESHOOTING_DOCS_LINK;
        LOGGER.info(HELP_STRING);
    }
}

