/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common;

import com.azure.core.exception.UnexpectedLengthException;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public final class Utility {
    private static final ClientLogger LOGGER = new ClientLogger(Utility.class);
    public static final String STORAGE_TRACING_NAMESPACE_VALUE = "Microsoft.Storage";

    public static String urlDecode(String stringToDecode) {
        if (CoreUtils.isNullOrEmpty(stringToDecode)) {
            return "";
        }
        int lastIndexOfPlus = 0;
        int indexOfPlus = stringToDecode.indexOf(43);
        if (indexOfPlus == -1) {
            return Utility.decode(stringToDecode);
        }
        StringBuilder outBuilder = new StringBuilder(stringToDecode.length());
        do {
            outBuilder.append(Utility.decode(stringToDecode.substring(lastIndexOfPlus, indexOfPlus)));
            outBuilder.append('+');
        } while ((indexOfPlus = stringToDecode.indexOf(43, lastIndexOfPlus = indexOfPlus + 1)) != -1);
        if (lastIndexOfPlus != stringToDecode.length()) {
            outBuilder.append(Utility.decode(stringToDecode.substring(lastIndexOfPlus)));
        }
        return outBuilder.toString();
    }

    private static String decode(String stringToDecode) {
        try {
            return URLDecoder.decode(stringToDecode, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String urlEncode(String stringToEncode) {
        if (stringToEncode == null) {
            return null;
        }
        if (stringToEncode.isEmpty()) {
            return "";
        }
        int lastIndexOfSpace = 0;
        int indexOfSpace = stringToEncode.indexOf(32);
        if (indexOfSpace == -1) {
            return Utility.encode(stringToEncode);
        }
        StringBuilder outBuilder = new StringBuilder(stringToEncode.length() * 2);
        do {
            outBuilder.append(Utility.encode(stringToEncode.substring(lastIndexOfSpace, indexOfSpace)));
            outBuilder.append("%20");
        } while ((indexOfSpace = stringToEncode.indexOf(32, lastIndexOfSpace = indexOfSpace + 1)) != -1);
        if (lastIndexOfSpace != stringToEncode.length()) {
            outBuilder.append(Utility.encode(stringToEncode.substring(lastIndexOfSpace)));
        }
        return outBuilder.toString();
    }

    private static String encode(String stringToEncode) {
        try {
            return URLEncoder.encode(stringToEncode, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String encodeUrlPath(String url) {
        UrlBuilder builder = UrlBuilder.parse(url);
        String path = builder.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        path = Utility.urlEncode(Utility.urlDecode(path));
        builder.setPath(path);
        return builder.toString();
    }

    @Deprecated
    public static OffsetDateTime parseDate(String dateString) {
        return StorageImplUtils.parseDateAndFormat(dateString).getDateTime();
    }

    public static Flux<ByteBuffer> convertStreamToByteBuffer(InputStream data, long length, int blockSize) {
        return Utility.convertStreamToByteBuffer(data, length, blockSize, true);
    }

    public static Flux<ByteBuffer> convertStreamToByteBuffer(InputStream data, long length, int blockSize, boolean markAndReset) {
        if (markAndReset) {
            data.mark(Integer.MAX_VALUE);
        }
        if (length == 0L) {
            try {
                if (data.read() != -1) {
                    long totalLength = 1 + data.available();
                    return FluxUtil.fluxError(LOGGER, new UnexpectedLengthException(String.format("Request body emitted %d bytes, more than the expected %d bytes.", totalLength, length), totalLength, length));
                }
            }
            catch (IOException e) {
                return FluxUtil.fluxError(LOGGER, new UncheckedIOException(e));
            }
        }
        return Flux.defer(() -> {
            if (markAndReset) {
                try {
                    data.reset();
                }
                catch (IOException e) {
                    return FluxUtil.fluxError(LOGGER, new UncheckedIOException(e));
                }
            }
            long[] currentTotalLength = new long[1];
            return Flux.generate(() -> data, (is, sink) -> {
                long pos = currentTotalLength[0];
                long count = pos + (long)blockSize > length ? length - pos : (long)blockSize;
                byte[] cache = new byte[(int)count];
                int numOfBytes = 0;
                int offset = 0;
                int len = (int)count;
                while (numOfBytes != -1 && (long)offset < count) {
                    try {
                        numOfBytes = data.read(cache, offset, len);
                        if (numOfBytes == -1) continue;
                        offset += numOfBytes;
                        len -= numOfBytes;
                        currentTotalLength[0] = currentTotalLength[0] + (long)numOfBytes;
                    }
                    catch (IOException e) {
                        sink.error(e);
                        return is;
                    }
                }
                if (numOfBytes == -1 && currentTotalLength[0] < length) {
                    sink.error(LOGGER.logExceptionAsError(new UnexpectedLengthException(String.format("Request body emitted %d bytes, less than the expected %d bytes.", currentTotalLength[0], length), currentTotalLength[0], length)));
                    return is;
                }
                if (currentTotalLength[0] >= length) {
                    try {
                        if (data.read() != -1) {
                            long totalLength = 1L + currentTotalLength[0] + (long)data.available();
                            sink.error(LOGGER.logExceptionAsError(new UnexpectedLengthException(String.format("Request body emitted %d bytes, more than the expected %d bytes.", totalLength, length), totalLength, length)));
                            return is;
                        }
                        if (currentTotalLength[0] > length) {
                            sink.error(LOGGER.logExceptionAsError(new IllegalStateException(String.format("Read more data than was requested. Size of data read: %d. Size of data requested: %d", currentTotalLength[0], length))));
                            return is;
                        }
                    }
                    catch (IOException e) {
                        sink.error(LOGGER.logExceptionAsError(new RuntimeException("I/O errors occurred", e)));
                        return is;
                    }
                }
                sink.next(ByteBuffer.wrap(cache, 0, offset));
                if (currentTotalLength[0] == length) {
                    sink.complete();
                }
                return is;
            });
        }).subscribeOn(Schedulers.boundedElastic());
    }

    public static String appendQueryParameter(String url, String key, String value) {
        return url.indexOf(63) != -1 ? url + "&" + key + "=" + value : url + "?" + key + "=" + value;
    }
}

