/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.client.DefaultNoHARMFailoverProxyProvider;
import org.apache.hadoop.yarn.client.RMProxy;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AutoRefreshNoHARMFailoverProxyProvider<T>
extends DefaultNoHARMFailoverProxyProvider<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AutoRefreshNoHARMFailoverProxyProvider.class);
    protected RMProxy<T> rmProxy;
    protected YarnConfiguration conf;

    @Override
    public void init(Configuration configuration, RMProxy<T> rmProxy, Class<T> protocol) {
        this.rmProxy = rmProxy;
        this.protocol = protocol;
        this.conf = new YarnConfiguration(configuration);
    }

    @Override
    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        if (this.proxy == null) {
            this.proxy = this.getProxyInternal();
        }
        return new FailoverProxyProvider.ProxyInfo(this.proxy, null);
    }

    protected T getProxyInternal() {
        try {
            InetSocketAddress rmAddress = this.rmProxy.getRMAddress(this.conf, this.protocol);
            return this.rmProxy.getProxy(this.conf, this.protocol, rmAddress);
        }
        catch (IOException ioe) {
            LOG.error("Unable to create proxy to the ResourceManager", (Object)ioe.getMessage());
            return null;
        }
    }

    @Override
    public synchronized void performFailover(T currentProxy) {
        RPC.stopProxy((Object)this.proxy);
        this.proxy = null;
    }
}

