/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.collections4.MapUtils;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.core.segment.processing.framework.MergeType;
import org.apache.pinot.core.segment.processing.framework.SegmentConfig;
import org.apache.pinot.core.segment.processing.partitioner.PartitionerConfig;
import org.apache.pinot.core.segment.processing.partitioner.PartitionerFactory;
import org.apache.pinot.core.segment.processing.timehandler.TimeHandler;
import org.apache.pinot.core.segment.processing.timehandler.TimeHandlerConfig;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.config.table.ColumnPartitionConfig;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.TimeUtils;

public class MergeTaskUtils {
    private static final int AGGREGATION_TYPE_KEY_SUFFIX_LENGTH = ".aggregationType".length();

    private MergeTaskUtils() {
    }

    @Nullable
    public static TimeHandlerConfig getTimeHandlerConfig(TableConfig tableConfig, Schema schema, Map<String, String> taskConfig) {
        String partitionBucketTimePeriod;
        String roundBucketTimePeriod;
        String timeColumn = tableConfig.getValidationConfig().getTimeColumnName();
        if (timeColumn == null) {
            return null;
        }
        DateTimeFieldSpec fieldSpec = schema.getSpecForTimeColumn(timeColumn);
        Preconditions.checkState((fieldSpec != null ? 1 : 0) != 0, (String)"No valid spec found for time column: %s in schema for table: %s", (Object)timeColumn, (Object)tableConfig.getTableName());
        TimeHandlerConfig.Builder timeHandlerConfigBuilder = new TimeHandlerConfig.Builder(TimeHandler.Type.EPOCH);
        String windowStartMs = taskConfig.get("windowStartMs");
        String windowEndMs = taskConfig.get("windowEndMs");
        if (windowStartMs != null && windowEndMs != null) {
            timeHandlerConfigBuilder.setTimeRange(Long.parseLong(windowStartMs), Long.parseLong(windowEndMs)).setNegateWindowFilter(Boolean.parseBoolean(taskConfig.get("negateWindowFilter")));
        }
        if ((roundBucketTimePeriod = taskConfig.get("roundBucketTimePeriod")) != null) {
            timeHandlerConfigBuilder.setRoundBucketMs(TimeUtils.convertPeriodToMillis((String)roundBucketTimePeriod).longValue());
        }
        if ((partitionBucketTimePeriod = taskConfig.get("partitionBucketTimePeriod")) != null) {
            timeHandlerConfigBuilder.setPartitionBucketMs(TimeUtils.convertPeriodToMillis((String)partitionBucketTimePeriod).longValue());
        }
        return timeHandlerConfigBuilder.build();
    }

    public static List<PartitionerConfig> getPartitionerConfigs(TableConfig tableConfig, Schema schema, Map<String, String> taskConfig) {
        SegmentPartitionConfig segmentPartitionConfig = tableConfig.getIndexingConfig().getSegmentPartitionConfig();
        if (segmentPartitionConfig == null) {
            return Collections.emptyList();
        }
        ArrayList<PartitionerConfig> partitionerConfigs = new ArrayList<PartitionerConfig>();
        Map columnPartitionMap = segmentPartitionConfig.getColumnPartitionMap();
        for (Map.Entry entry : columnPartitionMap.entrySet()) {
            String partitionColumn = (String)entry.getKey();
            Preconditions.checkState((boolean)schema.hasColumn(partitionColumn), (String)"Partition column: %s does not exist in the schema for table: %s", (Object)partitionColumn, (Object)tableConfig.getTableName());
            PartitionerConfig partitionerConfig = new PartitionerConfig.Builder().setPartitionerType(PartitionerFactory.PartitionerType.TABLE_PARTITION_CONFIG).setColumnName(partitionColumn).setColumnPartitionConfig((ColumnPartitionConfig)entry.getValue()).build();
            partitionerConfigs.add(partitionerConfig);
        }
        return partitionerConfigs;
    }

    @Nullable
    public static MergeType getMergeType(Map<String, String> taskConfig) {
        String mergeType = taskConfig.get("mergeType");
        return mergeType != null ? MergeType.valueOf((String)mergeType.toUpperCase()) : null;
    }

    public static Map<String, AggregationFunctionType> getAggregationTypes(Map<String, String> taskConfig) {
        HashMap<String, AggregationFunctionType> aggregationTypes = new HashMap<String, AggregationFunctionType>();
        for (Map.Entry<String, String> entry : taskConfig.entrySet()) {
            String key = entry.getKey();
            if (!key.endsWith(".aggregationType")) continue;
            String column = key.substring(0, key.length() - AGGREGATION_TYPE_KEY_SUFFIX_LENGTH);
            aggregationTypes.put(column, AggregationFunctionType.getAggregationFunctionType((String)entry.getValue()));
        }
        return aggregationTypes;
    }

    public static SegmentConfig getSegmentConfig(Map<String, String> taskConfig) {
        String segmentMapperFileSizeThreshold;
        SegmentConfig.Builder segmentConfigBuilder = new SegmentConfig.Builder();
        String maxNumRecordsPerSegment = taskConfig.get("maxNumRecordsPerSegment");
        if (maxNumRecordsPerSegment != null) {
            segmentConfigBuilder.setMaxNumRecordsPerSegment(Integer.parseInt(maxNumRecordsPerSegment));
        }
        if ((segmentMapperFileSizeThreshold = taskConfig.get("segmentMapperFileSizeThresholdInBytes")) != null) {
            segmentConfigBuilder.setIntermediateFileSizeThreshold(Long.parseLong(segmentMapperFileSizeThreshold));
        }
        segmentConfigBuilder.setSegmentNamePrefix(taskConfig.get("segmentNamePrefix"));
        segmentConfigBuilder.setSegmentNamePostfix(taskConfig.get("segmentNamePostfix"));
        segmentConfigBuilder.setFixedSegmentName(taskConfig.get("fixedSegmentName"));
        return segmentConfigBuilder.build();
    }

    public static boolean allowMerge(SegmentZKMetadata segmentZKMetadata) {
        Map customMap = segmentZKMetadata.getCustomMap();
        return MapUtils.isEmpty((Map)customMap) || !Boolean.parseBoolean((String)customMap.get("shouldNotMerge"));
    }
}

