/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.mergerollup;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.recordtransformer.RecordTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimensionValueTransformer
implements RecordTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DimensionValueTransformer.class);
    private final Map<String, Object> _dimensionValues = new HashMap<String, Object>();

    public DimensionValueTransformer(Schema schema, Set<String> dimensionsToErase) {
        for (String dimension : dimensionsToErase) {
            FieldSpec fieldSpec = schema.getFieldSpecFor(dimension);
            if (fieldSpec == null) {
                LOGGER.warn("Dimension name: {} does not exist in schema and will be ignored.", (Object)dimension);
                continue;
            }
            Object defaultNullValue = fieldSpec.getDefaultNullValue();
            if (fieldSpec.isSingleValueField()) {
                this._dimensionValues.put(dimension, defaultNullValue);
                continue;
            }
            this._dimensionValues.put(dimension, new Object[]{defaultNullValue});
        }
    }

    public boolean isNoOp() {
        return this._dimensionValues.isEmpty();
    }

    public void transform(GenericRow record) {
        for (Map.Entry<String, Object> entry : this._dimensionValues.entrySet()) {
            record.putDefaultNullValue(entry.getKey(), entry.getValue());
        }
    }
}

