/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.mergerollup;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.core.segment.processing.framework.SegmentProcessorConfig;
import org.apache.pinot.core.segment.processing.framework.SegmentProcessorFramework;
import org.apache.pinot.minion.MinionConf;
import org.apache.pinot.plugin.minion.tasks.BaseMultipleSegmentsConversionExecutor;
import org.apache.pinot.plugin.minion.tasks.MergeTaskUtils;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.plugin.minion.tasks.mergerollup.DimensionValueTransformer;
import org.apache.pinot.plugin.minion.tasks.mergerollup.MergeRollupTaskUtils;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.Obfuscator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeRollupTaskExecutor
extends BaseMultipleSegmentsConversionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergeRollupTaskExecutor.class);

    public MergeRollupTaskExecutor(MinionConf minionConf) {
        super(minionConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<SegmentConversionResult> convert(PinotTaskConfig pinotTaskConfig, List<File> segmentDirs, File workingDir) throws Exception {
        List outputSegmentDirs;
        int numInputSegments = segmentDirs.size();
        this._eventObserver.notifyProgress(pinotTaskConfig, (Object)("Converting segments: " + numInputSegments));
        String taskType = pinotTaskConfig.getTaskType();
        Map configs = pinotTaskConfig.getConfigs();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Starting task: {} with configs: {}", (Object)taskType, (Object)Obfuscator.DEFAULT.toJsonString((Object)configs));
        }
        long startMillis = System.currentTimeMillis();
        String tableNameWithType = (String)configs.get("tableName");
        TableConfig tableConfig = this.getTableConfig(tableNameWithType);
        Schema schema = this.getSchema(tableNameWithType);
        Set<String> dimensionsToErase = MergeRollupTaskUtils.getDimensionsToErase(configs);
        ArrayList<DimensionValueTransformer> customRecordTransformers = new ArrayList<DimensionValueTransformer>();
        if (!dimensionsToErase.isEmpty()) {
            customRecordTransformers.add(new DimensionValueTransformer(schema, dimensionsToErase));
        }
        SegmentProcessorConfig.Builder segmentProcessorConfigBuilder = new SegmentProcessorConfig.Builder().setTableConfig(tableConfig).setSchema(schema);
        segmentProcessorConfigBuilder.setTimeHandlerConfig(MergeTaskUtils.getTimeHandlerConfig(tableConfig, schema, configs));
        segmentProcessorConfigBuilder.setPartitionerConfigs(MergeTaskUtils.getPartitionerConfigs(tableConfig, schema, configs));
        segmentProcessorConfigBuilder.setMergeType(MergeTaskUtils.getMergeType(configs));
        segmentProcessorConfigBuilder.setAggregationTypes(MergeTaskUtils.getAggregationTypes(configs));
        segmentProcessorConfigBuilder.setAggregationFunctionParameters(MergeRollupTaskUtils.getAggregationFunctionParameters(configs));
        segmentProcessorConfigBuilder.setSegmentConfig(MergeTaskUtils.getSegmentConfig(configs));
        segmentProcessorConfigBuilder.setProgressObserver(p -> this._eventObserver.notifyProgress(this._pinotTaskConfig, p));
        SegmentProcessorConfig segmentProcessorConfig = segmentProcessorConfigBuilder.build();
        ArrayList<PinotSegmentRecordReader> recordReaders = new ArrayList<PinotSegmentRecordReader>(numInputSegments);
        int count = 1;
        for (File segmentDir : segmentDirs) {
            this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Creating RecordReader for: " + String.valueOf(segmentDir) + " (" + count++ + " out of " + numInputSegments + ")"));
            PinotSegmentRecordReader recordReader = new PinotSegmentRecordReader();
            recordReader.init(segmentDir, null, null, true);
            recordReaders.add(recordReader);
        }
        try {
            this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)"Generating segments");
            SegmentProcessorFramework framework = new SegmentProcessorFramework(segmentProcessorConfig, workingDir, SegmentProcessorFramework.convertRecordReadersToRecordReaderFileConfig(recordReaders), customRecordTransformers, null);
            outputSegmentDirs = framework.process();
            this._eventObserver.notifyProgress(pinotTaskConfig, (Object)("Segment processing stats - incomplete rows:" + framework.getIncompleteRowsFound() + ", dropped rows:" + framework.getSkippedRowsFound() + ", sanitized rows:" + framework.getSanitizedRowsFound()));
        }
        finally {
            for (PinotSegmentRecordReader recordReader : recordReaders) {
                recordReader.close();
            }
        }
        long endMillis = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Finished task: {} with configs: {}. Total time: {}ms", new Object[]{taskType, Obfuscator.DEFAULT.toJsonString((Object)configs), endMillis - startMillis});
        }
        ArrayList<SegmentConversionResult> results = new ArrayList<SegmentConversionResult>();
        for (File outputSegmentDir : outputSegmentDirs) {
            String outputSegmentName = outputSegmentDir.getName();
            results.add(new SegmentConversionResult.Builder().setFile(outputSegmentDir).setSegmentName(outputSegmentName).setTableNameWithType(tableNameWithType).build());
        }
        return results;
    }

    @Override
    protected SegmentZKMetadataCustomMapModifier getSegmentZKMetadataCustomMapModifier(PinotTaskConfig pinotTaskConfig, SegmentConversionResult segmentConversionResult) {
        TreeMap<String, String> updateMap = new TreeMap<String, String>();
        updateMap.put("MergeRollupTask.mergeLevel", (String)pinotTaskConfig.getConfigs().get("mergeLevel"));
        updateMap.put("MergeRollupTask.time", String.valueOf(System.currentTimeMillis()));
        return new SegmentZKMetadataCustomMapModifier(SegmentZKMetadataCustomMapModifier.ModifyMode.UPDATE, updateMap);
    }
}

