/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.realtimetoofflinesegments;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.minion.BaseTaskMetadata;
import org.apache.pinot.common.minion.RealtimeToOfflineSegmentsTaskMetadata;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoAccessor;
import org.apache.pinot.controller.helix.core.minion.generator.BaseTaskGenerator;
import org.apache.pinot.controller.helix.core.minion.generator.TaskGeneratorUtils;
import org.apache.pinot.core.common.MinionConstants;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.core.segment.processing.framework.MergeType;
import org.apache.pinot.plugin.minion.tasks.MinionTaskUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.annotations.minion.TaskGenerator;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableTaskConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TaskGenerator
public class RealtimeToOfflineSegmentsTaskGenerator
extends BaseTaskGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealtimeToOfflineSegmentsTaskGenerator.class);
    private static final String DEFAULT_BUCKET_PERIOD = "1d";
    private static final String DEFAULT_BUFFER_PERIOD = "2d";

    public String getTaskType() {
        return "RealtimeToOfflineSegmentsTask";
    }

    public List<PinotTaskConfig> generateTasks(List<TableConfig> tableConfigs) {
        String taskType = "RealtimeToOfflineSegmentsTask";
        ArrayList<PinotTaskConfig> pinotTaskConfigs = new ArrayList<PinotTaskConfig>();
        for (TableConfig tableConfig : tableConfigs) {
            String mergeType;
            String realtimeTableName = tableConfig.getTableName();
            if (tableConfig.getTableType() != TableType.REALTIME) {
                LOGGER.warn("Skip generating task: {} for non-REALTIME table: {}", (Object)taskType, (Object)realtimeTableName);
                continue;
            }
            LOGGER.info("Start generating task configs for table: {} for task: {}", (Object)realtimeTableName, (Object)taskType);
            Map incompleteTasks = TaskGeneratorUtils.getIncompleteTasks((String)taskType, (String)realtimeTableName, (ClusterInfoAccessor)this._clusterInfoAccessor);
            if (!incompleteTasks.isEmpty()) {
                LOGGER.warn("Found incomplete tasks: {} for same table: {} and task type: {}. Skipping task generation.", new Object[]{incompleteTasks.keySet(), realtimeTableName, taskType});
                continue;
            }
            ArrayList<SegmentZKMetadata> completedSegmentsZKMetadata = new ArrayList<SegmentZKMetadata>();
            HashMap<Integer, String> partitionToLatestLLCSegmentName = new HashMap<Integer, String>();
            HashSet<Integer> allPartitions = new HashSet<Integer>();
            this.getCompletedSegmentsInfo(realtimeTableName, completedSegmentsZKMetadata, partitionToLatestLLCSegmentName, allPartitions);
            if (completedSegmentsZKMetadata.isEmpty()) {
                LOGGER.info("No realtime-completed segments found for table: {}, skipping task generation: {}", (Object)realtimeTableName, (Object)taskType);
                continue;
            }
            allPartitions.removeAll(partitionToLatestLLCSegmentName.keySet());
            if (!allPartitions.isEmpty()) {
                LOGGER.info("Partitions: {} have no completed segments. Table: {} is not ready for {}. Skipping task generation.", new Object[]{allPartitions, realtimeTableName, taskType});
                continue;
            }
            TableTaskConfig tableTaskConfig = tableConfig.getTaskConfig();
            Preconditions.checkState((tableTaskConfig != null ? 1 : 0) != 0);
            Map taskConfigs = tableTaskConfig.getConfigsForTaskType(taskType);
            Preconditions.checkState((taskConfigs != null ? 1 : 0) != 0, (String)"Task config shouldn't be null for table: %s", (Object)realtimeTableName);
            String bucketTimePeriod = taskConfigs.getOrDefault("bucketTimePeriod", DEFAULT_BUCKET_PERIOD);
            String bufferTimePeriod = taskConfigs.getOrDefault("bufferTimePeriod", DEFAULT_BUFFER_PERIOD);
            long bucketMs = TimeUtils.convertPeriodToMillis((String)bucketTimePeriod);
            long bufferMs = TimeUtils.convertPeriodToMillis((String)bufferTimePeriod);
            long windowStartMs = this.getWatermarkMs(realtimeTableName, completedSegmentsZKMetadata, bucketMs);
            long windowEndMs = windowStartMs + bucketMs;
            ArrayList<String> segmentNames = new ArrayList<String>();
            ArrayList<String> downloadURLs = new ArrayList<String>();
            HashSet lastLLCSegmentPerPartition = new HashSet(partitionToLatestLLCSegmentName.values());
            boolean skipGenerate = false;
            while (true) {
                if (windowEndMs > System.currentTimeMillis() - bufferMs) {
                    LOGGER.info("Window with start: {} and end: {} is not older than buffer time: {} configured as {} ago. Skipping task generation: {}", new Object[]{windowStartMs, windowEndMs, bufferMs, bufferTimePeriod, taskType});
                    skipGenerate = true;
                    break;
                }
                for (SegmentZKMetadata segmentZKMetadata : completedSegmentsZKMetadata) {
                    String segmentName = segmentZKMetadata.getSegmentName();
                    long segmentStartTimeMs = segmentZKMetadata.getStartTimeMs();
                    long segmentEndTimeMs = segmentZKMetadata.getEndTimeMs();
                    if (windowStartMs > segmentEndTimeMs || segmentStartTimeMs >= windowEndMs) continue;
                    if (lastLLCSegmentPerPartition.contains(segmentName) && segmentEndTimeMs < windowEndMs) {
                        LOGGER.info("Window data overflows into CONSUMING segments for partition of segment: {}. Skipping task generation: {}", (Object)segmentName, (Object)taskType);
                        skipGenerate = true;
                        break;
                    }
                    segmentNames.add(segmentName);
                    downloadURLs.add(segmentZKMetadata.getDownloadUrl());
                }
                if (skipGenerate || !segmentNames.isEmpty()) break;
                LOGGER.info("Found no eligible segments for task: {} with window [{} - {}), moving to the next time bucket", new Object[]{taskType, windowStartMs, windowEndMs});
                windowStartMs = windowEndMs;
                windowEndMs += bucketMs;
            }
            if (skipGenerate) continue;
            Map<String, String> configs = MinionTaskUtils.getPushTaskConfig(realtimeTableName, taskConfigs, this._clusterInfoAccessor);
            configs.putAll(this.getBaseTaskConfigs(tableConfig, segmentNames));
            configs.put("downloadURL", StringUtils.join(downloadURLs, (String)","));
            configs.put("uploadURL", this._clusterInfoAccessor.getVipUrl() + "/segments");
            configs.put("windowStartMs", String.valueOf(windowStartMs));
            configs.put("windowEndMs", String.valueOf(windowEndMs));
            String roundBucketTimePeriod = (String)taskConfigs.get("roundBucketTimePeriod");
            if (roundBucketTimePeriod != null) {
                configs.put("roundBucketTimePeriod", roundBucketTimePeriod);
            }
            if ((mergeType = (String)taskConfigs.get("mergeType")) == null) {
                mergeType = (String)taskConfigs.get("collectorType");
            }
            if (mergeType != null) {
                configs.put("mergeType", mergeType);
                configs.put("collectorType", mergeType);
            }
            for (Map.Entry entry : taskConfigs.entrySet()) {
                if (!((String)entry.getKey()).endsWith(".aggregationType")) continue;
                configs.put((String)entry.getKey(), (String)entry.getValue());
            }
            String maxNumRecordsPerSegment = (String)taskConfigs.get("maxNumRecordsPerSegment");
            if (maxNumRecordsPerSegment != null) {
                configs.put("maxNumRecordsPerSegment", maxNumRecordsPerSegment);
            }
            pinotTaskConfigs.add(new PinotTaskConfig(taskType, configs));
            LOGGER.info("Finished generating task configs for table: {} for task: {}", (Object)realtimeTableName, (Object)taskType);
        }
        return pinotTaskConfigs;
    }

    private void getCompletedSegmentsInfo(String realtimeTableName, List<SegmentZKMetadata> completedSegmentsZKMetadata, Map<Integer, String> partitionToLatestLLCSegmentName, Set<Integer> allPartitions) {
        List segmentsZKMetadata = this.getNonConsumingSegmentsZKMetadataForRealtimeTable(realtimeTableName);
        HashMap<Integer, LLCSegmentName> latestLLCSegmentNameMap = new HashMap<Integer, LLCSegmentName>();
        for (SegmentZKMetadata segmentZKMetadata : segmentsZKMetadata) {
            completedSegmentsZKMetadata.add(segmentZKMetadata);
            LLCSegmentName llcSegmentName = LLCSegmentName.of((String)segmentZKMetadata.getSegmentName());
            if (llcSegmentName == null) continue;
            int partitionId = llcSegmentName.getPartitionGroupId();
            allPartitions.add(partitionId);
            latestLLCSegmentNameMap.compute(partitionId, (k, latestLLCSegmentName) -> {
                if (latestLLCSegmentName == null || llcSegmentName.getSequenceNumber() > latestLLCSegmentName.getSequenceNumber()) {
                    return llcSegmentName;
                }
                return latestLLCSegmentName;
            });
        }
        for (Map.Entry entry : latestLLCSegmentNameMap.entrySet()) {
            partitionToLatestLLCSegmentName.put((Integer)entry.getKey(), ((LLCSegmentName)entry.getValue()).getSegmentName());
        }
    }

    private long getWatermarkMs(String realtimeTableName, List<SegmentZKMetadata> completedSegmentsZKMetadata, long bucketMs) {
        RealtimeToOfflineSegmentsTaskMetadata realtimeToOfflineSegmentsTaskMetadata;
        ZNRecord realtimeToOfflineZNRecord = this._clusterInfoAccessor.getMinionTaskMetadataZNRecord("RealtimeToOfflineSegmentsTask", realtimeTableName);
        RealtimeToOfflineSegmentsTaskMetadata realtimeToOfflineSegmentsTaskMetadata2 = realtimeToOfflineSegmentsTaskMetadata = realtimeToOfflineZNRecord != null ? RealtimeToOfflineSegmentsTaskMetadata.fromZNRecord((ZNRecord)realtimeToOfflineZNRecord) : null;
        if (realtimeToOfflineSegmentsTaskMetadata == null) {
            long minStartTimeMs = Long.MAX_VALUE;
            for (SegmentZKMetadata segmentZKMetadata : completedSegmentsZKMetadata) {
                minStartTimeMs = Math.min(minStartTimeMs, segmentZKMetadata.getStartTimeMs());
            }
            Preconditions.checkState((minStartTimeMs != Long.MAX_VALUE ? 1 : 0) != 0);
            long watermarkMs = minStartTimeMs / bucketMs * bucketMs;
            realtimeToOfflineSegmentsTaskMetadata = new RealtimeToOfflineSegmentsTaskMetadata(realtimeTableName, watermarkMs);
            this._clusterInfoAccessor.setMinionTaskMetadata((BaseTaskMetadata)realtimeToOfflineSegmentsTaskMetadata, "RealtimeToOfflineSegmentsTask", -1);
        }
        return realtimeToOfflineSegmentsTaskMetadata.getWatermarkMs();
    }

    public void validateTaskConfigs(TableConfig tableConfig, Schema schema, Map<String, String> taskConfigs) {
        Preconditions.checkState((tableConfig.getUpsertMode() == UpsertConfig.Mode.NONE ? 1 : 0) != 0, (Object)"RealtimeToOfflineTask doesn't support upsert table!");
        TimeUtils.convertPeriodToMillis((String)taskConfigs.getOrDefault("bufferTimePeriod", DEFAULT_BUFFER_PERIOD));
        TimeUtils.convertPeriodToMillis((String)taskConfigs.getOrDefault("bucketTimePeriod", DEFAULT_BUCKET_PERIOD));
        TimeUtils.convertPeriodToMillis((String)taskConfigs.getOrDefault("roundBucketTimePeriod", "1s"));
        Preconditions.checkState((boolean)ImmutableSet.of((Object)MergeType.CONCAT.name(), (Object)MergeType.ROLLUP.name(), (Object)MergeType.DEDUP.name()).contains((Object)taskConfigs.getOrDefault("mergeType", MergeType.CONCAT.name()).toUpperCase()), (Object)"MergeType must be one of [CONCAT, ROLLUP, DEDUP]!");
        Preconditions.checkNotNull((Object)schema, (Object)"Schema should not be null!");
        NavigableSet columnNames = schema.getColumnNames();
        for (Map.Entry<String, String> entry : taskConfigs.entrySet()) {
            if (!entry.getKey().endsWith(".aggregationType")) continue;
            Preconditions.checkState((boolean)columnNames.contains(StringUtils.removeEnd((String)entry.getKey(), (String)".aggregationType")), (Object)String.format("Column \"%s\" not found in schema!", entry.getKey()));
            try {
                AggregationFunctionType aft = AggregationFunctionType.getAggregationFunctionType((String)entry.getValue());
                if (MinionConstants.RealtimeToOfflineSegmentsTask.AVAILABLE_CORE_VALUE_AGGREGATORS.contains(aft)) continue;
                throw new IllegalArgumentException("ValueAggregator not enabled for type: " + aft.toString());
            }
            catch (IllegalArgumentException e) {
                String err = String.format("Column \"%s\" has invalid aggregate type: %s", entry.getKey(), entry.getValue());
                throw new IllegalStateException(err);
            }
        }
    }
}

