/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.Serializable;
import kafka.security.authorizer.AclEntry;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;

public final class AclEntry$ {
    public static AclEntry$ MODULE$;
    private final KafkaPrincipal WildcardPrincipal;
    private final String WildcardPrincipalString;
    private final String WildcardHost;
    private final String WildcardResource;
    private final String ResourceSeparator;
    private final Set<ResourceType> ResourceTypes;
    private final Set<AclOperation> AclOperations;
    private final String PrincipalKey;
    private final String PermissionTypeKey;
    private final String OperationKey;
    private final String HostsKey;
    private final String VersionKey;
    private final int CurrentVersion;
    private final String AclsKey;

    static {
        new AclEntry$();
    }

    public KafkaPrincipal WildcardPrincipal() {
        return this.WildcardPrincipal;
    }

    public String WildcardPrincipalString() {
        return this.WildcardPrincipalString;
    }

    public String WildcardHost() {
        return this.WildcardHost;
    }

    public String WildcardResource() {
        return this.WildcardResource;
    }

    public String ResourceSeparator() {
        return this.ResourceSeparator;
    }

    public Set<ResourceType> ResourceTypes() {
        return this.ResourceTypes;
    }

    public Set<AclOperation> AclOperations() {
        return this.AclOperations;
    }

    public String PrincipalKey() {
        return this.PrincipalKey;
    }

    public String PermissionTypeKey() {
        return this.PermissionTypeKey;
    }

    public String OperationKey() {
        return this.OperationKey;
    }

    public String HostsKey() {
        return this.HostsKey;
    }

    public String VersionKey() {
        return this.VersionKey;
    }

    public int CurrentVersion() {
        return this.CurrentVersion;
    }

    public String AclsKey() {
        return this.AclsKey;
    }

    public AclEntry apply(KafkaPrincipal principal, AclPermissionType permissionType, String host, AclOperation operation) {
        return new AclEntry(new AccessControlEntry(principal == null ? null : principal.toString(), host, operation, permissionType));
    }

    public Set<AclEntry> fromBytes(byte[] bytes) {
        if (bytes == null || new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).isEmpty()) {
            return Set$.MODULE$.empty();
        }
        return (Set)Json$.MODULE$.parseBytes(bytes).map((Function1<JsonValue, JsonObject> & Serializable & scala.Serializable)x$1 -> x$1.asJsonObject()).map((Function1<JsonObject, Set> & Serializable & scala.Serializable)js -> {
            Predef$.MODULE$.require(BoxesRunTime.unboxToInt(js.apply(MODULE$.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$)) == MODULE$.CurrentVersion());
            return js.apply(MODULE$.AclsKey()).asJsonArray().iterator().map((Function1<JsonValue, JsonObject> & Serializable & scala.Serializable)x$2 -> x$2.asJsonObject()).map((Function1<JsonObject, AclEntry> & Serializable & scala.Serializable)itemJs -> {
                KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal(itemJs.apply(MODULE$.PrincipalKey()).to(DecodeJson$DecodeString$.MODULE$));
                AclPermissionType permissionType = SecurityUtils.permissionType(itemJs.apply(MODULE$.PermissionTypeKey()).to(DecodeJson$DecodeString$.MODULE$));
                String host = itemJs.apply(MODULE$.HostsKey()).to(DecodeJson$DecodeString$.MODULE$);
                AclOperation operation = SecurityUtils.operation(itemJs.apply(MODULE$.OperationKey()).to(DecodeJson$DecodeString$.MODULE$));
                return MODULE$.apply(principal, permissionType, host, operation);
            }).toSet();
        }).getOrElse((Function0<Set> & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public Map<String, Object> toJsonCompatibleMap(Set<AclEntry> acls) {
        return (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.VersionKey()), BoxesRunTime.boxToInteger(this.CurrentVersion())), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.AclsKey()), CollectionConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)acls.map((Function1<AclEntry, java.util.Map> & Serializable & scala.Serializable)acl -> CollectionConverters$.MODULE$.mapAsJavaMapConverter(acl.toMap()).asJava(), Set$.MODULE$.canBuildFrom())).toList()).asJava())}));
    }

    public Set<AclOperation> supportedOperations(ResourceType resourceType) {
        Set set;
        if (((Object)((Object)ResourceType.TOPIC)).equals((Object)resourceType)) {
            set = (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DESCRIBE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS}));
        } else if (((Object)((Object)ResourceType.GROUP)).equals((Object)resourceType)) {
            set = (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE, AclOperation.DELETE}));
        } else if (((Object)((Object)ResourceType.CLUSTER)).equals((Object)resourceType)) {
            set = (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.CREATE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.ALTER, AclOperation.DESCRIBE}));
        } else if (((Object)((Object)ResourceType.TRANSACTIONAL_ID)).equals((Object)resourceType)) {
            set = (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE, AclOperation.WRITE}));
        } else if (((Object)((Object)ResourceType.DELEGATION_TOKEN)).equals((Object)resourceType)) {
            set = (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}));
        } else {
            throw new IllegalArgumentException("Not a concrete resource type");
        }
        return set;
    }

    public Errors authorizationError(ResourceType resourceType) {
        Errors errors;
        if (((Object)((Object)ResourceType.TOPIC)).equals((Object)resourceType)) {
            errors = Errors.TOPIC_AUTHORIZATION_FAILED;
        } else if (((Object)((Object)ResourceType.GROUP)).equals((Object)resourceType)) {
            errors = Errors.GROUP_AUTHORIZATION_FAILED;
        } else if (((Object)((Object)ResourceType.CLUSTER)).equals((Object)resourceType)) {
            errors = Errors.CLUSTER_AUTHORIZATION_FAILED;
        } else if (((Object)((Object)ResourceType.TRANSACTIONAL_ID)).equals((Object)resourceType)) {
            errors = Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED;
        } else if (((Object)((Object)ResourceType.DELEGATION_TOKEN)).equals((Object)resourceType)) {
            errors = Errors.DELEGATION_TOKEN_AUTHORIZATION_FAILED;
        } else {
            throw new IllegalArgumentException("Authorization error type not known");
        }
        return errors;
    }

    public static final /* synthetic */ boolean $anonfun$ResourceTypes$1(ResourceType t) {
        block3: {
            block2: {
                ResourceType resourceType = t;
                ResourceType resourceType2 = ResourceType.UNKNOWN;
                if (!(resourceType == null ? resourceType2 != null : !((Object)((Object)resourceType)).equals((Object)resourceType2))) break block2;
                ResourceType resourceType3 = t;
                ResourceType resourceType4 = ResourceType.ANY;
                if (resourceType3 != null ? !((Object)((Object)resourceType3)).equals((Object)resourceType4) : resourceType4 != null) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$AclOperations$1(AclOperation t) {
        block3: {
            block2: {
                AclOperation aclOperation = t;
                AclOperation aclOperation2 = AclOperation.UNKNOWN;
                if (!(aclOperation == null ? aclOperation2 != null : !((Object)((Object)aclOperation)).equals((Object)aclOperation2))) break block2;
                AclOperation aclOperation3 = t;
                AclOperation aclOperation4 = AclOperation.ANY;
                if (aclOperation3 != null ? !((Object)((Object)aclOperation3)).equals((Object)aclOperation4) : aclOperation4 != null) break block3;
            }
            return true;
        }
        return false;
    }

    private AclEntry$() {
        MODULE$ = this;
        this.WildcardPrincipal = new KafkaPrincipal("User", "*");
        this.WildcardPrincipalString = this.WildcardPrincipal().toString();
        this.WildcardHost = "*";
        this.WildcardResource = "*";
        this.ResourceSeparator = ":";
        this.ResourceTypes = (Set)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])ResourceType.values())).toSet().filterNot((Function1<ResourceType, Object> & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean(AclEntry$.$anonfun$ResourceTypes$1(t)));
        this.AclOperations = (Set)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values())).toSet().filterNot((Function1<AclOperation, Object> & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean(AclEntry$.$anonfun$AclOperations$1(t)));
        this.PrincipalKey = "principal";
        this.PermissionTypeKey = "permissionType";
        this.OperationKey = "operation";
        this.HostsKey = "host";
        this.VersionKey = "version";
        this.CurrentVersion = 1;
        this.AclsKey = "acls";
    }
}

