/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientRequestQuotaManager$;
import kafka.server.QuotaType$Request$;
import kafka.utils.QuotaUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction1$mcVJ$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005Uu!\u0002\u0011\"\u0011\u00031c!\u0002\u0015\"\u0011\u0003I\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004b\u0002\u001a\u0002\u0005\u0004%\ta\r\u0005\u0007o\u0005\u0001\u000b\u0011\u0002\u001b\t\u000fa\n!\u0019!C\u0001g!1\u0011(\u0001Q\u0001\nQBqAO\u0001C\u0002\u0013%1\b\u0003\u0004E\u0003\u0001\u0006I\u0001\u0010\u0004\u0005Q\u0005\u0002Q\t\u0003\u0005J\u0013\t\u0015\r\u0011\"\u0003K\u0011!q\u0015B!A!\u0002\u0013Y\u0005\u0002C(\n\u0005\u000b\u0007I\u0011\u0002)\t\u0011uK!\u0011!Q\u0001\nEC\u0001BX\u0005\u0003\u0006\u0004%Ia\u0018\u0005\tM&\u0011\t\u0011)A\u0005A\"Aq-\u0003BC\u0002\u0013%\u0001\u000e\u0003\u0005t\u0013\t\u0005\t\u0015!\u0003j\u0011!!\u0018B!b\u0001\n\u0013)\b\"CA\u0001\u0013\t\u0005\t\u0015!\u0003w\u0011\u0019\u0001\u0014\u0002\"\u0001\u0002\u0004!I\u0011\u0011C\u0005C\u0002\u0013%\u00111\u0003\u0005\t\u00037I\u0001\u0015!\u0003\u0002\u0016!I\u0011QD\u0005C\u0002\u0013%\u0011q\u0004\u0005\t\u0003SI\u0001\u0015!\u0003\u0002\"!Q\u00111F\u0005\t\u0006\u0004%\t!!\f\t\u000f\u0005U\u0012\u0002\"\u0001\u00028!9\u00111I\u0005\u0005\u0002\u0005\u0015\u0003bBA5\u0013\u0011\u0005\u00111\u000e\u0005\b\u0003_JA\u0011KA9\u0011\u001d\ty(\u0003C)\u0003\u0003Cq!!$\n\t\u0013\ty)A\rDY&,g\u000e\u001e*fcV,7\u000f^)v_R\fW*\u00198bO\u0016\u0014(B\u0001\u0012$\u0003\u0019\u0019XM\u001d<fe*\tA%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\u001d\nQ\"A\u0011\u00033\rc\u0017.\u001a8u%\u0016\fX/Z:u#V|G/Y'b]\u0006<WM]\n\u0003\u0003)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001'\u0003i\tVo\u001c;b%\u0016\fX/Z:u!\u0016\u00148-\u001a8u\t\u00164\u0017-\u001e7u+\u0005!\u0004CA\u00166\u0013\t1DF\u0001\u0004E_V\u0014G.Z\u0001\u001c#V|G/\u0019*fcV,7\u000f\u001e)fe\u000e,g\u000e\u001e#fM\u0006,H\u000e\u001e\u0011\u000259\u000bgn\\:U_B+'oY3oi\u0006<W\rU3s'\u0016\u001cwN\u001c3\u000279\u000bgn\\:U_B+'oY3oi\u0006<W\rU3s'\u0016\u001cwN\u001c3!\u0003A)\u00050Z7qiN+gn]8s\u001d\u0006lW-F\u0001=!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0003mC:<'\"A!\u0002\t)\fg/Y\u0005\u0003\u0007z\u0012aa\u0015;sS:<\u0017!E#yK6\u0004HoU3og>\u0014h*Y7fAM\u0011\u0011B\u0012\t\u0003O\u001dK!\u0001S\u0011\u0003%\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\u0001\u0007G>tg-[4\u0016\u0003-\u0003\"a\n'\n\u00055\u000b#\u0001G\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013aB7fiJL7m]\u000b\u0002#B\u0011!kW\u0007\u0002'*\u0011q\n\u0016\u0006\u0003+Z\u000baaY8n[>t'B\u0001\u0013X\u0015\tA\u0016,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0006\u0019qN]4\n\u0005q\u001b&aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005!A/[7f+\u0005\u0001\u0007CA1e\u001b\u0005\u0011'BA2U\u0003\u0015)H/\u001b7t\u0013\t)'M\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y+\u0005I\u0007C\u00016r\u001d\tYw\u000e\u0005\u0002mY5\tQN\u0003\u0002oK\u00051AH]8pizJ!\u0001\u001d\u0017\u0002\rA\u0013X\rZ3g\u0013\t\u0019%O\u0003\u0002qY\u0005\tB\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u0011\u0002\u001bE,x\u000e^1DC2d'-Y2l+\u00051\bcA\u0016xs&\u0011\u0001\u0010\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005itX\"A>\u000b\u0005ql\u0018!B9v_R\f'B\u0001\u0012W\u0013\ty8PA\nDY&,g\u000e^)v_R\f7)\u00197mE\u0006\u001c7.\u0001\brk>$\u0018mQ1mY\n\f7m\u001b\u0011\u0015\u0019\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti!a\u0004\u0011\u0005\u001dJ\u0001\"B%\u0015\u0001\u0004Y\u0005\"B(\u0015\u0001\u0004\t\u0006\"\u00020\u0015\u0001\u0004\u0001\u0007\"B4\u0015\u0001\u0004I\u0007\"\u0002;\u0015\u0001\u00041\u0018!E7bqRC'o\u001c;uY\u0016$\u0016.\\3NgV\u0011\u0011Q\u0003\t\u0004W\u0005]\u0011bAA\rY\t!Aj\u001c8h\u0003Ii\u0017\r\u001f+ie>$H\u000f\\3US6,Wj\u001d\u0011\u0002!\u0015DX-\u001c9u\u001b\u0016$(/[2OC6,WCAA\u0011!\u0011\t\u0019#!\n\u000e\u0003QK1!a\nU\u0005)iU\r\u001e:jG:\u000bW.Z\u0001\u0012Kb,W\u000e\u001d;NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013\u0001D3yK6\u0004HoU3og>\u0014XCAA\u0018!\r\u0011\u0016\u0011G\u0005\u0004\u0003g\u0019&AB*f]N|'/\u0001\u0007sK\u000e|'\u000fZ#yK6\u0004H\u000f\u0006\u0003\u0002:\u0005}\u0002cA\u0016\u0002<%\u0019\u0011Q\b\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u0003R\u0002\u0019\u0001\u001b\u0002\u000bY\fG.^3\u0002?5\f\u0017PY3SK\u000e|'\u000fZ!oI\u001e+G\u000f\u00165s_R$H.\u001a+j[\u0016l5\u000f\u0006\u0004\u0002H\u00055\u0013Q\r\t\u0004W\u0005%\u0013bAA&Y\t\u0019\u0011J\u001c;\t\u000f\u0005=3\u00041\u0001\u0002R\u00059!/Z9vKN$\b\u0003BA*\u0003?rA!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033\u001a\u0013a\u00028fi^|'o[\u0005\u0005\u0003;\n9&\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\t\u0005\u0005\u00141\r\u0002\b%\u0016\fX/Z:u\u0015\u0011\ti&a\u0016\t\u000f\u0005\u001d4\u00041\u0001\u0002\u0016\u00051A/[7f\u001bN\f\u0011#\\1zE\u0016\u0014VmY8sI\u0016CX-\u001c9u)\u0011\tI$!\u001c\t\u000f\u0005=C\u00041\u0001\u0002R\u0005aA\u000f\u001b:piRdW\rV5nKR1\u0011QCA:\u0003{Bq!!\u001e\u001e\u0001\u0004\t9(A\u0001f!\r\u0011\u0016\u0011P\u0005\u0004\u0003w\u001a&aF)v_R\fg+[8mCRLwN\\#yG\u0016\u0004H/[8o\u0011\u001d\t9'\ba\u0001\u0003+\tQc\u00197jK:$\u0018+^8uC6+GO]5d\u001d\u0006lW\r\u0006\u0003\u0002\"\u0005\r\u0005bBAC=\u0001\u0007\u0011qQ\u0001\u0010cV|G/Y'fiJL7\rV1hgB)!.!#jS&\u0019\u00111\u0012:\u0003\u00075\u000b\u0007/A\toC:|7\u000fV8QKJ\u001cWM\u001c;bO\u0016$2\u0001NAI\u0011\u001d\t\u0019j\ba\u0001\u0003+\tQA\\1o_N\u0004")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private Sensor exemptSensor;
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> quotaCallback;
    private final long maxThrottleTimeMs;
    private MetricName exemptMetricName;
    private volatile boolean bitmap$0;

    public static double NanosToPercentagePerSecond() {
        return ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond();
    }

    public static double QuotaRequestPercentDefault() {
        return ClientRequestQuotaManager$.MODULE$.QuotaRequestPercentDefault();
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> quotaCallback() {
        return this.quotaCallback;
    }

    private long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    private MetricName exemptMetricName() {
        return this.exemptMetricName;
    }

    private Sensor exemptSensor$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.exemptSensor = this.getOrCreateSensor(ClientRequestQuotaManager$.MODULE$.kafka$server$ClientRequestQuotaManager$$ExemptSensorName(), this.exemptMetricName());
                this.bitmap$0 = true;
            }
        }
        this.exemptMetricName = null;
        return this.exemptSensor;
    }

    public Sensor exemptSensor() {
        if (!this.bitmap$0) {
            return this.exemptSensor$lzycompute();
        }
        return this.exemptSensor;
    }

    public void recordExempt(double value) {
        this.exemptSensor().record(value);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request, long timeMs) {
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq(new Some<JFunction1$mcVJ$sp & Serializable>((JFunction1$mcVJ$sp & Serializable)timeNanos -> this.recordNoThrottle(request.session(), request.header().clientId(), this.nanosToPercentage(timeNanos))));
            return this.recordAndGetThrottleTimeMs(request.session(), request.header().clientId(), this.nanosToPercentage(request.requestThreadTimeNanos()), timeMs);
        }
        return 0;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq(new Some<JFunction1$mcVJ$sp & Serializable>((JFunction1$mcVJ$sp & Serializable)timeNanos -> this.recordExempt(this.nanosToPercentage(timeNanos))));
            this.recordExempt(this.nanosToPercentage(request.requestThreadTimeNanos()));
        }
    }

    @Override
    public long throttleTime(QuotaViolationException e, long timeMs) {
        return QuotaUtils$.MODULE$.boundedThrottleTime(e, this.maxThrottleTimeMs(), timeMs);
    }

    @Override
    public MetricName clientQuotaMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", QuotaType$Request$.MODULE$.toString(), "Tracking request-time per user/client-id", CollectionConverters$.MODULE$.mapAsJavaMapConverter(quotaMetricTags).asJava());
    }

    private double nanosToPercentage(long nanos) {
        return (double)nanos * ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond();
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaCallback = quotaCallback;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix, quotaCallback);
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
        this.exemptMetricName = metrics.metricName("exempt-request-time", QuotaType$Request$.MODULE$.toString(), "Tracking exempt-request-time utilization percentage");
    }
}

