/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import kafka.network.RequestChannel;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.ForwardingManager;
import kafka.server.ForwardingManagerImpl;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$$eq$colon$eq$;
import scala.Some;
import scala.compat.java8.OptionConverters$;
import scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u000194A\u0001C\u0005\u0001\u001d!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005C\u0003$\u0001\u0011\u0005A\u0005C\u0003(\u0001\u0011\u0005\u0003\u0006C\u0003-\u0001\u0011\u0005\u0003\u0006C\u0003.\u0001\u0011\u0005c\u0006C\u0003Q\u0001\u0011\u0005\u0013\u000bC\u0003Z\u0001\u0011%!LA\u000bG_J<\u0018M\u001d3j]\u001el\u0015M\\1hKJLU\u000e\u001d7\u000b\u0005)Y\u0011AB:feZ,'OC\u0001\r\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\b\u00163A\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\u0004\"AF\f\u000e\u0003%I!\u0001G\u0005\u0003#\u0019{'o^1sI&tw-T1oC\u001e,'\u000f\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d\u0017\u0005)Q\u000f^5mg&\u0011ad\u0007\u0002\b\u0019><w-\u001b8h\u00039\u0019\u0007.\u00198oK2l\u0015M\\1hKJ\u0004\"AF\u0011\n\u0005\tJ!\u0001\t\"s_.,'\u000fV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\fa\u0001P5oSRtDCA\u0013'!\t1\u0002\u0001C\u0003 \u0005\u0001\u0007\u0001%A\u0003ti\u0006\u0014H\u000fF\u0001*!\t\u0001\"&\u0003\u0002,#\t!QK\\5u\u0003!\u0019\b.\u001e;e_^t\u0017A\u00044pe^\f'\u000f\u001a*fcV,7\u000f\u001e\u000b\u0004S=Z\u0004\"\u0002\u0019\u0006\u0001\u0004\t\u0014a\u0002:fcV,7\u000f\u001e\t\u0003ear!a\r\u001c\u000e\u0003QR!!N\u0006\u0002\u000f9,Go^8sW&\u0011q\u0007N\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\tI$HA\u0004SKF,Xm\u001d;\u000b\u0005]\"\u0004\"\u0002\u001f\u0006\u0001\u0004i\u0014\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u0011\u0001b\bQ\u0015\n\u0005}\n\"!\u0003$v]\u000e$\u0018n\u001c82!\r\u0001\u0012iQ\u0005\u0003\u0005F\u0011aa\u00149uS>t\u0007C\u0001#O\u001b\u0005)%B\u0001$H\u0003!\u0011X-];fgR\u001c(B\u0001%J\u0003\u0019\u0019w.\\7p]*\u0011AB\u0013\u0006\u0003\u00172\u000ba!\u00199bG\",'\"A'\u0002\u0007=\u0014x-\u0003\u0002P\u000b\n\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/Z\u0001\u0016G>tGO]8mY\u0016\u0014\u0018\t]5WKJ\u001c\u0018n\u001c8t+\u0005\u0011\u0006c\u0001\tB'B\u0011AkV\u0007\u0002+*\u0011a+S\u0001\bG2LWM\u001c;t\u0013\tAVKA\bO_\u0012,\u0017\t]5WKJ\u001c\u0018n\u001c8t\u00035\u0001\u0018M]:f%\u0016\u001c\bo\u001c8tKR!1iW3j\u0011\u0015av\u00011\u0001^\u0003\u0019\u0011WO\u001a4feB\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0004]&|'\"\u00012\u0002\t)\fg/Y\u0005\u0003I~\u0013!BQ=uK\n+hMZ3s\u0011\u0015\u0001t\u00011\u0001g!\t!u-\u0003\u0002i\u000b\ny\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH\u000fC\u0003k\u000f\u0001\u00071.\u0001\u0004iK\u0006$WM\u001d\t\u0003\t2L!!\\#\u0003\u001bI+\u0017/^3ti\"+\u0017\rZ3s\u0001")
public class ForwardingManagerImpl
implements ForwardingManager,
Logging {
    private final BrokerToControllerChannelManager channelManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public void start() {
        this.channelManager.start();
    }

    @Override
    public void shutdown() {
        this.channelManager.shutdown();
    }

    @Override
    public void forwardRequest(RequestChannel.Request request, Function1<Option<AbstractResponse>, BoxedUnit> responseCallback) {
        byte[] serializedPrincipal = ((KafkaPrincipalSerde)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(request.context().principalSerde)).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(74).append("Cannot deserialize principal from request ").append(request).append(" ").append("since there is no serde defined").toString());
        })).serialize(request.context().principal);
        ByteBuffer forwardRequestBuffer = request.buffer().duplicate();
        forwardRequestBuffer.flip();
        EnvelopeRequest.Builder envelopeRequest = new EnvelopeRequest.Builder(forwardRequestBuffer, serializedPrincipal, request.context().clientAddress.getAddress());
        public class Kafka_server_ForwardingManagerImpl$ForwardingResponseHandler$1
        extends ControllerRequestCompletionHandler {
            private final /* synthetic */ ForwardingManagerImpl $outer;
            private final RequestChannel.Request request$1;
            private final Function1 responseCallback$1;

            public void onComplete(ClientResponse clientResponse) {
                AbstractResponse abstractResponse;
                Errors envelopeError;
                T requestBody = this.request$1.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef$$eq$colon$eq$.MODULE$.tpEquals()));
                if (clientResponse.versionMismatch() != null) {
                    this.$outer.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Returning `UNKNOWN_SERVER_ERROR` in response to request ").append(requestBody).append(" ").append("due to unexpected version error").toString(), (Function0<Throwable>)(Function0<UnsupportedVersionException> & Serializable & scala.Serializable)() -> clientResponse.versionMismatch());
                    this.responseCallback$1.apply(new Some<AbstractResponse>(((AbstractRequest)requestBody).getErrorResponse(Errors.UNKNOWN_SERVER_ERROR.exception())));
                    return;
                }
                if (clientResponse.authenticationException() != null) {
                    this.$outer.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(84).append("Returning `UNKNOWN_SERVER_ERROR` in response to request ").append(requestBody).append(" ").append("due to authentication error").toString(), (Function0<Throwable>)(Function0<AuthenticationException> & Serializable & scala.Serializable)() -> clientResponse.authenticationException());
                    this.responseCallback$1.apply(new Some<AbstractResponse>(((AbstractRequest)requestBody).getErrorResponse(Errors.UNKNOWN_SERVER_ERROR.exception())));
                    return;
                }
                EnvelopeResponse envelopeResponse = (EnvelopeResponse)clientResponse.responseBody();
                Errors errors = envelopeError = envelopeResponse.error();
                Errors errors2 = Errors.UNSUPPORTED_VERSION;
                if (!(errors != null ? !((Object)((Object)errors)).equals((Object)((Object)errors2)) : errors2 != null)) {
                    this.responseCallback$1.apply(None$.MODULE$);
                    return;
                }
                Errors errors3 = envelopeError;
                Errors errors4 = Errors.NONE;
                if (errors3 == null ? errors4 != null : !((Object)((Object)errors3)).equals((Object)((Object)errors4))) {
                    this.$outer.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Forwarded request ").append($this.request$1).append(" failed with an error in the envelope response ").append((Object)((Object)envelopeError)).toString());
                    abstractResponse = ((AbstractRequest)requestBody).getErrorResponse(Errors.UNKNOWN_SERVER_ERROR.exception());
                } else {
                    abstractResponse = this.$outer.kafka$server$ForwardingManagerImpl$$parseResponse(envelopeResponse.responseData(), (AbstractRequest)requestBody, this.request$1.header());
                }
                AbstractResponse response = abstractResponse;
                this.responseCallback$1.apply(Option$.MODULE$.apply(response));
            }

            public void onTimeout() {
                this.$outer.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Forwarding of the request ").append($this.request$1).append(" failed due to timeout exception").toString());
                AbstractResponse response = ((AbstractRequest)this.request$1.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef$$eq$colon$eq$.MODULE$.tpEquals()))).getErrorResponse(new TimeoutException());
                this.responseCallback$1.apply(Option$.MODULE$.apply(response));
            }

            public Kafka_server_ForwardingManagerImpl$ForwardingResponseHandler$1(ForwardingManagerImpl $outer, RequestChannel.Request request$1, Function1 responseCallback$1) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
                this.responseCallback$1 = responseCallback$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.kafka.common.requests.AbstractRequest ), $anonfun$onComplete$2(org.apache.kafka.clients.ClientResponse ), $anonfun$onComplete$3(org.apache.kafka.common.requests.AbstractRequest ), $anonfun$onComplete$4(org.apache.kafka.clients.ClientResponse ), $anonfun$onComplete$5(kafka.server.ForwardingManagerImpl$ForwardingResponseHandler$1 org.apache.kafka.common.protocol.Errors ), $anonfun$onTimeout$1(kafka.server.ForwardingManagerImpl$ForwardingResponseHandler$1 )}, serializedLambda);
            }
        }
        this.channelManager.sendRequest(envelopeRequest, new Kafka_server_ForwardingManagerImpl$ForwardingResponseHandler$1(this, request, responseCallback));
    }

    @Override
    public Option<NodeApiVersions> controllerApiVersions() {
        return this.channelManager.controllerApiVersions();
    }

    public AbstractResponse kafka$server$ForwardingManagerImpl$$parseResponse(ByteBuffer buffer, AbstractRequest request, RequestHeader header) {
        try {
            return AbstractResponse.parseResponse(buffer, header);
        }
        catch (Exception e) {
            this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Failed to parse response from envelope for request with header ").append(header).toString(), (Function0<Throwable>)(Function0<Exception> & Serializable & scala.Serializable)() -> e);
            return request.getErrorResponse(Errors.UNKNOWN_SERVER_ERROR.exception());
        }
    }

    public ForwardingManagerImpl(BrokerToControllerChannelManager channelManager) {
        this.channelManager = channelManager;
        ForwardingManager.$init$(this);
        Logging.$init$(this);
    }
}

