/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache;
import kafka.server.ZkMetadataCache$MetadataSnapshot$;
import kafka.server.metadata.MetadataBroker;
import kafka.server.metadata.MetadataBroker$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0$mcI$sp;

@ScalaSignature(bytes="\u0006\u0001\r%h\u0001B\"E\u0001%C\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\u0006=\u0002!\ta\u0018\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u0011\u0019\u0001\b\u0001)A\u0005I\"9\u0011\u000f\u0001a\u0001\n\u0013\u0011\b\"\u0003B\"\u0001\u0001\u0007I\u0011\u0002B#\u0011\u001d\u0011y\u0005\u0001Q!\nMD\u0011B!\u0017\u0001\u0005\u0004%IAa\u0017\t\u0011\t%\u0004\u0001)A\u0005\u0005;BqAa\u001b\u0001\t\u0013\u0011i\u0007C\u0004\u0003\u000e\u0002!IAa$\t\u000f\t\r\u0007\u0001\"\u0003\u0003F\"9!Q\u001a\u0001\u0005\n\t=\u0007b\u0002Bm\u0001\u0011\u0005!1\u001c\u0005\n\u0005s\u0004\u0011\u0013!C\u0001\u0005wD\u0011Ba@\u0001#\u0003%\tAa?\t\u000f\r\u0005\u0001\u0001\"\u0001\u0004\u0004!91Q\u0001\u0001\u0005\u0002\r\u001d\u0001bBB\u0001\u0001\u0011%1\u0011\u0003\u0005\b\u0007\u000b\u0001A\u0011BB\u000b\u0011\u001d\u0019Y\u0002\u0001C\u0001\u0007;Aqa!\t\u0001\t\u0003\u0019\u0019\u0003C\u0004\u00046\u0001!\taa\u000e\t\u000f\rm\u0002\u0001\"\u0003\u0004>!911\n\u0001\u0005\u0002\r5\u0003bBB+\u0001\u0011\u00051q\u000b\u0005\b\u00077\u0002A\u0011AB/\u0011\u001d\u0019)\u0007\u0001C\u0001\u0007OBqa!\u001d\u0001\t\u0003\t9\bC\u0004\u0004t\u0001!\ta!\u001e\t\u000f\r\r\u0005\u0001\"\u0001\u0004\u0006\"91Q\u0014\u0001\u0005\u0002\r}\u0005bBBO\u0001\u0011\u000511\u0015\u0005\b\u0007O\u0003A\u0011BBU\r\u0011)\b\u0001\u0011<\t\u0011u\u001c#Q3A\u0005\u0002yD\u0011\"a\u0018$\u0005#\u0005\u000b\u0011B@\t\u0015\u0005\u00054E!f\u0001\n\u0003\t\u0019\u0007\u0003\u0006\u0002t\r\u0012\t\u0012)A\u0005\u0003KB!\"!\u001e$\u0005+\u0007I\u0011AA<\u0011)\tyh\tB\tB\u0003%\u0011\u0011\u0010\u0005\u000b\u0003\u0003\u001b#Q3A\u0005\u0002\u0005\r\u0005BCAJG\tE\t\u0015!\u0003\u0002\u0006\"Q\u0011QS\u0012\u0003\u0016\u0004%\t!a&\t\u0015\u0005M6E!E!\u0002\u0013\tI\n\u0003\u0004_G\u0011\u0005\u0011Q\u0017\u0005\n\u0003\u0003\u001c\u0013\u0011!C\u0001\u0003\u0007D\u0011\"a4$#\u0003%\t!!5\t\u0013\u0005\u001d8%%A\u0005\u0002\u0005%\b\"CAwGE\u0005I\u0011AAx\u0011%\t\u0019pII\u0001\n\u0003\t)\u0010C\u0005\u0002z\u000e\n\n\u0011\"\u0001\u0002|\"I\u0011q`\u0012\u0002\u0002\u0013\u0005#\u0011\u0001\u0005\n\u0005\u001b\u0019\u0013\u0011!C\u0001\u0005\u001fA\u0011B!\u0005$\u0003\u0003%\tAa\u0005\t\u0013\t}1%!A\u0005B\t\u0005\u0002\"\u0003B\u0015G\u0005\u0005I\u0011\u0001B\u0016\u0011%\u0011)dIA\u0001\n\u0003\u00129\u0004C\u0005\u0003:\r\n\t\u0011\"\u0011\u0003<!I!QH\u0012\u0002\u0002\u0013\u0005#qH\u0004\n\u0007o\u0003\u0011\u0011!E\u0001\u0007s3\u0001\"\u001e\u0001\u0002\u0002#\u000511\u0018\u0005\u0007=z\"\ta!3\t\u0013\teb(!A\u0005F\tm\u0002\"CBf}\u0005\u0005I\u0011QBg\u0011%\u0019INPA\u0001\n\u0003\u001bYNA\b[W6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0015\t)e)\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000f\u0006)1.\u00194lC\u000e\u00011\u0003\u0002\u0001K!R\u0003\"a\u0013(\u000e\u00031S\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u0013a!\u00118z%\u00164\u0007CA)S\u001b\u0005!\u0015BA*E\u00055iU\r^1eCR\f7)Y2iKB\u0011Q\u000bW\u0007\u0002-*\u0011qKR\u0001\u0006kRLGn]\u0005\u00033Z\u0013q\u0001T8hO&tw-\u0001\u0005ce>\\WM]%e!\tYE,\u0003\u0002^\u0019\n\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\t\u0001\u0017\r\u0005\u0002R\u0001!)!L\u0001a\u00017\u0006)\u0002/\u0019:uSRLwN\\'fi\u0006$\u0017\r^1M_\u000e\\W#\u00013\u0011\u0005\u0015tW\"\u00014\u000b\u0005\u001dD\u0017!\u00027pG.\u001c(BA5k\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003W2\fA!\u001e;jY*\tQ.\u0001\u0003kCZ\f\u0017BA8g\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0017A\u00069beRLG/[8o\u001b\u0016$\u0018\rZ1uC2{7m\u001b\u0011\u0002!5,G/\u00193bi\u0006\u001cf.\u00199tQ>$X#A:\u0011\u0005Q\u001cS\"\u0001\u0001\u0003!5+G/\u00193bi\u0006\u001cf.\u00199tQ>$8\u0003B\u0012Koj\u0004\"a\u0013=\n\u0005ed%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0017nL!\u0001 '\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u001fA\f'\u000f^5uS>t7\u000b^1uKN,\u0012a \t\t\u0003\u0003\tY!a\u0004\u0002&5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!A\u0004nkR\f'\r\\3\u000b\u0007\u0005%A*\u0001\u0006d_2dWm\u0019;j_:LA!!\u0004\u0002\u0004\tI\u0011I\\=SK\u001al\u0015\r\u001d\t\u0005\u0003#\tyB\u0004\u0003\u0002\u0014\u0005m\u0001cAA\u000b\u00196\u0011\u0011q\u0003\u0006\u0004\u00033A\u0015A\u0002\u001fs_>$h(C\u0002\u0002\u001e1\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0011\u0003G\u0011aa\u0015;sS:<'bAA\u000f\u0019B1\u0011\u0011AA\u0014\u0003WIA!!\u000b\u0002\u0004\t9Aj\u001c8h\u001b\u0006\u0004\b\u0003BA\u0017\u00033rA!a\f\u0002T9!\u0011\u0011GA'\u001d\u0011\t\u0019$a\u0012\u000f\t\u0005U\u00121\t\b\u0005\u0003o\tiD\u0004\u0003\u0002\u0016\u0005e\u0012BAA\u001e\u0003\ry'oZ\u0005\u0005\u0003\u007f\t\t%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003wI1aRA#\u0015\u0011\ty$!\u0011\n\t\u0005%\u00131J\u0001\u0007G>lWn\u001c8\u000b\u0007\u001d\u000b)%\u0003\u0003\u0002P\u0005E\u0013aB7fgN\fw-\u001a\u0006\u0005\u0003\u0013\nY%\u0003\u0003\u0002V\u0005]\u0013!G+qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e#bi\u0006TA!a\u0014\u0002R%!\u00111LA/\u0005q)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016TA!!\u0016\u0002X\u0005\u0001\u0002/\u0019:uSRLwN\\*uCR,7\u000fI\u0001\ti>\u0004\u0018nY%egV\u0011\u0011Q\r\t\t\u0003#\t9'a\u0004\u0002l%!\u0011\u0011NA\u0012\u0005\ri\u0015\r\u001d\t\u0005\u0003[\ny'\u0004\u0002\u0002R%!\u0011\u0011OA)\u0005\u0011)V/\u001b3\u0002\u0013Q|\u0007/[2JIN\u0004\u0013\u0001D2p]R\u0014x\u000e\u001c7fe&#WCAA=!\u0011Y\u00151P.\n\u0007\u0005uDJ\u0001\u0004PaRLwN\\\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\u0002\u0019\u0005d\u0017N^3Ce>\\WM]:\u0016\u0005\u0005\u0015\u0005CBA\u0001\u0003O\t9\t\u0005\u0003\u0002\n\u0006=UBAAF\u0015\r\tiIR\u0001\bG2,8\u000f^3s\u0013\u0011\t\t*a#\u0003\r\t\u0013xn[3s\u00035\tG.\u001b<f\u0005J|7.\u001a:tA\u0005Q\u0011\r\\5wK:{G-Z:\u0016\u0005\u0005e\u0005CBA\u0001\u0003O\tY\n\u0005\u0005\u0002\u001e\u0006}\u0015\u0011UAW\u001b\t\t9!\u0003\u0003\u0002j\u0005\u001d\u0001\u0003BAR\u0003Sk!!!*\u000b\t\u0005\u001d\u0016\u0011K\u0001\b]\u0016$xo\u001c:l\u0013\u0011\tY+!*\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0011\t\u00055\u0014qV\u0005\u0005\u0003c\u000b\tF\u0001\u0003O_\u0012,\u0017aC1mSZ,gj\u001c3fg\u0002\"2b]A\\\u0003s\u000bY,!0\u0002@\")QP\fa\u0001\u007f\"9\u0011\u0011\r\u0018A\u0002\u0005\u0015\u0004bBA;]\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003\u0003s\u0003\u0019AAC\u0011\u001d\t)J\fa\u0001\u00033\u000bAaY8qsRY1/!2\u0002H\u0006%\u00171ZAg\u0011\u001dix\u0006%AA\u0002}D\u0011\"!\u00190!\u0003\u0005\r!!\u001a\t\u0013\u0005Ut\u0006%AA\u0002\u0005e\u0004\"CAA_A\u0005\t\u0019AAC\u0011%\t)j\fI\u0001\u0002\u0004\tI*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005M'fA@\u0002V.\u0012\u0011q\u001b\t\u0005\u00033\f\u0019/\u0004\u0002\u0002\\*!\u0011Q\\Ap\u0003%)hn\u00195fG.,GMC\u0002\u0002b2\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t)/a7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005-(\u0006BA3\u0003+\fabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002r*\"\u0011\u0011PAk\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!a>+\t\u0005\u0015\u0015Q[\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\tiP\u000b\u0003\u0002\u001a\u0006U\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0004A!!Q\u0001B\u0006\u001b\t\u00119AC\u0002\u0003\n1\fA\u0001\\1oO&!\u0011\u0011\u0005B\u0004\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005Y\u0016A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005+\u0011Y\u0002E\u0002L\u0005/I1A!\u0007M\u0005\r\te.\u001f\u0005\t\u0005;9\u0014\u0011!a\u00017\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\t\u0011\r\u0005u%Q\u0005B\u000b\u0013\u0011\u00119#a\u0002\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005[\u0011\u0019\u0004E\u0002L\u0005_I1A!\rM\u0005\u001d\u0011un\u001c7fC:D\u0011B!\b:\u0003\u0003\u0005\rA!\u0006\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012aW\u0001\ti>\u001cFO]5oOR\u0011!1A\u0001\u0007KF,\u0018\r\\:\u0015\t\t5\"\u0011\t\u0005\n\u0005;a\u0014\u0011!a\u0001\u0005+\tA#\\3uC\u0012\fG/Y*oCB\u001c\bn\u001c;`I\u0015\fH\u0003\u0002B$\u0005\u001b\u00022a\u0013B%\u0013\r\u0011Y\u0005\u0014\u0002\u0005+:LG\u000f\u0003\u0005\u0003\u001e\u0019\t\t\u00111\u0001t\u0003EiW\r^1eCR\f7K\\1qg\"|G\u000f\t\u0015\u0004\u000f\tM\u0003cA&\u0003V%\u0019!q\u000b'\u0003\u0011Y|G.\u0019;jY\u0016\f\u0011c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s+\t\u0011i\u0006\u0005\u0003\u0003`\t\u0015TB\u0001B1\u0015\r\u0011\u0019GR\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002\u0002B4\u0005C\u0012\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0003I\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0011\u000215\f\u0017PY3GS2$XM]!mSZ,'+\u001a9mS\u000e\f7\u000f\u0006\u0006\u0003p\tu$\u0011\u0011BC\u0005\u0013\u0003bA!\u001d\u0003t\t]T\"\u00016\n\u0007\tU$N\u0001\u0003MSN$\b\u0003\u0002B\u0003\u0005sJAAa\u001f\u0003\b\t9\u0011J\u001c;fO\u0016\u0014\bB\u0002B@\u0015\u0001\u00071/\u0001\u0005t]\u0006\u00048\u000f[8u\u0011\u001d\u0011\u0019I\u0003a\u0001\u0005_\nqA\u0019:pW\u0016\u00148\u000fC\u0004\u0003\b*\u0001\r!!)\u0002\u00191L7\u000f^3oKJt\u0015-\\3\t\u000f\t-%\u00021\u0001\u0003.\u0005Qb-\u001b7uKJ,f.\u0019<bS2\f'\r\\3F]\u0012\u0004x.\u001b8ug\u0006!r-\u001a;QCJ$\u0018\u000e^5p]6+G/\u00193bi\u0006$BB!%\u00034\nU&\u0011\u0018B^\u0005\u007f\u0003RaSA>\u0005'\u0003bA!&\u0003 \n\u0015f\u0002\u0002BL\u00057sA!!\u0006\u0003\u001a&\tQ*C\u0002\u0003\u001e2\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003\"\n\r&\u0001C%uKJ\f'\r\\3\u000b\u0007\tuE\n\u0005\u0003\u0003(\n5f\u0002BA\u0018\u0005SKAAa+\u0002X\u0005!R*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a#bi\u0006LAAa,\u00032\nIR*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a)beRLG/[8o\u0015\u0011\u0011Y+a\u0016\t\r\t}4\u00021\u0001t\u0011\u001d\u00119l\u0003a\u0001\u0003\u001f\tQ\u0001^8qS\u000eDqAa\"\f\u0001\u0004\t\t\u000bC\u0004\u0003>.\u0001\rA!\f\u00023\u0015\u0014(o\u001c:V]\u00064\u0018-\u001b7bE2,WI\u001c3q_&tGo\u001d\u0005\b\u0005\u0003\\\u0001\u0019\u0001B\u0017\u0003e)'O]8s+:\fg/Y5mC\ndW\rT5ti\u0016tWM]:\u0002!!\f7/\u00117jm\u0016,e\u000e\u001a9pS:$H\u0003\u0003B\u0017\u0005\u000f\u0014IMa3\t\r\t}D\u00021\u0001t\u0011\u0015QF\u00021\u0001\\\u0011\u001d\u00119\t\u0004a\u0001\u0003C\u000b\u0001cZ3u\u00032Lg/Z#oIB|\u0017N\u001c;\u0015\u0011\tE'1\u001bBk\u0005/\u0004RaSA>\u0003[CaAa \u000e\u0001\u0004\u0019\b\"\u0002.\u000e\u0001\u0004Y\u0006b\u0002BD\u001b\u0001\u0007\u0011\u0011U\u0001\u0011O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$\"B!8\u0003j\nM(Q\u001fB|!\u0019\tiJa8\u0003d&!!\u0011]A\u0004\u0005\r\u0019V-\u001d\t\u0005\u0005O\u0013)/\u0003\u0003\u0003h\nE&!F'fi\u0006$\u0017\r^1SKN\u0004xN\\:f)>\u0004\u0018n\u0019\u0005\b\u0005Wt\u0001\u0019\u0001Bw\u0003\u0019!x\u000e]5dgB1\u0011Q\u0014Bx\u0003\u001fIAA!=\u0002\b\t\u00191+\u001a;\t\u000f\t\u001de\u00021\u0001\u0002\"\"I!Q\u0018\b\u0011\u0002\u0003\u0007!Q\u0006\u0005\n\u0005\u0003t\u0001\u0013!a\u0001\u0005[\t!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIM*\"A!@+\t\t5\u0012Q[\u0001\u001bO\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$C-\u001a4bk2$H\u0005N\u0001\rO\u0016$\u0018\t\u001c7U_BL7m\u001d\u000b\u0003\u0005[\f\u0001cZ3u\u00032d\u0007+\u0019:uSRLwN\\:\u0015\u0005\r%\u0001CBAO\u0005_\u001cY\u0001\u0005\u0003\u0002n\r5\u0011\u0002BB\b\u0003#\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0003n\u000eM\u0001B\u0002B@'\u0001\u00071\u000f\u0006\u0003\u0004\u0018\re\u0001\u0003CA\t\u0003O\u001aY!a\u000b\t\r\t}D\u00031\u0001t\u0003Q9W\r\u001e(p]\u0016C\u0018n\u001d;j]\u001e$v\u000e]5dgR!!Q^B\u0010\u0011\u001d\u0011Y/\u0006a\u0001\u0005[\fabZ3u\u00032Lg/\u001a\"s_.,'\u000f\u0006\u0003\u0004&\rM\u0002#B&\u0002|\r\u001d\u0002\u0003BB\u0015\u0007_i!aa\u000b\u000b\u0007\r5B)\u0001\u0005nKR\fG-\u0019;b\u0013\u0011\u0019\tda\u000b\u0003\u001d5+G/\u00193bi\u0006\u0014%o\\6fe\")!L\u0006a\u00017\u0006yq-\u001a;BY&4XM\u0011:pW\u0016\u00148/\u0006\u0002\u0004:A1\u0011Q\u0014Bp\u0007O\t\u0001$\u00193e\u001fJ,\u0006\u000fZ1uKB\u000b'\u000f^5uS>t\u0017J\u001c4p))\u00119ea\u0010\u0004B\r\r3q\t\u0005\u0006{b\u0001\ra \u0005\b\u0005oC\u0002\u0019AA\b\u0011\u0019\u0019)\u0005\u0007a\u00017\u0006Y\u0001/\u0019:uSRLwN\\%e\u0011\u001d\u0019I\u0005\u0007a\u0001\u0003W\t\u0011b\u001d;bi\u0016LeNZ8\u0002!\u001d,G\u000fU1si&$\u0018n\u001c8J]\u001a|GCBB(\u0007#\u001a\u0019\u0006E\u0003L\u0003w\nY\u0003C\u0004\u00038f\u0001\r!a\u0004\t\r\r\u0015\u0013\u00041\u0001\\\u00035qW/\u001c)beRLG/[8ogR!\u0011\u0011PB-\u0011\u001d\u00119L\u0007a\u0001\u0003\u001f\t!dZ3u!\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016sG\r]8j]R$\u0002B!5\u0004`\r\u000541\r\u0005\b\u0005o[\u0002\u0019AA\b\u0011\u0019\u0019)e\u0007a\u00017\"9!qQ\u000eA\u0002\u0005\u0005\u0016\u0001H4fiB\u000b'\u000f^5uS>t'+\u001a9mS\u000e\fWI\u001c3q_&tGo\u001d\u000b\u0007\u0007S\u001aYga\u001c\u0011\u000f\u0005E\u0011qM.\u0002.\"91Q\u000e\u000fA\u0002\r-\u0011A\u0001;q\u0011\u001d\u00119\t\ba\u0001\u0003C\u000bqbZ3u\u0007>tGO]8mY\u0016\u0014\u0018\nZ\u0001\u0013O\u0016$8\t\\;ti\u0016\u0014X*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0004x\ru4\u0011\u0011\t\u0005\u0003[\u001aI(\u0003\u0003\u0004|\u0005E#aB\"mkN$XM\u001d\u0005\b\u0007\u007fr\u0002\u0019AA\b\u0003%\u0019G.^:uKJLE\rC\u0004\u0003\bz\u0001\r!!)\u0002\u001dU\u0004H-\u0019;f\u001b\u0016$\u0018\rZ1uCR11qQBE\u0007\u001b\u0003b!!(\u0003`\u000e-\u0001BBBF?\u0001\u00071,A\u0007d_J\u0014X\r\\1uS>t\u0017\n\u001a\u0005\b\u0007\u001f{\u0002\u0019ABI\u0003U)\b\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\u0004Baa%\u0004\u001a6\u00111Q\u0013\u0006\u0005\u0007/\u000b\t&\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0019Yj!&\u0003+U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0006A1m\u001c8uC&t7\u000f\u0006\u0003\u0003.\r\u0005\u0006b\u0002B\\A\u0001\u0007\u0011q\u0002\u000b\u0005\u0005[\u0019)\u000bC\u0004\u0004n\u0005\u0002\raa\u0003\u0002'I,Wn\u001c<f!\u0006\u0014H/\u001b;j_:LeNZ8\u0015\u0015\t521VBW\u0007g\u001b)\fC\u0003~E\u0001\u0007q\u0010C\u0004\u0002b\t\u0002\raa,\u0011\u0011\u0005\u00051\u0011WA\b\u0003WJA!!\u001b\u0002\u0004!9!q\u0017\u0012A\u0002\u0005=\u0001BBB#E\u0001\u00071,\u0001\tNKR\fG-\u0019;b':\f\u0007o\u001d5piB\u0011AOP\n\u0005}\ru&\u0010\u0005\b\u0004@\u000e\u0015w0!\u001a\u0002z\u0005\u0015\u0015\u0011T:\u000e\u0005\r\u0005'bABb\u0019\u00069!/\u001e8uS6,\u0017\u0002BBd\u0007\u0003\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c86)\t\u0019I,A\u0003baBd\u0017\u0010F\u0006t\u0007\u001f\u001c\tna5\u0004V\u000e]\u0007\"B?B\u0001\u0004y\bbBA1\u0003\u0002\u0007\u0011Q\r\u0005\b\u0003k\n\u0005\u0019AA=\u0011\u001d\t\t)\u0011a\u0001\u0003\u000bCq!!&B\u0001\u0004\tI*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\ru7Q\u001d\t\u0006\u0017\u0006m4q\u001c\t\r\u0017\u000e\u0005x0!\u001a\u0002z\u0005\u0015\u0015\u0011T\u0005\u0004\u0007Gd%A\u0002+va2,W\u0007\u0003\u0005\u0004h\n\u000b\t\u00111\u0001t\u0003\rAH\u0005\r")
public class ZkMetadataCache
implements MetadataCache,
Logging {
    private volatile ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot$module;
    private final int brokerId;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private volatile MetadataSnapshot metadataSnapshot;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot() {
        if (this.MetadataSnapshot$module == null) {
            this.MetadataSnapshot$lzycompute$1();
        }
        return this.MetadataSnapshot$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    private void metadataSnapshot_$eq(MetadataSnapshot x$1) {
        this.metadataSnapshot = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private List<Integer> maybeFilterAliveReplicas(MetadataSnapshot snapshot, List<Integer> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return brokers;
        }
        ArrayList<Integer> res = new ArrayList<Integer>(scala.math.package$.MODULE$.min(snapshot.aliveBrokers().size(), brokers.size()));
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(brokers).asScala()).foreach((Function1<Integer, Object> & Serializable & scala.Serializable)brokerId -> {
            if (this.hasAliveEndpoint(snapshot, Predef$.MODULE$.Integer2int((Integer)brokerId), listenerName)) {
                return BoxesRunTime.boxToBoolean(res.add((Integer)brokerId));
            }
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private Option<Iterable<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataSnapshot snapshot, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return snapshot.partitionStates().get(topic).map((Function1<LongMap, Iterable> & Serializable & scala.Serializable)partitions -> partitions.map((Function1<Tuple2, MetadataResponseData.MetadataResponsePartition> & Serializable & scala.Serializable)x0$1 -> {
            Errors errors;
            if (x0$1 == null) throw new MatchError((Object)null);
            long partitionId = x0$1._1$mcJ$sp();
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$1._2();
            TopicPartition topicPartition = new TopicPartition(topic, (int)partitionId);
            int leaderBrokerId = partitionState.leader();
            int leaderEpoch = partitionState.leaderEpoch();
            Option<Node> maybeLeader = this.getAliveEndpoint(snapshot, leaderBrokerId, listenerName);
            List<Integer> replicas = partitionState.replicas();
            List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(snapshot, replicas, listenerName, errorUnavailableEndpoints);
            List<Integer> isr = partitionState.isr();
            List<Integer> filteredIsr = this.maybeFilterAliveReplicas(snapshot, isr, listenerName, errorUnavailableEndpoints);
            List<Integer> offlineReplicas = partitionState.offlineReplicas();
            if (None$.MODULE$.equals(maybeLeader)) {
                Errors errors2;
                if (!snapshot.aliveBrokers().contains(leaderBrokerId)) {
                    this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                    errors2 = Errors.LEADER_NOT_AVAILABLE;
                } else {
                    this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(leaderBrokerId).toString());
                    errors2 = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                }
                Errors error = errors2;
                return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(-1).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
            }
            if (!(maybeLeader instanceof Some)) throw new MatchError(maybeLeader);
            if (filteredReplicas.size() < replicas.size()) {
                this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").append("following brokers ").append(((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).filterNot((Function1<Object, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(filteredReplicas.contains(x$1)))).mkString(",")).toString());
                errors = Errors.REPLICA_NOT_AVAILABLE;
            } else if (filteredIsr.size() < isr.size()) {
                this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(100).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").append("following brokers ").append(((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(isr).asScala()).filterNot((Function1<Object, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(filteredIsr.contains(x$1)))).mkString(",")).toString());
                errors = Errors.REPLICA_NOT_AVAILABLE;
            } else {
                errors = Errors.NONE;
            }
            Errors error = errors;
            return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(BoxesRunTime.unboxToInt(maybeLeader.map((Function1<Node, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.id())).getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> -1))).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()));
    }

    private boolean hasAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get(brokerId).exists((Function1<Map<ListenerName, Node>, Object>)(Function1<Map, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.contains(listenerName)));
    }

    private Option<Node> getAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get(brokerId).flatMap((Function1<Map, Option> & Serializable & scala.Serializable)x$3 -> x$3.get(listenerName));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return topics.toSeq().flatMap((Function1<String, Iterable> & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata(snapshot, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1<Iterable, MetadataResponseData.MetadataResponseTopic> & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName((String)topic).setTopicId((Uuid)snapshot.topicIds().getOrElse((String)topic, (Function0<Uuid> & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal(topic)).setPartitions(CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics() {
        return this.getAllTopics(this.metadataSnapshot());
    }

    @Override
    public Set<TopicPartition> getAllPartitions() {
        return ((TraversableOnce)this.metadataSnapshot().partitionStates().flatMap((Function1<Tuple2, Iterable> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            String topicName = (String)x0$1._1();
            Iterable iterable = ((LongMap)x0$1._2()).keys().map((Function1<Object, TopicPartition> & Serializable & scala.Serializable)partitionId -> ZkMetadataCache.$anonfun$getAllPartitions$2(topicName, BoxesRunTime.unboxToLong(partitionId)), scala.collection.Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private Set<String> getAllTopics(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().keySet();
    }

    private scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> getAllPartitions(MetadataSnapshot snapshot) {
        return ((TraversableOnce)snapshot.partitionStates().flatMap((Function1<Tuple2, scala.collection.mutable.Map> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            String topic = (String)x0$1._1();
            scala.collection.mutable.Map map = ((LongMap)x0$1._2()).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError((Object)null);
                }
                long partition = x0$2._1$mcJ$sp();
                UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2();
                Tuple2<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> tuple2 = new Tuple2<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState>(new TopicPartition(topic, (int)partition), state);
                return tuple2;
            }, Map$.MODULE$.canBuildFrom());
            return map;
        }, AnyRefMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public Set<String> getNonExistingTopics(Set<String> topics) {
        return topics.diff(this.metadataSnapshot().partitionStates().keySet());
    }

    @Override
    public Option<MetadataBroker> getAliveBroker(int brokerId) {
        return this.metadataSnapshot().aliveBrokers().get(brokerId).map((Function1<Broker, MetadataBroker> & Serializable & scala.Serializable)broker -> MetadataBroker$.MODULE$.apply((Broker)broker));
    }

    @Override
    public Seq<MetadataBroker> getAliveBrokers() {
        return ((TraversableOnce)this.metadataSnapshot().aliveBrokers().values().map((Function1<Broker, MetadataBroker> & Serializable & scala.Serializable)broker -> MetadataBroker$.MODULE$.apply((Broker)broker), scala.collection.Iterable$.MODULE$.canBuildFrom())).toBuffer();
    }

    private void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, String topic, int partitionId, UpdateMetadataRequestData.UpdateMetadataPartitionState stateInfo) {
        partitionStates.getOrElseUpdate(topic, (Function0<LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)(Function0<LongMap> & Serializable & scala.Serializable)() -> LongMap$.MODULE$.empty()).update(partitionId, stateInfo);
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topic, int partitionId) {
        return this.metadataSnapshot().partitionStates().get(topic).flatMap((Function1<LongMap, Option> & Serializable & scala.Serializable)x$4 -> x$4.get(partitionId));
    }

    @Override
    public Option<Object> numPartitions(String topic) {
        return this.metadataSnapshot().partitionStates().get(topic).map((Function1<LongMap, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger(x$5.size()));
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return snapshot.partitionStates().get(topic).flatMap((Function1<LongMap, Option> & Serializable & scala.Serializable)x$6 -> x$6.get(partitionId)).map((Function1<UpdateMetadataRequestData.UpdateMetadataPartitionState, Node> & Serializable & scala.Serializable)partitionInfo -> {
            Node node;
            int leaderId = partitionInfo.leader();
            Option<Map<ListenerName, Node>> option = snapshot.aliveNodes().get(leaderId);
            if (option instanceof Some) {
                node = (Node)((Map)((Some)option).value()).getOrElse(listenerName, (Function0<Node> & Serializable & scala.Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError(option);
            }
            return node;
        });
    }

    @Override
    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (scala.collection.immutable.Map)snapshot.partitionStates().get(tp.topic()).flatMap((Function1<LongMap, Option> & Serializable & scala.Serializable)x$7 -> x$7.get(tp.partition())).map((Function1<UpdateMetadataRequestData.UpdateMetadataPartitionState, scala.collection.immutable.Map> & Serializable & scala.Serializable)partitionInfo -> {
            List<Integer> replicaIds = partitionInfo.replicas();
            return (scala.collection.immutable.Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(replicaIds).asScala()).map((Function1<Integer, Tuple2> & Serializable & scala.Serializable)replicaId -> {
                Node node;
                Integer n = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(replicaId));
                Option<Broker> option = snapshot.aliveBrokers().get(replicaId.longValue());
                if (option instanceof Some) {
                    node = (Node)((Broker)((Some)option).value()).getNode(listenerName).getOrElse((Function0<Node> & Serializable & scala.Serializable)() -> Node.noNode());
                } else if (None$.MODULE$.equals(option)) {
                    node = Node.noNode();
                } else {
                    throw new MatchError(option);
                }
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n, node);
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean(ZkMetadataCache.$anonfun$getPartitionReplicaEndpoints$5(pair)));
        }).getOrElse((Function0<scala.collection.immutable.Map> & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    @Override
    public Option<Object> getControllerId() {
        return this.metadataSnapshot().controllerId();
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        LongMap nodes = snapshot.aliveNodes().flatMap((Function1<Tuple2, Iterable> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            long id = x0$1._1$mcJ$sp();
            Map nodesByListener = (Map)x0$1._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(nodesByListener.get(listenerName).map((Function1<Node, Tuple2> & Serializable & scala.Serializable)node -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToLong(id)), node)));
            return iterable;
        }, LongMap$.MODULE$.canBuildFrom());
        scala.collection.immutable.Iterable partitions = ((TraversableLike)this.getAllPartitions(snapshot).filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean(ZkMetadataCache.$anonfun$getClusterMetadata$4(x0$2)))).map((Function1<Tuple2, PartitionInfo> & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition tp = (TopicPartition)x0$3._1();
            UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$3._2();
            PartitionInfo partitionInfo = new PartitionInfo(tp.topic(), tp.partition(), ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(state.leader()), nodes), (Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.replicas()).asScala()).map((Function1<Integer, Node> & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.isr()).asScala()).map((Function1<Integer, Node> & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.offlineReplicas()).asScala()).map((Function1<Integer, Node> & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)));
            return partitionInfo;
        }, Iterable$.MODULE$.canBuildFrom());
        java.util.Set<String> unauthorizedTopics = Collections.emptySet();
        java.util.Set<String> internalTopics = CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)this.getAllTopics(snapshot).filter((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(ZkMetadataCache.$anonfun$getClusterMetadata$9(x$1)))).asJava();
        return new Cluster(clusterId, CollectionConverters$.MODULE$.bufferAsJavaListConverter(nodes.values().toBuffer()).asJava(), CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitions.toBuffer()).asJava(), unauthorizedTopics, internalTopics, (Node)snapshot.controllerId().map((Function1<Object, Node> & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(id)), nodes)).orNull(Predef$.MODULE$.$conforms()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        ArrayBuffer arrayBuffer;
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.partitionMetadataLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            arrayBuffer = ZkMetadataCache.$anonfun$updateMetadata$1(this, updateMetadataRequest, correlationId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        return arrayBuffer;
    }

    @Override
    public boolean contains(String topic) {
        return this.metadataSnapshot().partitionStates().contains(topic);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.mutable.Map<String, Uuid> topicIds, String topic, int partitionId) {
        return partitionStates.get(topic).exists((Function1<LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>, Object>)(Function1<LongMap, Object> & Serializable & scala.Serializable)infos -> BoxesRunTime.boxToBoolean(ZkMetadataCache.$anonfun$removePartitionInfo$1(partitionId, partitionStates, topic, topicIds, infos)));
    }

    private final void MetadataSnapshot$lzycompute$1() {
        synchronized (this) {
            if (this.MetadataSnapshot$module == null) {
                this.MetadataSnapshot$module = new ZkMetadataCache$MetadataSnapshot$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ TopicPartition $anonfun$getAllPartitions$2(String topicName$1, long partitionId) {
        return new TopicPartition(topicName$1, (int)partitionId);
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionReplicaEndpoints$5(Tuple2 pair) {
        if (pair == null) {
            throw new MatchError((Object)null);
        }
        boolean bl = !((Node)pair._2()).isEmpty();
        return bl;
    }

    private static final Node node$1(Integer id, LongMap nodes$1) {
        return (Node)nodes$1.getOrElse(Predef$.MODULE$.Integer2int(id), (Function0<Node> & Serializable & scala.Serializable)() -> new Node(Predef$.MODULE$.Integer2int(id), "", -1));
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$4(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError((Object)null);
        }
        boolean bl = ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2()).leader() != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$9(String x$1) {
        return Topic.isInternal(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$5(Set listeners$1, Map x$8) {
        Set set = x$8.keySet();
        return !(set != null ? !set.equals(listeners$1) : listeners$1 != null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$4(ZkMetadataCache $this, LongMap aliveNodes$1, Map listenerMap) {
        Set listeners = listenerMap.keySet();
        if (!aliveNodes$1.values().forall((Function1<Map, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean(ZkMetadataCache.$anonfun$updateMetadata$5(listeners, x$8)))) {
            $this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append(aliveNodes$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$8(Tuple2 x$9) {
        Object T2 = x$9._2();
        Uuid uuid = Uuid.ZERO_UUID;
        return T2 == null ? uuid != null : !T2.equals(uuid);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$9(AnyRefMap partitionStates$1, String topic, LongMap oldPartitionStates) {
        LongMap copy = new LongMap(oldPartitionStates.size());
        copy.$plus$plus$eq(oldPartitionStates);
        partitionStates$1.update(topic, copy);
    }

    public static final /* synthetic */ Object $anonfun$updateMetadata$10(ZkMetadataCache $this, AnyRefMap partitionStates$1, scala.collection.mutable.Map topicIds$1, boolean traceEnabled$1, int controllerId$1, int controllerEpoch$1, int correlationId$1, ArrayBuffer deletedPartitions$1, UpdateMetadataRequestData.UpdateMetadataPartitionState state) {
        TopicPartition tp = new TopicPartition(state.topicName(), state.partitionIndex());
        if (state.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
            $this.removePartitionInfo(partitionStates$1, topicIds$1, tp.topic(), tp.partition());
            if (traceEnabled$1) {
                $this.stateChangeLogger().trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").append("request sent by controller ").append(controllerId$1).append(" epoch ").append(controllerEpoch$1).append(" with correlation id ").append(correlationId$1).toString());
            }
            return deletedPartitions$1.$plus$eq(tp);
        }
        $this.addOrUpdatePartitionInfo(partitionStates$1, tp.topic(), tp.partition(), state);
        if (traceEnabled$1) {
            $this.stateChangeLogger().trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(120).append("Cached leader info ").append(state).append(" for partition ").append(tp).append(" in response to ").append("UpdateMetadata request sent by controller ").append(controllerId$1).append(" epoch ").append(controllerEpoch$1).append(" with correlation id ").append(correlationId$1).toString());
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ArrayBuffer $anonfun$updateMetadata$1(ZkMetadataCache $this, UpdateMetadataRequest updateMetadataRequest$1, int correlationId$1) {
        LongMap<Broker> aliveBrokers = new LongMap<Broker>($this.metadataSnapshot().aliveBrokers().size());
        LongMap<Map<ListenerName, Node>> aliveNodes = new LongMap<Map<ListenerName, Node>>($this.metadataSnapshot().aliveNodes().size());
        int n = updateMetadataRequest$1.controllerId();
        switch (n) {
            default: 
        }
        Option controllerIdOpt = n < 0 ? None$.MODULE$ : new Some<Integer>(BoxesRunTime.boxToInteger(n));
        updateMetadataRequest$1.liveBrokers().forEach(broker -> {
            HashMap nodes = new HashMap();
            ArrayBuffer<EndPoint> endPoints = new ArrayBuffer<EndPoint>();
            broker.endpoints().forEach(ep -> {
                ListenerName listenerName = new ListenerName(ep.listener());
                endPoints.$plus$eq((Object)new EndPoint(ep.host(), ep.port(), listenerName, SecurityProtocol.forId(ep.securityProtocol())));
                nodes.put(listenerName, new Node(broker.id(), ep.host(), ep.port()));
            });
            aliveBrokers.update(broker.id(), Broker$.MODULE$.apply(broker.id(), endPoints, Option$.MODULE$.apply(broker.rack())));
            aliveNodes.update(broker.id(), (Map<ListenerName, Node>)CollectionConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
        });
        aliveNodes.get($this.brokerId).foreach((Function1<Map, Object> & Serializable & scala.Serializable)listenerMap -> {
            ZkMetadataCache.$anonfun$updateMetadata$4($this, aliveNodes, listenerMap);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map newTopicIds = ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest$1.topicStates()).asScala()).map((Function1<UpdateMetadataRequestData.UpdateMetadataTopicState, Tuple2> & Serializable & scala.Serializable)topicState -> new Tuple2<String, Uuid>(topicState.topicName(), topicState.topicId()), Buffer$.MODULE$.canBuildFrom())).filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean(ZkMetadataCache.$anonfun$updateMetadata$8(x$9)))).toMap(Predef$.MODULE$.$conforms());
        GenMap topicIds = Map$.MODULE$.empty();
        topicIds.$plus$plus$eq($this.metadataSnapshot().topicIds());
        topicIds.$plus$plus$eq(newTopicIds);
        ArrayBuffer deletedPartitions = new ArrayBuffer();
        if (!updateMetadataRequest$1.partitionStates().iterator().hasNext()) {
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this, $this.metadataSnapshot().partitionStates(), topicIds.toMap(Predef$.MODULE$.$conforms()), controllerIdOpt, aliveBrokers, aliveNodes));
        } else {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates = new AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>($this.metadataSnapshot().partitionStates().size());
            Function2<String, LongMap, Object> & Serializable & scala.Serializable intersect = (Function2<String, LongMap, Object> & Serializable & scala.Serializable)(topic, oldPartitionStates) -> {
                ZkMetadataCache.$anonfun$updateMetadata$9(partitionStates, topic, oldPartitionStates);
                return BoxedUnit.UNIT;
            };
            Map<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> map = Implicits$.MODULE$.MapExtensionMethods($this.metadataSnapshot().partitionStates());
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods(forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            boolean traceEnabled = $this.stateChangeLogger().isTraceEnabled();
            int controllerId = updateMetadataRequest$1.controllerId();
            int controllerEpoch = updateMetadataRequest$1.controllerEpoch();
            Iterable<UpdateMetadataRequestData.UpdateMetadataPartitionState> newStates = CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest$1.partitionStates()).asScala();
            newStates.foreach(arg_0 -> ZkMetadataCache.$anonfun$updateMetadata$10($this, partitionStates, (scala.collection.mutable.Map)topicIds, traceEnabled, controllerId, controllerEpoch, correlationId$1, deletedPartitions, arg_0));
            int cachedPartitionsCount = newStates.size() - deletedPartitions.size();
            $this.stateChangeLogger().info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(145).append("Add ").append(cachedPartitionsCount).append(" partitions and deleted ").append(deletedPartitions.size()).append(" partitions from metadata cache ").append("in response to UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this, partitionStates, topicIds.toMap(Predef$.MODULE$.$conforms()), controllerIdOpt, aliveBrokers, aliveNodes));
        }
        return deletedPartitions;
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(int partitionId$3, AnyRefMap partitionStates$2, String topic$4, scala.collection.mutable.Map topicIds$2, LongMap infos) {
        infos.remove(BoxesRunTime.boxToLong(partitionId$3));
        if (infos.isEmpty()) {
            partitionStates$2.remove(topic$4);
            topicIds$2.remove(topic$4);
        }
        return true;
    }

    public ZkMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        Logging.$init$(this);
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.metadataSnapshot = new MetadataSnapshot(this, AnyRefMap$.MODULE$.empty(), (scala.collection.immutable.Map<String, Uuid>)Predef$.MODULE$.Map().empty(), None$.MODULE$, LongMap$.MODULE$.empty(), LongMap$.MODULE$.empty());
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, None$.MODULE$);
    }

    public class MetadataSnapshot
    implements Product,
    scala.Serializable {
        private final AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates;
        private final scala.collection.immutable.Map<String, Uuid> topicIds;
        private final Option<Object> controllerId;
        private final LongMap<Broker> aliveBrokers;
        private final LongMap<Map<ListenerName, Node>> aliveNodes;
        public final /* synthetic */ ZkMetadataCache $outer;

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates() {
            return this.partitionStates;
        }

        public scala.collection.immutable.Map<String, Uuid> topicIds() {
            return this.topicIds;
        }

        public Option<Object> controllerId() {
            return this.controllerId;
        }

        public LongMap<Broker> aliveBrokers() {
            return this.aliveBrokers;
        }

        public LongMap<Map<ListenerName, Node>> aliveNodes() {
            return this.aliveNodes;
        }

        public MetadataSnapshot copy(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            return new MetadataSnapshot(this.kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer(), partitionStates, topicIds, controllerId, aliveBrokers, aliveNodes);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> copy$default$1() {
            return this.partitionStates();
        }

        public scala.collection.immutable.Map<String, Uuid> copy$default$2() {
            return this.topicIds();
        }

        public Option<Object> copy$default$3() {
            return this.controllerId();
        }

        public LongMap<Broker> copy$default$4() {
            return this.aliveBrokers();
        }

        public LongMap<Map<ListenerName, Node>> copy$default$5() {
            return this.aliveNodes();
        }

        @Override
        public String productPrefix() {
            return "MetadataSnapshot";
        }

        @Override
        public int productArity() {
            return 5;
        }

        @Override
        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.partitionStates();
                }
                case 1: {
                    return this.topicIds();
                }
                case 2: {
                    return this.controllerId();
                }
                case 3: {
                    return this.aliveBrokers();
                }
                case 4: {
                    return this.aliveNodes();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof MetadataSnapshot;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof MetadataSnapshot)) return false;
            if (((MetadataSnapshot)x$1).kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer() != this.kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MetadataSnapshot metadataSnapshot = (MetadataSnapshot)x$1;
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap = this.partitionStates();
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap2 = metadataSnapshot.partitionStates();
            if (anyRefMap == null) {
                if (anyRefMap2 != null) {
                    return false;
                }
            } else if (!((Object)anyRefMap).equals(anyRefMap2)) return false;
            scala.collection.immutable.Map<String, Uuid> map = this.topicIds();
            scala.collection.immutable.Map<String, Uuid> map2 = metadataSnapshot.topicIds();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Option<Object> option = this.controllerId();
            Option<Object> option2 = metadataSnapshot.controllerId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            LongMap<Broker> longMap = this.aliveBrokers();
            LongMap<Broker> longMap2 = metadataSnapshot.aliveBrokers();
            if (longMap == null) {
                if (longMap2 != null) {
                    return false;
                }
            } else if (!((Object)longMap).equals(longMap2)) return false;
            LongMap<Map<ListenerName, Node>> longMap3 = this.aliveNodes();
            LongMap<Map<ListenerName, Node>> longMap4 = metadataSnapshot.aliveNodes();
            if (longMap3 == null) {
                if (longMap4 != null) {
                    return false;
                }
            } else if (!((Object)longMap3).equals(longMap4)) return false;
            if (!metadataSnapshot.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ZkMetadataCache kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer() {
            return this.$outer;
        }

        public MetadataSnapshot(ZkMetadataCache $outer, AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            this.partitionStates = partitionStates;
            this.topicIds = topicIds;
            this.controllerId = controllerId;
            this.aliveBrokers = aliveBrokers;
            this.aliveNodes = aliveNodes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$(this);
        }
    }
}

