/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNodeStatus;
import kafka.zk.FeatureZNodeStatus$;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class FeatureZNode$
implements scala.Serializable {
    public static FeatureZNode$ MODULE$;
    private final String VersionKey;
    private final String StatusKey;
    private final String FeaturesKey;
    private final int V1;
    private final int CurrentVersion;

    static {
        new FeatureZNode$();
    }

    private String VersionKey() {
        return this.VersionKey;
    }

    private String StatusKey() {
        return this.StatusKey;
    }

    private String FeaturesKey() {
        return this.FeaturesKey;
    }

    public int V1() {
        return this.V1;
    }

    public int CurrentVersion() {
        return this.CurrentVersion;
    }

    public String path() {
        return "/feature";
    }

    public java.util.Map<String, java.util.Map<String, Short>> asJavaMap(Map<String, Map<String, Object>> scalaMap) {
        return CollectionConverters$.MODULE$.mapAsJavaMapConverter(scalaMap.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            String featureName = (String)x0$1._1();
            Map versionInfo = (Map)x0$1._2();
            Tuple2 tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(featureName), CollectionConverters$.MODULE$.mapAsJavaMapConverter(versionInfo.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError((Object)null);
                }
                String label = (String)x0$2._1();
                short version = BoxesRunTime.unboxToShort(x0$2._2());
                Tuple2<String, Short> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(label), version);
                return tuple2;
            }, Map$.MODULE$.canBuildFrom())).asJava());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public byte[] encode(FeatureZNode featureZNode) {
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.VersionKey()), BoxesRunTime.boxToInteger(this.CurrentVersion())), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.StatusKey()), BoxesRunTime.boxToInteger(featureZNode.status().id())), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.FeaturesKey()), featureZNode.features().toMap())}));
        return Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(jsonMap).asJava());
    }

    public FeatureZNode decode(byte[] jsonBytes) {
        Features<FinalizedVersionRange> finalizedFeatures;
        Option<FeatureZNodeStatus> status;
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseBytes(jsonBytes);
        if (either instanceof Right) {
            JsonObject featureInfo = ((JsonValue)((Right)either).value()).asJsonObject();
            int version = BoxesRunTime.unboxToInt(featureInfo.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
            if (version < this.V1()) {
                throw new IllegalArgumentException(new StringBuilder(46).append("Unsupported version: ").append(version).append(" of feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            Option featuresMap = featureInfo.get(this.FeaturesKey()).flatMap((Function1<JsonValue, Option> & Serializable & scala.Serializable)x$20 -> x$20.to(DecodeJson$.MODULE$.decodeOption(DecodeJson$.MODULE$.decodeMap(DecodeJson$.MODULE$.decodeMap(DecodeJson$DecodeInt$.MODULE$, Map$.MODULE$.canBuildFrom()), Map$.MODULE$.canBuildFrom()))));
            if (featuresMap.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(35).append("Features map can not be absent in: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            java.util.Map<String, java.util.Map<String, Short>> features = this.asJavaMap((Map)featuresMap.map((Function1<Map, Map> & Serializable & scala.Serializable)theMap -> theMap.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError((Object)null);
                }
                String featureName = (String)x0$1._1();
                Map versionInfo = (Map)x0$1._2();
                Tuple2 tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(featureName), versionInfo.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
                    if (x0$2 == null) {
                        throw new MatchError((Object)null);
                    }
                    String label = (String)x0$2._1();
                    int version = x0$2._2$mcI$sp();
                    Tuple2<String, Short> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(label), BoxesRunTime.boxToShort((short)version));
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom()));
                return tuple2;
            }, Map$.MODULE$.canBuildFrom())).getOrElse((Function0<Map> & Serializable & scala.Serializable)() -> (Map)Map$.MODULE$.apply(Nil$.MODULE$)));
            Option statusInt = featureInfo.get(this.StatusKey()).flatMap((Function1<JsonValue, Option> & Serializable & scala.Serializable)x$21 -> x$21.to(DecodeJson$.MODULE$.decodeOption(DecodeJson$DecodeInt$.MODULE$)));
            if (statusInt.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(49).append("Status can not be absent in feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            status = FeatureZNodeStatus$.MODULE$.withNameOpt(BoxesRunTime.unboxToInt(statusInt.get()));
            if (status.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(49).append("Malformed status: ").append(statusInt).append(" found in feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            try {
                finalizedFeatures = Features.fromFinalizedFeaturesMap(features);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(new StringBuilder(50).append("Unable to convert to finalized features from map: ").append(features).toString(), e);
            }
        } else {
            if (either instanceof Left) {
                JsonProcessingException e = (JsonProcessingException)((Left)either).value();
                throw new IllegalArgumentException(new StringBuilder(37).append("Failed to parse feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString(), e);
            }
            throw new MatchError(either);
        }
        FeatureZNode featureZNode = new FeatureZNode(status.get(), finalizedFeatures);
        return featureZNode;
    }

    public FeatureZNode apply(FeatureZNodeStatus status, Features<FinalizedVersionRange> features) {
        return new FeatureZNode(status, features);
    }

    public Option<Tuple2<FeatureZNodeStatus, Features<FinalizedVersionRange>>> unapply(FeatureZNode x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some<Tuple2<FeatureZNodeStatus, Features<FinalizedVersionRange>>>(new Tuple2<FeatureZNodeStatus, Features<FinalizedVersionRange>>(x$0.status(), x$0.features()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FeatureZNode$() {
        MODULE$ = this;
        this.VersionKey = "version";
        this.StatusKey = "status";
        this.FeaturesKey = "features";
        this.V1 = 1;
        this.CurrentVersion = this.V1();
    }
}

