/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.timeline.Snapshot;
import org.slf4j.Logger;

public class SnapshotRegistry {
    private final Logger log;
    private final HashMap<Long, Snapshot> snapshots = new HashMap();
    private final Snapshot head = new Snapshot(Long.MIN_VALUE);

    public SnapshotRegistry(LogContext logContext) {
        this.log = logContext.logger(SnapshotRegistry.class);
    }

    public Iterator<Snapshot> iterator() {
        return new SnapshotIterator(this.head.next());
    }

    public Iterator<Snapshot> iterator(long epoch) {
        return this.iterator(this.getSnapshot(epoch));
    }

    public Iterator<Snapshot> iterator(Snapshot snapshot) {
        return new SnapshotIterator(snapshot);
    }

    public Iterator<Snapshot> reverseIterator() {
        return new ReverseSnapshotIterator();
    }

    public List<Long> epochsList() {
        ArrayList<Long> result2 = new ArrayList<Long>();
        Iterator<Snapshot> iterator = this.iterator();
        while (iterator.hasNext()) {
            result2.add(iterator.next().epoch());
        }
        return result2;
    }

    public Snapshot getSnapshot(long epoch) {
        Snapshot snapshot = this.snapshots.get(epoch);
        if (snapshot == null) {
            throw new RuntimeException("No snapshot for epoch " + epoch + ". Snapshot epochs are: " + this.epochsList().stream().map(e -> e.toString()).collect(Collectors.joining(", ")));
        }
        return snapshot;
    }

    public Snapshot createSnapshot(long epoch) {
        Snapshot last = this.head.prev();
        if (last.epoch() >= epoch) {
            throw new RuntimeException("Can't create a new snapshot at epoch " + epoch + " because there is already a snapshot with epoch " + last.epoch());
        }
        Snapshot snapshot = new Snapshot(epoch);
        last.appendNext(snapshot);
        this.snapshots.put(epoch, snapshot);
        this.log.debug("Creating snapshot {}", (Object)epoch);
        return snapshot;
    }

    public void revertToSnapshot(long targetEpoch) {
        Snapshot target = this.getSnapshot(targetEpoch);
        Iterator<Snapshot> iterator = this.iterator(target);
        iterator.next();
        while (iterator.hasNext()) {
            Snapshot snapshot = iterator.next();
            this.log.debug("Deleting snapshot {} because we are reverting to {}", (Object)snapshot.epoch(), (Object)targetEpoch);
            iterator.remove();
        }
        target.handleRevert();
    }

    public void deleteSnapshot(long targetEpoch) {
        this.deleteSnapshot(this.getSnapshot(targetEpoch));
    }

    public void deleteSnapshot(Snapshot snapshot) {
        Snapshot prev = snapshot.prev();
        if (prev != this.head) {
            prev.mergeFrom(snapshot);
        } else {
            snapshot.erase();
        }
        this.log.debug("Deleting snapshot {}", (Object)snapshot.epoch());
        this.snapshots.remove(snapshot.epoch(), snapshot);
    }

    public void deleteSnapshotsUpTo(long targetEpoch) {
        Iterator<Snapshot> iterator = this.iterator();
        while (iterator.hasNext()) {
            Snapshot snapshot = iterator.next();
            if (snapshot.epoch() >= targetEpoch) {
                return;
            }
            this.log.debug("Deleting snapshot {}", (Object)snapshot.epoch());
            iterator.remove();
        }
    }

    public long latestEpoch() {
        return this.head.prev().epoch();
    }

    class ReverseSnapshotIterator
    implements Iterator<Snapshot> {
        Snapshot cur;

        ReverseSnapshotIterator() {
            this.cur = SnapshotRegistry.this.head.prev();
        }

        @Override
        public boolean hasNext() {
            return this.cur != SnapshotRegistry.this.head;
        }

        @Override
        public Snapshot next() {
            Snapshot result2 = this.cur;
            this.cur = this.cur.prev();
            return result2;
        }
    }

    class SnapshotIterator
    implements Iterator<Snapshot> {
        Snapshot cur;
        Snapshot result = null;

        SnapshotIterator(Snapshot start) {
            this.cur = start;
        }

        @Override
        public boolean hasNext() {
            return this.cur != SnapshotRegistry.this.head;
        }

        @Override
        public Snapshot next() {
            this.result = this.cur;
            this.cur = this.cur.next();
            return this.result;
        }

        @Override
        public void remove() {
            if (this.result == null) {
                throw new IllegalStateException();
            }
            SnapshotRegistry.this.deleteSnapshot(this.result);
            this.result = null;
        }
    }
}

