/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.security.DockerCredentialTokenIdentifier;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DockerClientConfigHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DockerClientConfigHandler.class);
    private static final String CONFIG_AUTHS_KEY = "auths";
    private static final String CONFIG_AUTH_KEY = "auth";

    private DockerClientConfigHandler() {
    }

    public static Credentials readCredentialsFromConfigFile(Path configFile, Configuration conf, String applicationId) throws IOException {
        FSDataInputStream fileHandle;
        String contents = null;
        FileSystem fs = (configFile = new Path(configFile.toUri())).getFileSystem(conf);
        if (fs != null && (fileHandle = fs.open(configFile)) != null) {
            contents = IOUtils.toString((InputStream)fileHandle, StandardCharsets.UTF_8);
        }
        if (contents == null) {
            throw new IOException("Failed to read Docker client configuration: " + configFile);
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = mapper.getFactory();
        JsonParser parser = factory.createParser(contents);
        JsonNode rootNode = (JsonNode)mapper.readTree(parser);
        Credentials credentials = new Credentials();
        if (rootNode.has(CONFIG_AUTHS_KEY)) {
            Iterator<String> iter = rootNode.get(CONFIG_AUTHS_KEY).fieldNames();
            while (iter.hasNext()) {
                String registryUrl = iter.next();
                String registryCred = rootNode.get(CONFIG_AUTHS_KEY).get(registryUrl).get(CONFIG_AUTH_KEY).asText();
                DockerCredentialTokenIdentifier tokenId = new DockerCredentialTokenIdentifier(registryUrl, applicationId);
                Token token = new Token(tokenId.getBytes(), registryCred.getBytes(StandardCharsets.UTF_8), tokenId.getKind(), new Text(registryUrl));
                credentials.addToken(new Text(registryUrl + "-" + applicationId), token);
                LOG.info("Token read from Docker client configuration file: " + token.toString());
            }
        }
        return credentials;
    }

    public static Credentials getCredentialsFromTokensByteBuffer(ByteBuffer tokens) throws IOException {
        Credentials credentials = new Credentials();
        DataInputByteBuffer dibb = new DataInputByteBuffer();
        tokens.rewind();
        dibb.reset(new ByteBuffer[]{tokens});
        credentials.readTokenStorageStream((DataInputStream)dibb);
        tokens.rewind();
        if (LOG.isDebugEnabled()) {
            for (Token token : credentials.getAllTokens()) {
                LOG.debug("Token read from token storage: {}", (Object)token);
            }
        }
        return credentials;
    }

    public static boolean writeDockerCredentialsToPath(File outConfigFile, Credentials credentials) throws IOException {
        boolean foundDockerCred = false;
        if (credentials.numberOfTokens() > 0) {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode rootNode = mapper.createObjectNode();
            ObjectNode registryUrlNode = mapper.createObjectNode();
            for (Token tk : credentials.getAllTokens()) {
                if (!tk.getKind().equals((Object)DockerCredentialTokenIdentifier.KIND)) continue;
                foundDockerCred = true;
                DockerCredentialTokenIdentifier ti = (DockerCredentialTokenIdentifier)tk.decodeIdentifier();
                ObjectNode registryCredNode = mapper.createObjectNode();
                registryUrlNode.set(ti.getRegistryUrl(), registryCredNode);
                registryCredNode.put(CONFIG_AUTH_KEY, new String(tk.getPassword(), StandardCharsets.UTF_8));
                LOG.debug("Prepared token for write: {}", (Object)tk);
            }
            if (foundDockerCred) {
                rootNode.set(CONFIG_AUTHS_KEY, registryUrlNode);
                String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(rootNode);
                FileUtils.writeStringToFile(outConfigFile, json, StandardCharsets.UTF_8);
            }
        }
        return foundDockerCred;
    }
}

