/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.confluent.kafka.formatter.SchemaMessageDeserializer;
import io.confluent.kafka.formatter.SchemaMessageFormatter;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.serializers.protobuf.AbstractKafkaProtobufDeserializer;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class ProtobufMessageFormatter
extends SchemaMessageFormatter<Message> {
    private boolean preserveFieldNames = false;

    public ProtobufMessageFormatter() {
    }

    ProtobufMessageFormatter(String url, Deserializer keyDeserializer) {
        super(url, keyDeserializer);
    }

    @Override
    protected SchemaMessageDeserializer<Message> createDeserializer(Deserializer keyDeserializer) {
        return new ProtobufMessageDeserializer(keyDeserializer);
    }

    @Override
    public void init(Properties props) {
        super.init(props);
        if (props.containsKey("preserve.json.field.name")) {
            this.preserveFieldNames = props.getProperty("preserve.json.field.name").trim().toLowerCase().equals("true");
        }
    }

    @Override
    protected void writeTo(String topic, Boolean isKey, Headers headers, byte[] data, PrintStream output) throws IOException {
        Message object = (Message)this.deserializer.deserialize(topic, isKey, headers, data);
        try {
            JsonFormat.Printer printer = JsonFormat.printer().includingDefaultValueFields().omittingInsignificantWhitespace();
            output.print(object == null ? null : (this.preserveFieldNames ? printer.preservingProtoFieldNames().print(object) : printer.print(object)));
        }
        catch (InvalidProtocolBufferException e) {
            throw new SerializationException("Error serializing Protobuf data to json", e);
        }
    }

    @Override
    protected SchemaProvider getProvider() {
        return new ProtobufSchemaProvider();
    }

    static class ProtobufMessageDeserializer
    extends AbstractKafkaProtobufDeserializer
    implements SchemaMessageDeserializer<Message> {
        protected final Deserializer keyDeserializer;

        ProtobufMessageDeserializer(Deserializer keyDeserializer) {
            this.keyDeserializer = keyDeserializer;
        }

        @Override
        public void configure(Map<String, ?> configs, boolean isKey) {
            this.configure(this.deserializerConfig(configs), null);
        }

        @Override
        public Deserializer getKeyDeserializer() {
            return this.keyDeserializer;
        }

        @Override
        public Object deserializeKey(String topic, Headers headers, byte[] payload) {
            return this.keyDeserializer.deserialize(topic, headers, payload);
        }

        @Override
        public Message deserialize(String topic, Boolean isKey, Headers headers, byte[] payload) throws SerializationException {
            return (Message)super.deserialize(false, topic, isKey, headers, payload);
        }

        @Override
        public SchemaRegistryClient getSchemaRegistryClient() {
            return this.schemaRegistry;
        }

        @Override
        public void close() throws IOException {
            if (this.keyDeserializer != null) {
                this.keyDeserializer.close();
            }
            super.close();
        }
    }
}

