/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ListOffsetsResponse;

public class ListOffsetsRequest
extends AbstractRequest {
    public static final long EARLIEST_TIMESTAMP = -2L;
    public static final long LATEST_TIMESTAMP = -1L;
    public static final int CONSUMER_REPLICA_ID = -1;
    public static final int DEBUGGING_REPLICA_ID = -2;
    private final ListOffsetsRequestData data;
    private final Set<TopicPartition> duplicatePartitions;

    private ListOffsetsRequest(ListOffsetsRequestData data, short version) {
        super(ApiKeys.LIST_OFFSETS, version);
        this.data = data;
        this.duplicatePartitions = new HashSet<TopicPartition>();
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>();
        for (ListOffsetsRequestData.ListOffsetsTopic topic : data.topics()) {
            for (ListOffsetsRequestData.ListOffsetsPartition partition2 : topic.partitions()) {
                TopicPartition tp = new TopicPartition(topic.name(), partition2.partitionIndex());
                if (partitions.add(tp)) continue;
                this.duplicatePartitions.add(tp);
            }
        }
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        short errorCode = Errors.forException(e).code();
        ArrayList<ListOffsetsResponseData.ListOffsetsTopicResponse> responses = new ArrayList<ListOffsetsResponseData.ListOffsetsTopicResponse>();
        for (ListOffsetsRequestData.ListOffsetsTopic topic : this.data.topics()) {
            ListOffsetsResponseData.ListOffsetsTopicResponse topicResponse = new ListOffsetsResponseData.ListOffsetsTopicResponse().setName(topic.name());
            ArrayList<ListOffsetsResponseData.ListOffsetsPartitionResponse> partitions = new ArrayList<ListOffsetsResponseData.ListOffsetsPartitionResponse>();
            for (ListOffsetsRequestData.ListOffsetsPartition partition2 : topic.partitions()) {
                ListOffsetsResponseData.ListOffsetsPartitionResponse partitionResponse = new ListOffsetsResponseData.ListOffsetsPartitionResponse().setErrorCode(errorCode).setPartitionIndex(partition2.partitionIndex());
                if (versionId == 0) {
                    partitionResponse.setOldStyleOffsets(Collections.emptyList());
                } else {
                    partitionResponse.setOffset(-1L).setTimestamp(-1L);
                }
                partitions.add(partitionResponse);
            }
            topicResponse.setPartitions(partitions);
            responses.add(topicResponse);
        }
        ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(throttleTimeMs).setTopics(responses);
        return new ListOffsetsResponse(responseData);
    }

    @Override
    public ListOffsetsRequestData data() {
        return this.data;
    }

    public int replicaId() {
        return this.data.replicaId();
    }

    public IsolationLevel isolationLevel() {
        return IsolationLevel.forId(this.data.isolationLevel());
    }

    public List<ListOffsetsRequestData.ListOffsetsTopic> topics() {
        return this.data.topics();
    }

    public Set<TopicPartition> duplicatePartitions() {
        return this.duplicatePartitions;
    }

    public static ListOffsetsRequest parse(ByteBuffer buffer, short version) {
        return new ListOffsetsRequest(new ListOffsetsRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static List<ListOffsetsRequestData.ListOffsetsTopic> toListOffsetsTopics(Map<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition> timestampsToSearch) {
        HashMap<String, ListOffsetsRequestData.ListOffsetsTopic> topics = new HashMap<String, ListOffsetsRequestData.ListOffsetsTopic>();
        for (Map.Entry<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition> entry : timestampsToSearch.entrySet()) {
            TopicPartition tp = entry.getKey();
            ListOffsetsRequestData.ListOffsetsTopic topic = topics.computeIfAbsent(tp.topic(), k -> new ListOffsetsRequestData.ListOffsetsTopic().setName(tp.topic()));
            topic.partitions().add(entry.getValue());
        }
        return new ArrayList<ListOffsetsRequestData.ListOffsetsTopic>(topics.values());
    }

    public static ListOffsetsRequestData.ListOffsetsTopic singletonRequestData(String topic, int partitionIndex, long timestamp, int maxNumOffsets) {
        return new ListOffsetsRequestData.ListOffsetsTopic().setName(topic).setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(partitionIndex).setTimestamp(timestamp).setMaxNumOffsets(maxNumOffsets)));
    }

    public static class Builder
    extends AbstractRequest.Builder<ListOffsetsRequest> {
        private final ListOffsetsRequestData data;

        public static Builder forReplica(short allowedVersion, int replicaId) {
            return new Builder(0, allowedVersion, replicaId, IsolationLevel.READ_UNCOMMITTED);
        }

        public static Builder forConsumer(boolean requireTimestamp, IsolationLevel isolationLevel) {
            short minVersion = 0;
            if (isolationLevel == IsolationLevel.READ_COMMITTED) {
                minVersion = 2;
            } else if (requireTimestamp) {
                minVersion = 1;
            }
            return new Builder(minVersion, ApiKeys.LIST_OFFSETS.latestVersion(), -1, isolationLevel);
        }

        private Builder(short oldestAllowedVersion, short latestAllowedVersion, int replicaId, IsolationLevel isolationLevel) {
            super(ApiKeys.LIST_OFFSETS, oldestAllowedVersion, latestAllowedVersion);
            this.data = new ListOffsetsRequestData().setIsolationLevel(isolationLevel.id()).setReplicaId(replicaId);
        }

        public Builder setTargetTimes(List<ListOffsetsRequestData.ListOffsetsTopic> topics) {
            this.data.setTopics(topics);
            return this;
        }

        @Override
        public ListOffsetsRequest build(short version) {
            return new ListOffsetsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

