/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.protobuf;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.plugin.inputformat.protobuf.ProtoBufRecordExtractor;
import org.apache.pinot.plugin.inputformat.protobuf.ProtoBufRecordReaderConfig;
import org.apache.pinot.plugin.inputformat.protobuf.ProtoBufUtils;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.data.readers.RecordReaderUtils;

public class ProtoBufRecordReader
implements RecordReader {
    private File _dataFile;
    private ProtoBufRecordExtractor _recordExtractor;
    private InputStream _inputStream;
    private boolean _hasNext;
    private Message.Builder _builder;

    private boolean hasMoreToRead() throws IOException {
        this._inputStream.mark(1);
        int nextByte = this._inputStream.read();
        this._inputStream.reset();
        return nextByte != -1;
    }

    private void init() throws IOException {
        this._inputStream = RecordReaderUtils.getBufferedInputStream((File)this._dataFile);
        try {
            this._hasNext = this.hasMoreToRead();
        }
        catch (Exception e) {
            this._inputStream.close();
            throw e;
        }
    }

    public void init(File dataFile, @Nullable Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) throws IOException {
        this._dataFile = dataFile;
        ProtoBufRecordReaderConfig protoBufRecordReaderConfig = (ProtoBufRecordReaderConfig)recordReaderConfig;
        Preconditions.checkNotNull(protoBufRecordReaderConfig.getDescriptorFile(), "Protocol Buffer schema descriptor file must be provided");
        Descriptors.Descriptor descriptor2 = this.buildProtoBufDescriptor(protoBufRecordReaderConfig);
        this._recordExtractor = new ProtoBufRecordExtractor();
        this._recordExtractor.init(fieldsToRead, null);
        DynamicMessage dynamicMessage = DynamicMessage.getDefaultInstance(descriptor2);
        this._builder = dynamicMessage.newBuilderForType();
        this.init();
    }

    private Descriptors.Descriptor buildProtoBufDescriptor(ProtoBufRecordReaderConfig protoBufRecordReaderConfig) throws IOException {
        try {
            InputStream fin = ProtoBufUtils.getDescriptorFileInputStream(protoBufRecordReaderConfig.getDescriptorFile().toString());
            DescriptorProtos.FileDescriptorSet set = DescriptorProtos.FileDescriptorSet.parseFrom(fin);
            Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom(set.getFile(0), new Descriptors.FileDescriptor[0]);
            return fileDescriptor.getMessageTypes().get(0);
        }
        catch (Exception e) {
            throw new IOException("Failed to create Protobuf descriptor", e);
        }
    }

    public boolean hasNext() {
        return this._hasNext;
    }

    public GenericRow next(GenericRow reuse) throws IOException {
        Message message;
        try {
            this._builder.mergeDelimitedFrom(this._inputStream);
            message = this._builder.build();
        }
        catch (Exception e) {
            throw new IOException("Caught exception while reading protobuf object", e);
        }
        finally {
            this._builder.clear();
        }
        this._recordExtractor.extract(message, reuse);
        this._hasNext = this.hasMoreToRead();
        return reuse;
    }

    public void rewind() throws IOException {
        this._inputStream.close();
        this.init();
    }

    public void close() throws IOException {
        this._inputStream.close();
    }
}

