/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.logredactor.internal;

import io.confluent.log4j.redactor.LogRedactorMetrics;
import io.confluent.logredactor.internal.MetricsTagBuilder;
import io.confluent.logredactor.internal.StringRedactor;
import io.confluent.logredactor.internal.UrlReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.log4j.Logger;

public class StringRedactorEngine {
    public static final long DEFAULT_REFRESH_INTERVAL_MILLIS = -1L;
    public static final int DEFAULT_URL_READER_TIMEOUT_MILLIS = 60000;
    public static final LogRedactorMetrics DEFAULT_METRICS = LogRedactorMetrics.NOOP;
    public static final String DEFAULT_RULES_LOCATION = "";
    private static final Logger logger = Logger.getLogger((String)"redactorPolicy");
    public static Queue<Thread> backgroundThreads = new ConcurrentLinkedQueue<Thread>();
    private Thread backgroundThread;
    private String latestPolicyContents;
    private StringRedactor redactor;
    private final String rulesLocation;
    private final long refreshIntervalMillis;
    private final int urlReaderTimeoutMillis;
    public final LogRedactorMetrics metrics;

    public StringRedactorEngine(String rulesLocation, long refreshInterval, int timeOut, LogRedactorMetrics metrics) {
        this.rulesLocation = rulesLocation.trim();
        this.refreshIntervalMillis = refreshInterval;
        this.urlReaderTimeoutMillis = timeOut;
        this.metrics = metrics;
        this.readAndCompileRules();
        if (this.rulesLocation.isEmpty()) {
            logger.error((Object)"No URI nor file location is provided for the rules.");
        } else if (this.refreshIntervalMillis > 0L) {
            this.backgroundThread = new Thread((Runnable)new BackgroundRefresher(), "logredactor-refresher");
            this.backgroundThread.setDaemon(true);
            this.backgroundThread.start();
            backgroundThreads.add(this.backgroundThread);
        }
    }

    public synchronized StringRedactor getRedactor() {
        return this.redactor;
    }

    private String readRules() {
        long startTime = System.currentTimeMillis();
        logger.debug((Object)("Reading rules from " + this.rulesLocation));
        String result = DEFAULT_RULES_LOCATION;
        if (!this.rulesLocation.isEmpty()) {
            if (this.rulesLocation.startsWith("http")) {
                try {
                    result = UrlReader.urlToString(this.rulesLocation, this.urlReaderTimeoutMillis);
                }
                catch (IOException e) {
                    logger.warn((Object)("Failed while reading redactor policy URL: " + this.rulesLocation), (Throwable)e);
                    this.metrics.count("error", new MetricsTagBuilder().policyLocation(this.rulesLocation).errorCode(MetricsTagBuilder.ErrorCode.READ_ERROR).build());
                }
            } else {
                try {
                    result = this.readFile(this.rulesLocation);
                }
                catch (IOException e) {
                    logger.warn((Object)("Failed while reading redactor policy file: " + this.rulesLocation), (Throwable)e);
                    this.metrics.count("error", new MetricsTagBuilder().policyLocation(this.rulesLocation).errorCode(MetricsTagBuilder.ErrorCode.READ_ERROR).build());
                }
            }
        }
        double elapsed = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        this.metrics.timer(elapsed, "read_policy_seconds", new MetricsTagBuilder().policyLocation(this.rulesLocation).policyContent(result).build());
        logger.debug((Object)("Read redaction rules from " + this.rulesLocation + " was successful"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileRules(String rulesJson, String rulesLocation) {
        try {
            StringRedactor newRulesRedactor = StringRedactor.createFromJsonString(rulesJson, rulesLocation, this.metrics);
            StringRedactorEngine stringRedactorEngine = this;
            synchronized (stringRedactorEngine) {
                this.latestPolicyContents = rulesJson;
                this.redactor = newRulesRedactor;
            }
            logger.debug((Object)("Updated rules from " + rulesLocation));
        }
        catch (IOException e) {
            StringRedactorEngine stringRedactorEngine = this;
            synchronized (stringRedactorEngine) {
                if (this.redactor == null) {
                    this.redactor = StringRedactor.emptyStringRedactor(this.metrics, new MetricsTagBuilder().policyLocation(rulesLocation).policyContent(rulesJson).build());
                }
            }
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error while compiling redactor rules:" + e.getMessage() + "\n Rules: " + rulesJson));
            } else {
                logger.error((Object)("Error while compiling redactor rules:" + e.getMessage()));
            }
            this.metrics.count("error", new MetricsTagBuilder().policyLocation(rulesLocation).errorCode(MetricsTagBuilder.ErrorCode.PARSE_ERROR).build());
        }
    }

    private void readAndCompileRules() {
        String latest = this.readRules();
        if (!latest.equals(this.latestPolicyContents)) {
            this.compileRules(latest, this.rulesLocation);
        }
        this.redactor.measureRuleCount();
    }

    private String readFile(String file) throws IOException {
        return new String(Files.readAllBytes(Paths.get(file, new String[0])));
    }

    public static void closeBackgroundThreads() {
        Thread t2 = backgroundThreads.poll();
        while (t2 != null) {
            t2.interrupt();
            t2 = backgroundThreads.poll();
        }
    }

    class BackgroundRefresher
    implements Runnable {
        BackgroundRefresher() {
        }

        @Override
        public void run() {
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    StringRedactorEngine.this.readAndCompileRules();
                    long sleepMillis = 1L + StringRedactorEngine.this.refreshIntervalMillis / 2L + rand.nextLong(StringRedactorEngine.this.refreshIntervalMillis / 2L);
                    Thread.sleep(sleepMillis);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)("Background refresher thread completing due to interruption: " + e.getMessage()));
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

