/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.openidconnect;

import com.google.api.client.auth.openidconnect.Environment;
import com.google.api.client.auth.openidconnect.HttpTransportFactory;
import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.Base64;
import com.google.api.client.util.Clock;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.cache.CacheBuilder;
import org.apache.pinot.shaded.com.google.common.cache.CacheLoader;
import org.apache.pinot.shaded.com.google.common.cache.LoadingCache;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableMap;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableSet;
import org.apache.pinot.shaded.com.google.common.util.concurrent.UncheckedExecutionException;

public class IdTokenVerifier {
    private static final Logger LOGGER = Logger.getLogger(IdTokenVerifier.class.getName());
    private static final String IAP_CERT_URL = "https://www.gstatic.com/iap/verify/public_key-jwk";
    private static final String FEDERATED_SIGNON_CERT_URL = "https://www.googleapis.com/oauth2/v3/certs";
    private static final Set<String> SUPPORTED_ALGORITHMS = ImmutableSet.of("RS256", "ES256");
    private static final String NOT_SUPPORTED_ALGORITHM = "Unexpected signing algorithm %s: expected either RS256 or ES256";
    static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    static final String SKIP_SIGNATURE_ENV_VAR = "OAUTH_CLIENT_SKIP_SIGNATURE";
    public static final long DEFAULT_TIME_SKEW_SECONDS = 300L;
    private final Clock clock;
    private final String certificatesLocation;
    private final Environment environment;
    private final LoadingCache<String, Map<String, PublicKey>> publicKeyCache;
    private final long acceptableTimeSkewSeconds;
    private final Collection<String> issuers;
    private final Collection<String> audience;

    public IdTokenVerifier() {
        this(new Builder());
    }

    protected IdTokenVerifier(Builder builder) {
        this.certificatesLocation = builder.certificatesLocation;
        this.clock = builder.clock;
        this.acceptableTimeSkewSeconds = builder.acceptableTimeSkewSeconds;
        this.issuers = builder.issuers == null ? null : Collections.unmodifiableCollection(builder.issuers);
        this.audience = builder.audience == null ? null : Collections.unmodifiableCollection(builder.audience);
        HttpTransportFactory transport = builder.httpTransportFactory == null ? new DefaultHttpTransportFactory() : builder.httpTransportFactory;
        this.publicKeyCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build(new PublicKeyLoader(transport));
        this.environment = builder.environment == null ? new Environment() : builder.environment;
    }

    public final Clock getClock() {
        return this.clock;
    }

    public final long getAcceptableTimeSkewSeconds() {
        return this.acceptableTimeSkewSeconds;
    }

    public final String getIssuer() {
        if (this.issuers == null) {
            return null;
        }
        return this.issuers.iterator().next();
    }

    public final Collection<String> getIssuers() {
        return this.issuers;
    }

    public final Collection<String> getAudience() {
        return this.audience;
    }

    @Deprecated
    public boolean verify(IdToken idToken) {
        try {
            return this.verifyOrThrow(idToken);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            return false;
        }
    }

    public boolean verifyOrThrow(IdToken idToken) throws IOException {
        boolean payloadValid = this.verifyPayload(idToken);
        if (!payloadValid) {
            return false;
        }
        try {
            return this.verifySignature(idToken);
        }
        catch (VerificationException ex) {
            LOGGER.log(Level.INFO, "Id token signature verification failed. ", ex);
            return false;
        }
    }

    protected boolean verifyPayload(IdToken idToken) {
        boolean tokenPayloadValid = !(this.issuers != null && !idToken.verifyIssuer(this.issuers) || this.audience != null && !idToken.verifyAudience(this.audience) || !idToken.verifyTime(this.clock.currentTimeMillis(), this.acceptableTimeSkewSeconds));
        return tokenPayloadValid;
    }

    @VisibleForTesting
    boolean verifySignature(IdToken idToken) throws IOException, VerificationException {
        if (Boolean.parseBoolean(this.environment.getVariable(SKIP_SIGNATURE_ENV_VAR))) {
            return true;
        }
        if (!SUPPORTED_ALGORITHMS.contains(idToken.getHeader().getAlgorithm())) {
            throw new VerificationException(String.format(NOT_SUPPORTED_ALGORITHM, idToken.getHeader().getAlgorithm()));
        }
        PublicKey publicKeyToUse = null;
        try {
            String certificateLocation = this.getCertificateLocation(idToken.getHeader());
            publicKeyToUse = this.publicKeyCache.get(certificateLocation).get(idToken.getHeader().getKeyId());
        }
        catch (ExecutionException | UncheckedExecutionException e) {
            throw new IOException("Error fetching public key from certificate location " + this.certificatesLocation, e);
        }
        if (publicKeyToUse == null) {
            throw new IOException("Could not find public key for provided keyId: " + idToken.getHeader().getKeyId());
        }
        try {
            if (idToken.verifySignature(publicKeyToUse)) {
                return true;
            }
            throw new VerificationException("Invalid signature");
        }
        catch (GeneralSecurityException e) {
            throw new VerificationException("Error validating token", e);
        }
    }

    private String getCertificateLocation(JsonWebSignature.Header header) throws VerificationException {
        if (this.certificatesLocation != null) {
            return this.certificatesLocation;
        }
        switch (header.getAlgorithm()) {
            case "RS256": {
                return FEDERATED_SIGNON_CERT_URL;
            }
            case "ES256": {
                return IAP_CERT_URL;
            }
        }
        throw new VerificationException(String.format(NOT_SUPPORTED_ALGORITHM, header.getAlgorithm()));
    }

    static class DefaultHttpTransportFactory
    implements HttpTransportFactory {
        DefaultHttpTransportFactory() {
        }

        @Override
        public HttpTransport create() {
            return HTTP_TRANSPORT;
        }
    }

    static class VerificationException
    extends Exception {
        public VerificationException(String message) {
            super(message);
        }

        public VerificationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    static class PublicKeyLoader
    extends CacheLoader<String, Map<String, PublicKey>> {
        private static final int DEFAULT_NUMBER_OF_RETRIES = 2;
        private static final int INITIAL_RETRY_INTERVAL_MILLIS = 1000;
        private static final double RETRY_RANDOMIZATION_FACTOR = 0.1;
        private static final double RETRY_MULTIPLIER = 2.0;
        private final HttpTransportFactory httpTransportFactory;

        PublicKeyLoader(HttpTransportFactory httpTransportFactory) {
            this.httpTransportFactory = httpTransportFactory;
        }

        @Override
        public Map<String, PublicKey> load(String certificateUrl) throws Exception {
            ImmutableMap<String, PublicKey> keyCache;
            JsonWebKeySet jwks;
            HttpTransport httpTransport = this.httpTransportFactory.create();
            try {
                HttpRequest request = httpTransport.createRequestFactory().buildGetRequest(new GenericUrl(certificateUrl)).setParser(GsonFactory.getDefaultInstance().createJsonObjectParser());
                request.setNumberOfRetries(2);
                Iterator<JsonWebKey> backoff = new ExponentialBackOff.Builder().setInitialIntervalMillis(1000).setRandomizationFactor(0.1).setMultiplier(2.0).build();
                request.setUnsuccessfulResponseHandler(new HttpBackOffUnsuccessfulResponseHandler((BackOff)((Object)backoff)).setBackOffRequired(HttpBackOffUnsuccessfulResponseHandler.BackOffRequired.ALWAYS));
                HttpResponse response = request.execute();
                jwks = response.parseAs(JsonWebKeySet.class);
            }
            catch (IOException io) {
                LOGGER.log(Level.WARNING, "Failed to get a certificate from certificate location " + certificateUrl, io);
                throw io;
            }
            ImmutableMap.Builder<String, PublicKey> keyCacheBuilder = new ImmutableMap.Builder<String, PublicKey>();
            if (jwks.keys == null) {
                for (String keyId : jwks.keySet()) {
                    String publicKeyPem = (String)jwks.get(keyId);
                    keyCacheBuilder.put(keyId, this.buildPublicKey(publicKeyPem));
                }
            } else {
                for (JsonWebKey key : jwks.keys) {
                    try {
                        keyCacheBuilder.put(key.kid, this.buildPublicKey(key));
                    }
                    catch (NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException ignored) {
                        LOGGER.log(Level.WARNING, "Failed to put a key into the cache", ignored);
                    }
                }
            }
            if ((keyCache = keyCacheBuilder.build()).isEmpty()) {
                throw new VerificationException("No valid public key returned by the keystore: " + certificateUrl);
            }
            return keyCache;
        }

        private PublicKey buildPublicKey(JsonWebKey key) throws NoSuchAlgorithmException, InvalidParameterSpecException, InvalidKeySpecException {
            if ("ES256".equals(key.alg)) {
                return this.buildEs256PublicKey(key);
            }
            if ("RS256".equals(key.alg)) {
                return this.buildRs256PublicKey(key);
            }
            return null;
        }

        private PublicKey buildPublicKey(String publicPem) throws CertificateException, UnsupportedEncodingException {
            return CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(publicPem.getBytes("UTF-8"))).getPublicKey();
        }

        private PublicKey buildRs256PublicKey(JsonWebKey key) throws NoSuchAlgorithmException, InvalidKeySpecException {
            org.apache.pinot.shaded.com.google.common.base.Preconditions.checkArgument("RSA".equals(key.kty));
            org.apache.pinot.shaded.com.google.common.base.Preconditions.checkNotNull(key.e);
            org.apache.pinot.shaded.com.google.common.base.Preconditions.checkNotNull(key.n);
            BigInteger modulus = new BigInteger(1, Base64.decodeBase64(key.n));
            BigInteger exponent = new BigInteger(1, Base64.decodeBase64(key.e));
            RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePublic(spec);
        }

        private PublicKey buildEs256PublicKey(JsonWebKey key) throws NoSuchAlgorithmException, InvalidParameterSpecException, InvalidKeySpecException {
            org.apache.pinot.shaded.com.google.common.base.Preconditions.checkArgument("EC".equals(key.kty));
            org.apache.pinot.shaded.com.google.common.base.Preconditions.checkArgument("P-256".equals(key.crv));
            BigInteger x = new BigInteger(1, Base64.decodeBase64(key.x));
            BigInteger y = new BigInteger(1, Base64.decodeBase64(key.y));
            ECPoint pubPoint = new ECPoint(x, y);
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
            parameters.init(new ECGenParameterSpec("secp256r1"));
            ECParameterSpec ecParameters = parameters.getParameterSpec(ECParameterSpec.class);
            ECPublicKeySpec pubSpec = new ECPublicKeySpec(pubPoint, ecParameters);
            KeyFactory kf = KeyFactory.getInstance("EC");
            return kf.generatePublic(pubSpec);
        }

        public static class JsonWebKey {
            @Key
            public String alg;
            @Key
            public String crv;
            @Key
            public String kid;
            @Key
            public String kty;
            @Key
            public String use;
            @Key
            public String x;
            @Key
            public String y;
            @Key
            public String e;
            @Key
            public String n;
        }

        public static class JsonWebKeySet
        extends GenericJson {
            @Key
            public List<JsonWebKey> keys;
        }
    }

    public static class Builder {
        Clock clock = Clock.SYSTEM;
        String certificatesLocation;
        Environment environment;
        long acceptableTimeSkewSeconds = 300L;
        Collection<String> issuers;
        Collection<String> audience;
        HttpTransportFactory httpTransportFactory;

        public IdTokenVerifier build() {
            return new IdTokenVerifier(this);
        }

        public final Clock getClock() {
            return this.clock;
        }

        public Builder setClock(Clock clock) {
            this.clock = Preconditions.checkNotNull(clock);
            return this;
        }

        public final String getIssuer() {
            if (this.issuers == null) {
                return null;
            }
            return this.issuers.iterator().next();
        }

        public Builder setIssuer(String issuer) {
            if (issuer == null) {
                return this.setIssuers(null);
            }
            return this.setIssuers(Collections.singleton(issuer));
        }

        public Builder setCertificatesLocation(String certificatesLocation) {
            this.certificatesLocation = certificatesLocation;
            return this;
        }

        public final Collection<String> getIssuers() {
            return this.issuers;
        }

        public Builder setIssuers(Collection<String> issuers) {
            Preconditions.checkArgument(issuers == null || !issuers.isEmpty(), "Issuers must not be empty");
            this.issuers = issuers;
            return this;
        }

        public final Collection<String> getAudience() {
            return this.audience;
        }

        public Builder setAudience(Collection<String> audience) {
            this.audience = audience;
            return this;
        }

        public final long getAcceptableTimeSkewSeconds() {
            return this.acceptableTimeSkewSeconds;
        }

        public Builder setAcceptableTimeSkewSeconds(long acceptableTimeSkewSeconds) {
            Preconditions.checkArgument(acceptableTimeSkewSeconds >= 0L);
            this.acceptableTimeSkewSeconds = acceptableTimeSkewSeconds;
            return this;
        }

        final Environment getEnvironment() {
            return this.environment;
        }

        Builder setEnvironment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public Builder setHttpTransportFactory(HttpTransportFactory httpTransportFactory) {
            this.httpTransportFactory = httpTransportFactory;
            return this;
        }
    }
}

