/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.SnoozeServiceClient;
import com.google.cloud.monitoring.v3.stub.GrpcSnoozeServiceCallableFactory;
import com.google.cloud.monitoring.v3.stub.SnoozeServiceStub;
import com.google.cloud.monitoring.v3.stub.SnoozeServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.monitoring.v3.CreateSnoozeRequest;
import com.google.monitoring.v3.GetSnoozeRequest;
import com.google.monitoring.v3.ListSnoozesRequest;
import com.google.monitoring.v3.ListSnoozesResponse;
import com.google.monitoring.v3.Snooze;
import com.google.monitoring.v3.UpdateSnoozeRequest;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcSnoozeServiceStub
extends SnoozeServiceStub {
    private static final MethodDescriptor<CreateSnoozeRequest, Snooze> createSnoozeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.monitoring.v3.SnoozeService/CreateSnooze").setRequestMarshaller(ProtoUtils.marshaller(CreateSnoozeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Snooze.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSnoozesRequest, ListSnoozesResponse> listSnoozesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.monitoring.v3.SnoozeService/ListSnoozes").setRequestMarshaller(ProtoUtils.marshaller(ListSnoozesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ListSnoozesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSnoozeRequest, Snooze> getSnoozeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.monitoring.v3.SnoozeService/GetSnooze").setRequestMarshaller(ProtoUtils.marshaller(GetSnoozeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Snooze.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateSnoozeRequest, Snooze> updateSnoozeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.monitoring.v3.SnoozeService/UpdateSnooze").setRequestMarshaller(ProtoUtils.marshaller(UpdateSnoozeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Snooze.getDefaultInstance())).build();
    private final UnaryCallable<CreateSnoozeRequest, Snooze> createSnoozeCallable;
    private final UnaryCallable<ListSnoozesRequest, ListSnoozesResponse> listSnoozesCallable;
    private final UnaryCallable<ListSnoozesRequest, SnoozeServiceClient.ListSnoozesPagedResponse> listSnoozesPagedCallable;
    private final UnaryCallable<GetSnoozeRequest, Snooze> getSnoozeCallable;
    private final UnaryCallable<UpdateSnoozeRequest, Snooze> updateSnoozeCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSnoozeServiceStub create(SnoozeServiceStubSettings settings) throws IOException {
        return new GrpcSnoozeServiceStub(settings, ClientContext.create(settings));
    }

    public static final GrpcSnoozeServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcSnoozeServiceStub(SnoozeServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSnoozeServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSnoozeServiceStub(SnoozeServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSnoozeServiceStub(SnoozeServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSnoozeServiceCallableFactory());
    }

    protected GrpcSnoozeServiceStub(SnoozeServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create(clientContext, callableFactory);
        GrpcCallSettings<CreateSnoozeRequest, Snooze> createSnoozeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSnoozeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings<ListSnoozesRequest, ListSnoozesResponse> listSnoozesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSnoozesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings<GetSnoozeRequest, Snooze> getSnoozeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSnoozeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<UpdateSnoozeRequest, Snooze> updateSnoozeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSnoozeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("snooze.name", String.valueOf(request.getSnooze().getName()));
            return builder.build();
        }).build();
        this.createSnoozeCallable = callableFactory.createUnaryCallable(createSnoozeTransportSettings, settings.createSnoozeSettings(), clientContext);
        this.listSnoozesCallable = callableFactory.createUnaryCallable(listSnoozesTransportSettings, settings.listSnoozesSettings(), clientContext);
        this.listSnoozesPagedCallable = callableFactory.createPagedCallable(listSnoozesTransportSettings, settings.listSnoozesSettings(), clientContext);
        this.getSnoozeCallable = callableFactory.createUnaryCallable(getSnoozeTransportSettings, settings.getSnoozeSettings(), clientContext);
        this.updateSnoozeCallable = callableFactory.createUnaryCallable(updateSnoozeTransportSettings, settings.updateSnoozeSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateSnoozeRequest, Snooze> createSnoozeCallable() {
        return this.createSnoozeCallable;
    }

    @Override
    public UnaryCallable<ListSnoozesRequest, ListSnoozesResponse> listSnoozesCallable() {
        return this.listSnoozesCallable;
    }

    @Override
    public UnaryCallable<ListSnoozesRequest, SnoozeServiceClient.ListSnoozesPagedResponse> listSnoozesPagedCallable() {
        return this.listSnoozesPagedCallable;
    }

    @Override
    public UnaryCallable<GetSnoozeRequest, Snooze> getSnoozeCallable() {
        return this.getSnoozeCallable;
    }

    @Override
    public UnaryCallable<UpdateSnoozeRequest, Snooze> updateSnoozeCallable() {
        return this.updateSnoozeCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    @Override
    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

