/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.api.gax.rpc.ErrorDetails;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.BaseServiceException;
import com.google.cloud.RetryHelper;
import com.google.cloud.http.BaseHttpServiceException;
import com.google.cloud.storage.GrpcToHttpStatusCodeTranslation;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableSet;
import org.apache.pinot.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.checkerframework.checker.nullness.qual.Nullable;

@InternalApi
public final class StorageException
extends BaseHttpServiceException {
    private static final String INTERNAL_ERROR = "internalError";
    private static final String CONNECTION_CLOSED_PREMATURELY = "connectionClosedPrematurely";
    static final Set<BaseServiceException.Error> RETRYABLE_ERRORS = ImmutableSet.of(new BaseServiceException.Error(504, null), new BaseServiceException.Error(503, null), new BaseServiceException.Error(502, null), new BaseServiceException.Error(500, null), new BaseServiceException.Error(429, null), new BaseServiceException.Error(408, null), new BaseServiceException.Error[]{new BaseServiceException.Error(null, "internalError"), new BaseServiceException.Error(null, "connectionClosedPrematurely")});
    private static final long serialVersionUID = 757915549325467990L;
    final ApiException apiExceptionCause;

    public StorageException(int code, String message) {
        this(code, message, null);
    }

    public StorageException(int code, String message, Throwable cause) {
        super(code, message, null, true, RETRYABLE_ERRORS, cause);
        this.apiExceptionCause = StorageException.asApiExceptionOrNull(cause);
    }

    public StorageException(int code, String message, String reason, Throwable cause) {
        super(code, message, reason, true, RETRYABLE_ERRORS, cause);
        this.apiExceptionCause = StorageException.asApiExceptionOrNull(cause);
    }

    public StorageException(IOException exception) {
        super(exception, true, RETRYABLE_ERRORS);
        this.apiExceptionCause = null;
    }

    public StorageException(GoogleJsonError error) {
        super(error, true, RETRYABLE_ERRORS);
        this.apiExceptionCause = null;
    }

    public static StorageException translateAndThrow(RetryHelper.RetryHelperException ex) {
        BaseServiceException.translate(ex);
        throw StorageException.getStorageException(ex);
    }

    private static StorageException getStorageException(Throwable t2) {
        if (t2 instanceof RetryHelper.RetryHelperException) {
            Throwable cause = t2.getCause();
            return new StorageException(0, cause != null ? cause.getMessage() : "", cause);
        }
        return new StorageException(0, t2.getMessage(), t2);
    }

    static BaseServiceException coalesce(Throwable t2) {
        if (t2 instanceof BaseServiceException) {
            return (BaseServiceException)t2;
        }
        if (t2.getCause() instanceof BaseServiceException) {
            return (BaseServiceException)t2.getCause();
        }
        if (t2 instanceof ApiException) {
            return StorageException.asStorageException((ApiException)t2);
        }
        if (t2.getCause() instanceof ApiException) {
            return StorageException.asStorageException((ApiException)t2.getCause());
        }
        return StorageException.getStorageException(t2);
    }

    static <T> ApiFuture<T> coalesceAsync(ApiFuture<T> originalFuture) {
        return ApiFutures.catchingAsync(originalFuture, Throwable.class, throwable -> ApiFutures.immediateFailedFuture(StorageException.coalesce(throwable)), MoreExecutors.directExecutor());
    }

    static StorageException asStorageException(ApiException apiEx) {
        Throwable cause;
        int httpStatusCode = 0;
        StatusCode statusCode = apiEx.getStatusCode();
        if (statusCode instanceof GrpcStatusCode) {
            GrpcStatusCode gsc = (GrpcStatusCode)statusCode;
            httpStatusCode = GrpcToHttpStatusCodeTranslation.grpcCodeToHttpStatusCode(gsc.getTransportCode());
        }
        String message = null;
        if (apiEx.getCause() != null && ((cause = apiEx.getCause()) instanceof StatusRuntimeException || cause instanceof StatusException)) {
            message = cause.getMessage();
        }
        if (message == null && apiEx.getMessage() != null) {
            message = apiEx.getMessage();
        }
        if (message == null) {
            String statusCodeName = statusCode.getCode().name();
            message = "Error: " + statusCodeName;
        }
        StorageException.attachErrorDetails(apiEx);
        return new StorageException(httpStatusCode, message, apiEx.getReason(), apiEx);
    }

    private static void attachErrorDetails(ApiException ae) {
        if (ae != null && ae.getErrorDetails() != null && !StorageException.errorDetailsAttached(ae)) {
            StringBuilder sb = new StringBuilder();
            ErrorDetails ed = ae.getErrorDetails();
            sb.append("ErrorDetails {\n");
            Stream.of(ed.getErrorInfo(), ed.getDebugInfo(), ed.getQuotaFailure(), ed.getPreconditionFailure(), ed.getBadRequest(), ed.getHelp()).filter(Objects::nonNull).forEach(msg -> sb.append("\t\t").append(msg.getClass().getSimpleName()).append(": { ").append(TextFormat.printer().shortDebugString((MessageOrBuilder)msg)).append(" }\n"));
            sb.append("\t}");
            ae.addSuppressed(new ApiExceptionErrorDetailsComment(sb.toString()));
        }
    }

    private static boolean errorDetailsAttached(ApiException ae) {
        Throwable[] suppressed;
        for (Throwable throwable : suppressed = ae.getSuppressed()) {
            if (!(throwable instanceof ApiExceptionErrorDetailsComment)) continue;
            return true;
        }
        return false;
    }

    public static StorageException translate(IOException exception) {
        String message = exception.getMessage();
        if (message != null && (message.contains("Connection closed prematurely") || message.contains("Premature EOF"))) {
            return new StorageException(0, message, CONNECTION_CLOSED_PREMATURELY, exception);
        }
        return new StorageException(exception);
    }

    static <T> T wrapIOException(IOExceptionCallable<T> c) {
        try {
            return c.call();
        }
        catch (IOException e) {
            throw StorageException.coalesce(e);
        }
    }

    static void wrapIOException(IOExceptionRunnable r) {
        try {
            r.run();
        }
        catch (IOException e) {
            throw StorageException.coalesce(e);
        }
    }

    static <T> T wrapFutureGet(ApiFuture<T> f) {
        try {
            return ApiExceptions.callAndTranslateApiException(f);
        }
        catch (Exception e) {
            throw StorageException.coalesce(e);
        }
    }

    private static @Nullable ApiException asApiExceptionOrNull(Throwable cause) {
        if (cause instanceof ApiException) {
            return (ApiException)cause;
        }
        return null;
    }

    static Runnable liftToRunnable(IOExceptionRunnable ioer) {
        return () -> {
            try {
                ioer.run();
            }
            catch (IOException e) {
                throw StorageException.coalesce(e);
            }
        };
    }

    private static final class ApiExceptionErrorDetailsComment
    extends Throwable {
        private ApiExceptionErrorDetailsComment(String message) {
            super(message, null, true, false);
        }
    }

    @FunctionalInterface
    static interface IOExceptionCallable<T> {
        public T call() throws IOException;
    }

    @FunctionalInterface
    static interface IOExceptionRunnable {
        public void run() throws IOException;
    }
}

