/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.contrib.nio.CloudStorageConfiguration;
import java.util.Iterator;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;

public class CloudStorageRetryHandler {
    private int retries;
    private int reopens;
    private long totalWaitTime;
    private final int maxRetries;
    private final int maxReopens;
    private final CloudStorageConfiguration config;

    @Deprecated
    public CloudStorageRetryHandler(int maxRetriesAndReopens) {
        this.maxRetries = maxRetriesAndReopens;
        this.maxReopens = maxRetriesAndReopens;
        this.config = CloudStorageConfiguration.DEFAULT;
    }

    @Deprecated
    public CloudStorageRetryHandler(int maxRetries, int maxReopens) {
        this.maxRetries = maxRetries;
        this.maxReopens = maxReopens;
        this.config = CloudStorageConfiguration.DEFAULT;
    }

    public CloudStorageRetryHandler(CloudStorageConfiguration config) {
        this.maxRetries = config.maxChannelReopens();
        this.maxReopens = config.maxChannelReopens();
        this.config = config;
    }

    public CloudStorageRetryHandler(int maxRetries, int maxReopens, CloudStorageConfiguration config) {
        this.maxRetries = maxRetries;
        this.maxReopens = maxReopens;
        this.config = config;
    }

    public int retries() {
        return this.retries;
    }

    public int reopens() {
        return this.reopens;
    }

    public boolean handleStorageException(StorageException exs) throws StorageException {
        if (this.isRetryable(exs)) {
            this.handleRetryForStorageException(exs);
            return false;
        }
        if (this.isReopenable(exs)) {
            this.handleReopenForStorageException(exs);
            return true;
        }
        throw exs;
    }

    private void handleRetryForStorageException(StorageException exs) throws StorageException {
        ++this.retries;
        if (this.retries > this.maxRetries) {
            throw new StorageException(exs.getCode(), "All " + this.maxRetries + " retries failed. Waited a total of " + this.totalWaitTime + " ms between attempts", exs);
        }
        this.sleepForAttempt(this.retries);
    }

    private void handleReopenForStorageException(StorageException exs) throws StorageException {
        ++this.reopens;
        if (this.reopens > this.maxReopens) {
            throw new StorageException(exs.getCode(), "All " + this.maxReopens + " reopens failed. Waited a total of " + this.totalWaitTime + " ms between attempts", exs);
        }
        this.sleepForAttempt(this.reopens);
    }

    void sleepForAttempt(int attempt) {
        long delay = 1000L * (1L << Math.min(attempt, 7));
        try {
            Thread.sleep(delay);
            this.totalWaitTime += delay;
        }
        catch (InterruptedException iex) {
            Thread.currentThread().interrupt();
        }
    }

    @VisibleForTesting
    boolean isRetryable(StorageException exs) {
        if (exs.isRetryable()) {
            return true;
        }
        Iterator iterator = this.config.retryableHttpCodes().iterator();
        while (iterator.hasNext()) {
            int code = (Integer)iterator.next();
            if (exs.getCode() != code) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    boolean isReopenable(StorageException exs) {
        int maxDepth = 20;
        for (Throwable throwable = exs; throwable != null && maxDepth-- > 0; throwable = throwable.getCause()) {
            for (Class clazz : this.config.reopenableExceptions()) {
                if (!clazz.isInstance(throwable)) continue;
                return true;
            }
            if (throwable.getMessage() == null || !throwable.getMessage().contains("Connection closed prematurely")) continue;
            return true;
        }
        return false;
    }
}

