/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.rls.LbPolicyConfiguration;
import io.grpc.rls.RlsLoadBalancer;
import io.grpc.rls.RlsProtoConverters;
import io.grpc.rls.RlsProtoData;
import java.util.Map;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;

@Internal
public final class RlsLoadBalancerProvider
extends LoadBalancerProvider {
    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 6;
    }

    @Override
    public String getPolicyName() {
        return "rls_experimental";
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new RlsLoadBalancer(helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingConfigPolicy) {
        try {
            RlsProtoData.RouteLookupConfig routeLookupConfig = (RlsProtoData.RouteLookupConfig)new RlsProtoConverters.RouteLookupConfigConverter().convert(JsonUtil.getObject(rawLoadBalancingConfigPolicy, "routeLookupConfig"));
            Map<String, ?> routeLookupChannelServiceConfig = JsonUtil.getObject(rawLoadBalancingConfigPolicy, "routeLookupChannelServiceConfig");
            LbPolicyConfiguration.ChildLoadBalancingPolicy lbPolicy = LbPolicyConfiguration.ChildLoadBalancingPolicy.create(JsonUtil.getString(rawLoadBalancingConfigPolicy, "childPolicyConfigTargetFieldName"), JsonUtil.checkObjectList(Preconditions.checkNotNull(JsonUtil.getList(rawLoadBalancingConfigPolicy, "childPolicy"))));
            return NameResolver.ConfigOrError.fromConfig(new LbPolicyConfiguration(routeLookupConfig, routeLookupChannelServiceConfig, lbPolicy));
        }
        catch (Exception e) {
            return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withDescription("can't parse config: " + e.getMessage()).withCause(e));
        }
    }
}

