/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.protobuf.Message;
import io.grpc.ClientInterceptor;
import io.grpc.ServerInterceptor;
import io.grpc.xds.ConfigOrError;
import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import org.apache.pinot.shaded.com.google.common.base.MoreObjects;

interface Filter
extends Closeable {
    @Nullable
    default public ClientInterceptor buildClientInterceptor(FilterConfig config, @Nullable FilterConfig overrideConfig, ScheduledExecutorService scheduler) {
        return null;
    }

    @Nullable
    default public ServerInterceptor buildServerInterceptor(FilterConfig config, @Nullable FilterConfig overrideConfig) {
        return null;
    }

    @Override
    default public void close() {
    }

    public static final class NamedFilterConfig {
        final String name;
        final FilterConfig filterConfig;

        NamedFilterConfig(String name, FilterConfig filterConfig) {
            this.name = name;
            this.filterConfig = filterConfig;
        }

        String filterStateKey() {
            return this.name + "_" + this.filterConfig.typeUrl();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamedFilterConfig that = (NamedFilterConfig)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.filterConfig, that.filterConfig);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.filterConfig);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("name", this.name).add("filterConfig", this.filterConfig).toString();
        }
    }

    public static interface Provider {
        public String[] typeUrls();

        default public boolean isClientFilter() {
            return false;
        }

        default public boolean isServerFilter() {
            return false;
        }

        public Filter newInstance(String var1);

        public ConfigOrError<? extends FilterConfig> parseFilterConfig(Message var1);

        public ConfigOrError<? extends FilterConfig> parseFilterConfigOverride(Message var1);
    }

    public static interface FilterConfig {
        public String typeUrl();
    }
}

