/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import io.grpc.internal.GrpcUtil;
import io.grpc.xds.FaultFilter;
import io.grpc.xds.Filter;
import io.grpc.xds.GcpAuthenticationFilter;
import io.grpc.xds.RbacFilter;
import io.grpc.xds.RouterFilter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;

final class FilterRegistry {
    private static FilterRegistry instance;
    private final Map<String, Filter.Provider> supportedFilters = new HashMap<String, Filter.Provider>();
    static boolean isEnabledGcpAuthnFilter;

    private FilterRegistry() {
    }

    static synchronized FilterRegistry getDefaultRegistry() {
        if (instance == null) {
            instance = FilterRegistry.newRegistry().register(new FaultFilter.Provider(), new RouterFilter.Provider(), new RbacFilter.Provider());
            if (isEnabledGcpAuthnFilter) {
                instance.register(new GcpAuthenticationFilter.Provider());
            }
        }
        return instance;
    }

    @VisibleForTesting
    static FilterRegistry newRegistry() {
        return new FilterRegistry();
    }

    @VisibleForTesting
    FilterRegistry register(Filter.Provider ... filters) {
        for (Filter.Provider filter : filters) {
            for (String typeUrl : filter.typeUrls()) {
                this.supportedFilters.put(typeUrl, filter);
            }
        }
        return this;
    }

    @Nullable
    Filter.Provider get(String typeUrl) {
        return this.supportedFilters.get(typeUrl);
    }

    static {
        isEnabledGcpAuthnFilter = GrpcUtil.getFlag("GRPC_EXPERIMENTAL_XDS_GCP_AUTHENTICATION_FILTER", false);
    }
}

