/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal;

import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import io.grpc.xds.internal.Matchers;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.HeaderMatcher;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.matcher.v3.StringMatcher;

public final class MatcherParser {
    public static Matchers.HeaderMatcher parseHeaderMatcher(HeaderMatcher proto) {
        switch (proto.getHeaderMatchSpecifierCase()) {
            case EXACT_MATCH: {
                String exactMatch = proto.getExactMatch();
                return Matchers.HeaderMatcher.forExactValue(proto.getName(), exactMatch, proto.getInvertMatch());
            }
            case SAFE_REGEX_MATCH: {
                Pattern safeRegExMatch;
                String rawPattern = proto.getSafeRegexMatch().getRegex();
                try {
                    safeRegExMatch = Pattern.compile(rawPattern);
                }
                catch (PatternSyntaxException e) {
                    throw new IllegalArgumentException("HeaderMatcher [" + proto.getName() + "] contains malformed safe regex pattern: " + e.getMessage());
                }
                return Matchers.HeaderMatcher.forSafeRegEx(proto.getName(), safeRegExMatch, proto.getInvertMatch());
            }
            case RANGE_MATCH: {
                Matchers.HeaderMatcher.Range rangeMatch = Matchers.HeaderMatcher.Range.create(proto.getRangeMatch().getStart(), proto.getRangeMatch().getEnd());
                return Matchers.HeaderMatcher.forRange(proto.getName(), rangeMatch, proto.getInvertMatch());
            }
            case PRESENT_MATCH: {
                return Matchers.HeaderMatcher.forPresent(proto.getName(), proto.getPresentMatch(), proto.getInvertMatch());
            }
            case PREFIX_MATCH: {
                String prefixMatch = proto.getPrefixMatch();
                return Matchers.HeaderMatcher.forPrefix(proto.getName(), prefixMatch, proto.getInvertMatch());
            }
            case SUFFIX_MATCH: {
                String suffixMatch = proto.getSuffixMatch();
                return Matchers.HeaderMatcher.forSuffix(proto.getName(), suffixMatch, proto.getInvertMatch());
            }
            case CONTAINS_MATCH: {
                String containsMatch = proto.getContainsMatch();
                return Matchers.HeaderMatcher.forContains(proto.getName(), containsMatch, proto.getInvertMatch());
            }
            case STRING_MATCH: {
                return Matchers.HeaderMatcher.forString(proto.getName(), MatcherParser.parseStringMatcher(proto.getStringMatch()), proto.getInvertMatch());
            }
        }
        throw new IllegalArgumentException("Unknown header matcher type: " + proto.getHeaderMatchSpecifierCase());
    }

    public static Matchers.StringMatcher parseStringMatcher(StringMatcher proto) {
        switch (proto.getMatchPatternCase()) {
            case EXACT: {
                return Matchers.StringMatcher.forExact(proto.getExact(), proto.getIgnoreCase());
            }
            case PREFIX: {
                return Matchers.StringMatcher.forPrefix(proto.getPrefix(), proto.getIgnoreCase());
            }
            case SUFFIX: {
                return Matchers.StringMatcher.forSuffix(proto.getSuffix(), proto.getIgnoreCase());
            }
            case SAFE_REGEX: {
                return Matchers.StringMatcher.forSafeRegEx(Pattern.compile(proto.getSafeRegex().getRegex()));
            }
            case CONTAINS: {
                return Matchers.StringMatcher.forContains(proto.getContains());
            }
        }
        throw new IllegalArgumentException("Unknown StringMatcher match pattern: " + proto.getMatchPatternCase());
    }
}

