/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.clustered;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.AsyncResult;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Closeable;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Future;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Promise;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.Message;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.VertxInternal;

public class Serializer
implements Closeable {
    private final ContextInternal ctx;
    private final Map<String, SerializerQueue> queues;

    private Serializer(ContextInternal context) {
        ContextInternal unwrapped = context.unwrap();
        if (unwrapped.isEventLoopContext()) {
            this.ctx = unwrapped;
        } else {
            VertxInternal vertx = unwrapped.owner();
            this.ctx = vertx.createEventLoopContext(unwrapped.nettyEventLoop(), unwrapped.workerPool(), unwrapped.classLoader());
        }
        this.queues = new HashMap<String, SerializerQueue>();
        if (unwrapped.isDeployment()) {
            unwrapped.addCloseHook(this);
        }
    }

    public static Serializer get(ContextInternal context) {
        ConcurrentMap<Object, Object> contextData = context.contextData();
        Serializer serializer = (Serializer)contextData.get(Serializer.class);
        if (serializer == null) {
            Serializer candidate = new Serializer(context);
            Serializer previous = (Serializer)contextData.putIfAbsent(Serializer.class, candidate);
            serializer = previous == null ? candidate : previous;
        }
        return serializer;
    }

    public <T> void queue(Message<?> message, BiConsumer<Message<?>, Promise<T>> selectHandler, Promise<T> promise) {
        this.ctx.emit(v -> {
            String address = message.address();
            SerializerQueue queue = this.queues.computeIfAbsent(address, x$0 -> new SerializerQueue((String)x$0));
            queue.add(message, selectHandler, promise);
        });
    }

    @Override
    public void close(Promise<Void> completion) {
        this.ctx.emit(v -> {
            for (SerializerQueue queue : this.queues.values()) {
                queue.close();
            }
            completion.complete();
        });
    }

    private class SerializerQueue {
        private final Queue<SerializedTask<?>> tasks;
        private final String address;
        private boolean running;
        private boolean closed;

        SerializerQueue(String address) {
            this.address = address;
            this.tasks = new LinkedList();
        }

        void checkPending() {
            if (!this.running) {
                block2: {
                    SerializedTask<?> task;
                    this.running = true;
                    while ((task = this.tasks.peek()) != null) {
                        task.process();
                        if (this.tasks.peek() != task) continue;
                        break block2;
                    }
                    Serializer.this.queues.remove(this.address);
                }
                this.running = false;
            }
        }

        <U> void add(Message<?> msg, BiConsumer<Message<?>, Promise<U>> selectHandler, Promise<U> promise) {
            SerializedTask<U> serializedTask = new SerializedTask<U>(Serializer.this.ctx, msg, selectHandler);
            Future fut = serializedTask.internalPromise.future();
            fut.onComplete(promise);
            fut.onComplete(serializedTask);
            this.tasks.add(serializedTask);
            this.checkPending();
        }

        void processed() {
            if (!this.closed) {
                this.tasks.poll();
                this.checkPending();
            }
        }

        void close() {
            this.closed = true;
            while (!this.tasks.isEmpty()) {
                this.tasks.remove().internalPromise.tryFail("Context is closing");
            }
        }

        private class SerializedTask<U>
        implements Handler<AsyncResult<U>> {
            final Message<?> msg;
            final BiConsumer<Message<?>, Promise<U>> selectHandler;
            final Promise<U> internalPromise;

            SerializedTask(ContextInternal context, Message<?> msg, BiConsumer<Message<?>, Promise<U>> selectHandler) {
                this.msg = msg;
                this.selectHandler = selectHandler;
                this.internalPromise = context.promise();
            }

            void process() {
                this.selectHandler.accept(this.msg, this.internalPromise);
            }

            @Override
            public void handle(AsyncResult<U> ar) {
                SerializerQueue.this.processed();
            }
        }
    }
}

