/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="EndpointConditions represents the current condition of an endpoint.")
public class V1EndpointConditions {
    public static final String SERIALIZED_NAME_READY = "ready";
    @SerializedName(value="ready")
    private Boolean ready;
    public static final String SERIALIZED_NAME_SERVING = "serving";
    @SerializedName(value="serving")
    private Boolean serving;
    public static final String SERIALIZED_NAME_TERMINATING = "terminating";
    @SerializedName(value="terminating")
    private Boolean terminating;

    public V1EndpointConditions ready(Boolean ready) {
        this.ready = ready;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ready indicates that this endpoint is prepared to receive traffic, according to whatever system is managing the endpoint. A nil value indicates an unknown state. In most cases consumers should interpret this unknown state as ready. For compatibility reasons, ready should never be \"true\" for terminating endpoints.")
    public Boolean getReady() {
        return this.ready;
    }

    public void setReady(Boolean ready) {
        this.ready = ready;
    }

    public V1EndpointConditions serving(Boolean serving) {
        this.serving = serving;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="serving is identical to ready except that it is set regardless of the terminating state of endpoints. This condition should be set to true for a ready endpoint that is terminating. If nil, consumers should defer to the ready condition. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.")
    public Boolean getServing() {
        return this.serving;
    }

    public void setServing(Boolean serving) {
        this.serving = serving;
    }

    public V1EndpointConditions terminating(Boolean terminating) {
        this.terminating = terminating;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="terminating indicates that this endpoint is terminating. A nil value indicates an unknown state. Consumers should interpret this unknown state to mean that the endpoint is not terminating. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.")
    public Boolean getTerminating() {
        return this.terminating;
    }

    public void setTerminating(Boolean terminating) {
        this.terminating = terminating;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EndpointConditions v1EndpointConditions = (V1EndpointConditions)o;
        return Objects.equals(this.ready, v1EndpointConditions.ready) && Objects.equals(this.serving, v1EndpointConditions.serving) && Objects.equals(this.terminating, v1EndpointConditions.terminating);
    }

    public int hashCode() {
        return Objects.hash(this.ready, this.serving, this.terminating);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1EndpointConditions {\n");
        sb.append("    ready: ").append(this.toIndentedString(this.ready)).append("\n");
        sb.append("    serving: ").append(this.toIndentedString(this.serving)).append("\n");
        sb.append("    terminating: ").append(this.toIndentedString(this.terminating)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

