/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RescheduleReadHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RescheduleReadHandler.class);
    private static final int UNSET = -1;
    private static final int NO_PENDING_READ = 0;
    private final AtomicLong maxReadOpCounter = new AtomicLong(-1L);
    private final LongSupplier readIntervalMsSupplier;
    private final ScheduledExecutorService executor;
    private final Runnable cancelPendingRead;
    private final Runnable rescheduleReadImmediately;
    private final BooleanSupplier hasPendingReadRequestThatMightWait;
    private final LongSupplier readOpCounterSupplier;
    private final BooleanSupplier hasEntriesInReplayQueue;

    RescheduleReadHandler(LongSupplier readIntervalMsSupplier, ScheduledExecutorService executor, Runnable cancelPendingRead, Runnable rescheduleReadImmediately, BooleanSupplier hasPendingReadRequestThatMightWait, LongSupplier readOpCounterSupplier, BooleanSupplier hasEntriesInReplayQueue) {
        this.readIntervalMsSupplier = readIntervalMsSupplier;
        this.executor = executor;
        this.cancelPendingRead = cancelPendingRead;
        this.rescheduleReadImmediately = rescheduleReadImmediately;
        this.hasPendingReadRequestThatMightWait = hasPendingReadRequestThatMightWait;
        this.readOpCounterSupplier = readOpCounterSupplier;
        this.hasEntriesInReplayQueue = hasEntriesInReplayQueue;
    }

    public void rescheduleRead() {
        long readOpCountWhenPendingRead;
        long l = readOpCountWhenPendingRead = this.hasPendingReadRequestThatMightWait.getAsBoolean() ? this.readOpCounterSupplier.getAsLong() : 0L;
        if (this.maxReadOpCounter.compareAndSet(-1L, readOpCountWhenPendingRead)) {
            Runnable runnable = () -> {
                long maxReadOpCount = this.maxReadOpCounter.getAndSet(-1L);
                if (maxReadOpCount != 0L && this.readOpCounterSupplier.getAsLong() == maxReadOpCount && this.hasEntriesInReplayQueue.getAsBoolean()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Cancelling pending read request because it's waiting for more entries");
                    }
                    this.cancelPendingRead.run();
                }
                if (log.isDebugEnabled()) {
                    log.debug("Triggering read");
                }
                this.rescheduleReadImmediately.run();
            };
            long rescheduleDelay = this.readIntervalMsSupplier.getAsLong();
            if (rescheduleDelay > 0L) {
                if (log.isDebugEnabled()) {
                    log.debug("Scheduling after {} ms", (Object)rescheduleDelay);
                }
                this.executor.schedule(runnable, rescheduleDelay, TimeUnit.MILLISECONDS);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Running immediately");
                }
                runnable.run();
            }
        } else {
            long updatedValue = this.maxReadOpCounter.updateAndGet(current -> current == -1L ? -1L : (readOpCountWhenPendingRead == 0L ? 0L : Math.max(current, readOpCountWhenPendingRead)));
            if (updatedValue == -1L) {
                this.rescheduleRead();
            }
        }
    }
}

