/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.net.SocketAddress;
import java.security.cert.Certificate;
import lombok.Generated;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationDataSubscription
implements AuthenticationDataSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticationDataSubscription.class);
    private final AuthenticationDataSource authData;
    private final String subscription;

    public AuthenticationDataSubscription(AuthenticationDataSource authData, String subscription) {
        this.authData = authData;
        this.subscription = subscription;
    }

    @Override
    public boolean hasDataFromCommand() {
        return this.hasAuthData() && this.authData.hasDataFromCommand();
    }

    @Override
    public String getCommandData() {
        return this.hasAuthData() ? this.authData.getCommandData() : null;
    }

    @Override
    public boolean hasDataFromPeer() {
        return this.hasAuthData() && this.authData.hasDataFromPeer();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.hasAuthData() ? this.authData.getPeerAddress() : null;
    }

    @Override
    public boolean hasDataFromTls() {
        return this.hasAuthData() && this.authData.hasDataFromTls();
    }

    @Override
    public Certificate[] getTlsCertificates() {
        return this.hasAuthData() ? this.authData.getTlsCertificates() : null;
    }

    @Override
    public boolean hasSubscription() {
        return this.subscription != null;
    }

    @Override
    public String getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean hasDataFromHttp() {
        return this.hasAuthData() && this.authData.hasDataFromHttp();
    }

    @Override
    public String getHttpAuthType() {
        return this.hasAuthData() ? this.authData.getHttpAuthType() : null;
    }

    @Override
    public String getHttpHeader(String name) {
        return this.hasAuthData() ? this.authData.getHttpHeader(name) : null;
    }

    public AuthenticationDataSource getAuthData() {
        return this.authData;
    }

    private boolean hasAuthData() {
        return this.authData != null;
    }
}

