/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.pulsar.broker.admin.impl.ResourceGroupsBase;
import org.apache.pulsar.common.policies.data.ResourceGroup;

@Path(value="/resourcegroups")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/resourcegroups", description="ResourceGroups admin apis", tags={"resourcegroups"})
public class ResourceGroups
extends ResourceGroupsBase {
    @GET
    @ApiOperation(value="Get the list of all the resourcegroups.", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public List<String> getResourceGroups() {
        return this.internalGetResourceGroups();
    }

    @GET
    @Path(value="/{resourcegroup}")
    @ApiOperation(value="Get the rate limiters specified for a resourcegroup.", response=ResourceGroup.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="ResourceGroup doesn't exist")})
    public ResourceGroup getResourceGroup(@PathParam(value="resourcegroup") String resourcegroup) {
        return this.internalGetResourceGroup(resourcegroup);
    }

    @PUT
    @Path(value="/{resourcegroup}")
    @ApiOperation(value="Creates a new resourcegroup with the specified rate limiters")
    @ApiResponses(value={@ApiResponse(code=204, message="Operation successful"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="cluster doesn't exist")})
    public void createOrUpdateResourceGroup(@PathParam(value="resourcegroup") String name, @ApiParam(value="Rate limiters for the resourcegroup") ResourceGroup resourcegroup) {
        this.internalCreateOrUpdateResourceGroup(name, resourcegroup);
    }

    @DELETE
    @Path(value="/{resourcegroup}")
    @ApiOperation(value="Delete a resourcegroup.")
    @ApiResponses(value={@ApiResponse(code=204, message="Operation successful"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="ResourceGroup doesn't exist"), @ApiResponse(code=409, message="ResourceGroup is in use")})
    public void deleteResourceGroup(@PathParam(value="resourcegroup") String resourcegroup) {
        this.internalDeleteResourceGroup(resourcegroup);
    }
}

