/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.ConsumerHashAssignmentsSnapshot;
import org.apache.pulsar.broker.service.ImpactedConsumersResult;
import org.apache.pulsar.broker.service.StickyKeyConsumerSelectorUtils;
import org.apache.pulsar.client.api.Range;

public interface StickyKeyConsumerSelector {
    public static final int DEFAULT_RANGE_SIZE = 65536;
    public static final int STICKY_KEY_HASH_NOT_SET = 0;

    public CompletableFuture<Optional<ImpactedConsumersResult>> addConsumer(Consumer var1);

    public Optional<ImpactedConsumersResult> removeConsumer(Consumer var1);

    default public Consumer select(byte[] stickyKey) {
        return this.select(this.makeStickyKeyHash(stickyKey));
    }

    default public int makeStickyKeyHash(byte[] stickyKey) {
        return StickyKeyConsumerSelectorUtils.makeStickyKeyHash(stickyKey, this.getKeyHashRange());
    }

    public Consumer select(int var1);

    public Range getKeyHashRange();

    default public Map<Consumer, List<Range>> getConsumerKeyHashRanges() {
        return this.getConsumerHashAssignmentsSnapshot().getRangesByConsumer();
    }

    public ConsumerHashAssignmentsSnapshot getConsumerHashAssignmentsSnapshot();
}

