/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.TransactionMetadataStoreService;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStore;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStoreAttributes;
import org.apache.pulsar.transaction.coordinator.impl.TransactionMetadataStoreStats;

public class OpenTelemetryTransactionCoordinatorStats
implements AutoCloseable {
    public static final String TRANSACTION_COUNTER = "pulsar.broker.transaction.coordinator.transaction.count";
    private final ObservableLongMeasurement transactionCounter;
    public static final String APPEND_LOG_COUNTER = "pulsar.broker.transaction.coordinator.append.log.count";
    private final ObservableLongMeasurement appendLogCounter;
    private final BatchCallback batchCallback;

    public OpenTelemetryTransactionCoordinatorStats(PulsarService pulsar) {
        Meter meter = pulsar.getOpenTelemetry().getMeter();
        this.transactionCounter = meter.upDownCounterBuilder(TRANSACTION_COUNTER).setUnit("{transaction}").setDescription("The number of transactions handled by the coordinator.").buildObserver();
        this.appendLogCounter = meter.counterBuilder(APPEND_LOG_COUNTER).setUnit("{entry}").setDescription("The number of transaction metadata entries appended by the coordinator.").buildObserver();
        this.batchCallback = meter.batchCallback(() -> {
            TransactionMetadataStoreService transactionMetadataStoreService = pulsar.getTransactionMetadataStoreService();
            if (transactionMetadataStoreService != null) {
                transactionMetadataStoreService.getStores().values().forEach(this::recordMetricsForTransactionMetadataStore);
            }
        }, (ObservableMeasurement)this.transactionCounter, new ObservableMeasurement[]{this.appendLogCounter});
    }

    @Override
    public void close() {
        this.batchCallback.close();
    }

    private void recordMetricsForTransactionMetadataStore(TransactionMetadataStore transactionMetadataStore) {
        TransactionMetadataStoreAttributes attributes = transactionMetadataStore.getAttributes();
        TransactionMetadataStoreStats stats = transactionMetadataStore.getMetadataStoreStats();
        this.transactionCounter.record(stats.getAbortedCount(), attributes.getTxnAbortedAttributes());
        this.transactionCounter.record((long)stats.getActives(), attributes.getTxnActiveAttributes());
        this.transactionCounter.record(stats.getCommittedCount(), attributes.getTxnCommittedAttributes());
        this.transactionCounter.record(stats.getCreatedCount(), attributes.getTxnCreatedAttributes());
        this.transactionCounter.record(stats.getTimeoutCount(), attributes.getTxnTimeoutAttributes());
        this.appendLogCounter.record(stats.getAppendLogCount(), attributes.getCommonAttributes());
    }
}

