# PIP-205: Reactive Java client for Apache Pulsar

Status: Delivered - https://github.com/apache/pulsar-client-reactive
Mailing list thread: https://lists.apache.org/thread/9n961zvr5y4g77n7pfsptg796r2obfo1

### Motivation

There's a need to "go reactive from end-to-end" when building modern reactive applications with platforms such as Spring Reactive. \
There are ways to adapt the Apache Pulsar Java client async API calls to Reactive Streams with a few lines of code. \
However, a lot will be missing and achieving the complete solution will require much more effort.

A better solution would be to have first-class support Reactive Streams in Apache Pulsar.

[Reactive Streams](https://www.reactive-streams.org/) is an interoperability specification and there are multiple implementations for the JVM. \
It's not about a single programming language.\
For example, a Reactive client for Apache Pulsar supporting Reactive Streams can be used together with Project Reactor / Spring Reactive, Akka Streams, RxJava 3, Vert.x, SmallRye Mutiny (RedHat/Quarkus) and others.

### Goal

Provide Reactive Java client for Apache Pulsar

The Reactive Java client for Apache Pulsar exposes a Reactive Streams compatible Reactive client API for Apache Pulsar.\
Reactive programming is about non-blocking applications that are asynchronous and event-driven and require a small number of threads to scale. The Reactive Java client for Apache Pulsar supports non-blocking reactive asynchronous back pressure for producing and consuming messages so that the producing or consuming pipeline doesn't get overwhelmed by producing or consuming.\
Libraries that support Reactive Streams provide a programming model that is efficient and optimal for message producing and consuming (processing) use cases.

### API Changes

Establish a Reactive Streams compatible client API for Apache Pulsar.\
This client will be published in Maven central as a library.

### Implementation

There's an existing proof-of-concept available at https://github.com/datastax/reactive-pulsar .\
This implementation will be used as a reference for an entirely new implementation that is started as a new repository under the Apache Pulsar project.

The proposal for the repository location is https://github.com/apache/pulsar-client-reactive .
The Maven central group Id is "org.apache.pulsar" and the main artifact id is "pulsar-client-reactive".
The root package name is "org.apache.pulsar.reactive.client".

The implementation will provide an interface module that abstracts the Reactive client API.\
This interface is implemented by wrapping the current Apache Pulsar Java client and adapts the existing async Java API to the the Reactive client API.
The reason for this particular detail is that it is possible to provide a native Reactive client later while having the possibility to start developing applications immediately using the Reactive client API. Applications depending on the API will be able to migrate to use the native Reactive client with minor or no changes when it becomes available.

### Anything else?

By having an official Reactive Java client for Apache Pulsar, it will provide a way to contribute and improve the official client.
Other opensource projects might want to provide support for using Apache Pulsar within reactive application frameworks. Without an official reactive client, this becomes hard, since open source projects would like to use stable client dependencies instead of a hobby project provided by an individual.
There are several members within the existing Apache Pulsar contributors and committers that have expressed the desire to contribute to a Reactive client for Apache Pulsar and are willing to maintain the new repository. With the new repository and sub-project we will most likely see new active contributors and could possibly appoint new Apache Pulsar committers to the project to empower the developers working on this new sub-project.
