/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.LongUnaryOperator;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.StringUtils;

public class RaftLogIndex {
    private final Object name;
    private final AtomicLong index;

    public RaftLogIndex(Object name, long initialValue) {
        this.name = name;
        this.index = new AtomicLong(initialValue);
    }

    public long get() {
        return this.index.get();
    }

    public boolean setUnconditionally(long newIndex, Consumer<Object> log) {
        boolean updated;
        long old = this.index.getAndSet(newIndex);
        boolean bl = updated = old != newIndex;
        if (updated) {
            log.accept(StringUtils.stringSupplierAsObject(() -> this.name + ": setUnconditionally " + old + " -> " + newIndex));
        }
        return updated;
    }

    public boolean updateUnconditionally(LongUnaryOperator update, Consumer<Object> log) {
        long newIndex;
        boolean updated;
        long old = this.index.getAndUpdate(update);
        boolean bl = updated = old != (newIndex = update.applyAsLong(old));
        if (updated) {
            log.accept(StringUtils.stringSupplierAsObject(() -> this.name + ": updateUnconditionally " + old + " -> " + newIndex));
        }
        return updated;
    }

    public boolean updateIncreasingly(long newIndex, Consumer<Object> log) {
        boolean updated;
        long old = this.index.getAndSet(newIndex);
        Preconditions.assertTrue(old <= newIndex, () -> "Failed to updateIncreasingly for " + this.name + ": " + old + " -> " + newIndex);
        boolean bl = updated = old != newIndex;
        if (updated) {
            log.accept(StringUtils.stringSupplierAsObject(() -> this.name + ": updateIncreasingly " + old + " -> " + newIndex));
        }
        return updated;
    }

    public boolean updateToMax(long newIndex, Consumer<Object> log) {
        boolean updated;
        long old = this.index.getAndUpdate(oldIndex -> Math.max(oldIndex, newIndex));
        boolean bl = updated = old < newIndex;
        if (updated) {
            log.accept(StringUtils.stringSupplierAsObject(() -> this.name + ": updateToMax old=" + old + ", new=" + newIndex + ", updated? " + updated));
        }
        return updated;
    }

    public long incrementAndGet(Consumer<Object> log) {
        long newIndex = this.index.incrementAndGet();
        log.accept(StringUtils.stringSupplierAsObject(() -> this.name + ": incrementAndGet " + (newIndex - 1L) + " -> " + newIndex));
        return newIndex;
    }

    public String toString() {
        return this.name + ":" + this.index;
    }
}

