/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc;

import com.alipay.remoting.RemotingAddressParser;
import com.alipay.remoting.Url;
import com.alipay.remoting.util.StringUtils;
import java.lang.ref.SoftReference;
import java.util.Properties;

public class RpcAddressParser
implements RemotingAddressParser {
    @Override
    public Url parse(String url) {
        int i;
        if (StringUtils.isBlank(url)) {
            throw new IllegalArgumentException("Illegal format address string [" + url + "], should not be blank! ");
        }
        Url parsedUrl = this.tryGet(url);
        if (null != parsedUrl) {
            return parsedUrl;
        }
        String ip = null;
        String port = null;
        Properties properties = null;
        int size = url.length();
        int pos = 0;
        for (i = 0; i < size; ++i) {
            if (':' == url.charAt(i)) {
                ip = url.substring(pos, i);
                pos = i;
                if (i != size - 1) break;
                throw new IllegalArgumentException("Illegal format address string [" + url + "], should not end with COLON[:]! ");
            }
            if (i != size - 1) continue;
            throw new IllegalArgumentException("Illegal format address string [" + url + "], must have one COLON[:]! ");
        }
        for (i = pos; i < size; ++i) {
            if ('?' == url.charAt(i)) {
                port = url.substring(pos + 1, i);
                pos = i;
                if (i != size - 1) break;
                throw new IllegalArgumentException("Illegal format address string [" + url + "], should not end with QUES[?]! ");
            }
            if (i != size - 1) continue;
            port = url.substring(pos + 1, i + 1);
            pos = size;
        }
        if (pos < size - 1) {
            properties = new Properties();
            while (pos < size - 1) {
                int i2;
                String key = null;
                String value = null;
                for (i2 = pos; i2 < size; ++i2) {
                    if ('=' == url.charAt(i2)) {
                        key = url.substring(pos + 1, i2);
                        pos = i2;
                        if (i2 != size - 1) break;
                        throw new IllegalArgumentException("Illegal format address string [" + url + "], should not end with EQUAL[=]! ");
                    }
                    if (i2 != size - 1) continue;
                    throw new IllegalArgumentException("Illegal format address string [" + url + "], must have one EQUAL[=]! ");
                }
                for (i2 = pos; i2 < size; ++i2) {
                    if ('&' == url.charAt(i2)) {
                        value = url.substring(pos + 1, i2);
                        pos = i2;
                        if (i2 != size - 1) break;
                        throw new IllegalArgumentException("Illegal format address string [" + url + "], should not end with AND[&]! ");
                    }
                    if (i2 != size - 1) continue;
                    value = url.substring(pos + 1, i2 + 1);
                    pos = size;
                }
                properties.put(key, value);
            }
        }
        parsedUrl = new Url(url, ip, Integer.parseInt(port), properties);
        this.initUrlArgs(parsedUrl);
        Url.parsedUrls.put(url, new SoftReference<Url>(parsedUrl));
        return parsedUrl;
    }

    @Override
    public String parseUniqueKey(String url) {
        boolean illegal = false;
        if (StringUtils.isBlank(url)) {
            illegal = true;
        }
        String uniqueKey = "";
        String addr = url.trim();
        String[] sectors = StringUtils.split(addr, '?');
        if (!illegal && sectors.length == 2 && StringUtils.isNotBlank(sectors[0])) {
            uniqueKey = sectors[0].trim();
        } else {
            illegal = true;
        }
        if (illegal) {
            throw new IllegalArgumentException("Illegal format address string: " + url);
        }
        return uniqueKey;
    }

    @Override
    public String parseProperty(String addr, String propKey) {
        if (addr.contains("?") && !addr.endsWith("?")) {
            String part = addr.split("\\?")[1];
            for (String item : part.split("&")) {
                String[] kv = item.split("=");
                String k = kv[0];
                if (!k.equals(propKey)) continue;
                return kv[1];
            }
        }
        return null;
    }

    @Override
    public void initUrlArgs(Url url) {
        String connTimeoutStr = url.getProperty("_CONNECTTIMEOUT");
        int connTimeout = 1000;
        if (StringUtils.isNotBlank(connTimeoutStr)) {
            if (StringUtils.isNumeric(connTimeoutStr)) {
                connTimeout = Integer.parseInt(connTimeoutStr);
            } else {
                throw new IllegalArgumentException("Url args illegal value of key [_CONNECTTIMEOUT] must be positive integer! The origin url is [" + url.getOriginUrl() + "]");
            }
        }
        url.setConnectTimeout(connTimeout);
        String protocolStr = url.getProperty("_PROTOCOL");
        byte protocol = 1;
        if (StringUtils.isNotBlank(protocolStr)) {
            if (StringUtils.isNumeric(protocolStr)) {
                protocol = Byte.parseByte(protocolStr);
            } else {
                throw new IllegalArgumentException("Url args illegal value of key [_PROTOCOL] must be positive integer! The origin url is [" + url.getOriginUrl() + "]");
            }
        }
        url.setProtocol(protocol);
        String versionStr = url.getProperty("_VERSION");
        byte version = 1;
        if (StringUtils.isNotBlank(versionStr)) {
            if (StringUtils.isNumeric(versionStr)) {
                version = Byte.parseByte(versionStr);
            } else {
                throw new IllegalArgumentException("Url args illegal value of key [_VERSION] must be positive integer! The origin url is [" + url.getOriginUrl() + "]");
            }
        }
        url.setVersion(version);
        String connNumStr = url.getProperty("_CONNECTIONNUM");
        int connNum = 1;
        if (StringUtils.isNotBlank(connNumStr)) {
            if (StringUtils.isNumeric(connNumStr)) {
                connNum = Integer.parseInt(connNumStr);
            } else {
                throw new IllegalArgumentException("Url args illegal value of key [_CONNECTIONNUM] must be positive integer! The origin url is [" + url.getOriginUrl() + "]");
            }
        }
        url.setConnNum(connNum);
        String connWarmupStr = url.getProperty("_CONNECTIONWARMUP");
        boolean connWarmup = false;
        if (StringUtils.isNotBlank(connWarmupStr)) {
            connWarmup = Boolean.parseBoolean(connWarmupStr);
        }
        url.setConnWarmup(connWarmup);
    }

    private Url tryGet(String url) {
        SoftReference<Url> softRef = Url.parsedUrls.get(url);
        return null == softRef ? null : softRef.get();
    }
}

