/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.timer;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class TimerMetrics
extends ConfigManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final long LOCK_TIMEOUT_MILLIS = 3000L;
    private final transient Lock lock = new ReentrantLock();
    private final ConcurrentMap<String, Metric> timingCount = new ConcurrentHashMap<String, Metric>(1024);
    private final ConcurrentMap<Integer, Metric> timingDistribution = new ConcurrentHashMap<Integer, Metric>(1024);
    public List<Integer> timerDist = new ArrayList<Integer>(){
        {
            this.add(5);
            this.add(60);
            this.add(300);
            this.add(900);
            this.add(3600);
            this.add(14400);
            this.add(28800);
            this.add(86400);
        }
    };
    private final DataVersion dataVersion = new DataVersion();
    private final String configPath;

    public TimerMetrics(String configPath) {
        this.configPath = configPath;
    }

    public long updateDistPair(int period, int value) {
        Metric distPair = this.getDistPair(period);
        return distPair.getCount().addAndGet(value);
    }

    public long addAndGet(MessageExt msg, int value) {
        String topic = msg.getProperty("REAL_TOPIC");
        Metric pair = this.getTopicPair(topic);
        this.getDataVersion().nextVersion();
        pair.setTimeStamp(System.currentTimeMillis());
        return pair.getCount().addAndGet(value);
    }

    public Metric getDistPair(Integer period) {
        Metric pair = (Metric)this.timingDistribution.get(period);
        if (null != pair) {
            return pair;
        }
        pair = new Metric();
        Metric previous = this.timingDistribution.putIfAbsent(period, pair);
        if (null != previous) {
            return previous;
        }
        return pair;
    }

    public Metric getTopicPair(String topic) {
        Metric pair = (Metric)this.timingCount.get(topic);
        if (null != pair) {
            return pair;
        }
        pair = new Metric();
        Metric previous = this.timingCount.putIfAbsent(topic, pair);
        if (null != previous) {
            return previous;
        }
        return pair;
    }

    public List<Integer> getTimerDistList() {
        return this.timerDist;
    }

    public void setTimerDistList(List<Integer> timerDist) {
        this.timerDist = timerDist;
    }

    public long getTimingCount(String topic) {
        Metric pair = (Metric)this.timingCount.get(topic);
        if (null == pair) {
            return 0L;
        }
        return pair.getCount().get();
    }

    public Map<String, Metric> getTimingCount() {
        return this.timingCount;
    }

    protected void write0(Writer writer) throws IOException {
        TimerMetricsSerializeWrapper wrapper = new TimerMetricsSerializeWrapper();
        wrapper.setTimingCount(this.timingCount);
        wrapper.setDataVersion(this.dataVersion);
        writer.write(JSON.toJSONString((Object)((Object)wrapper), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.BrowserCompatible}));
    }

    public String encode() {
        return this.encode(false);
    }

    public String configFilePath() {
        return this.configPath;
    }

    public void decode(String jsonString) {
        TimerMetricsSerializeWrapper timerMetricsSerializeWrapper;
        if (jsonString != null && (timerMetricsSerializeWrapper = (TimerMetricsSerializeWrapper)((Object)TimerMetricsSerializeWrapper.fromJson((String)jsonString, TimerMetricsSerializeWrapper.class))) != null) {
            this.timingCount.putAll(timerMetricsSerializeWrapper.getTimingCount());
            this.dataVersion.assignNewOne(timerMetricsSerializeWrapper.getDataVersion());
        }
    }

    public String encode(boolean prettyFormat) {
        TimerMetricsSerializeWrapper metricsSerializeWrapper = new TimerMetricsSerializeWrapper();
        metricsSerializeWrapper.setDataVersion(this.dataVersion);
        metricsSerializeWrapper.setTimingCount(this.timingCount);
        return metricsSerializeWrapper.toJson(prettyFormat);
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public void cleanMetrics(Set<String> topics) {
        if (topics == null || topics.isEmpty()) {
            return;
        }
        Iterator iterator = this.timingCount.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String topic = (String)entry.getKey();
            if (topic.startsWith("rmq_sys_") || topic.startsWith("%LMQ%") || topics.contains(topic)) continue;
            iterator.remove();
            log.info("clean timer metrics, because not in topic config, {}", (Object)topic);
        }
    }

    public boolean removeTimingCount(String topic) {
        try {
            this.timingCount.remove(topic);
        }
        catch (Exception e) {
            log.error("removeTimingCount error", (Throwable)e);
            return false;
        }
        return true;
    }

    public synchronized void persist() {
        try {
            File dir;
            String config = this.configFilePath();
            String backup = config + ".bak";
            File configFile = new File(config);
            File bakFile = new File(backup);
            if (configFile.exists()) {
                Files.move(configFile.toPath(), bakFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
                MixAll.fsyncDirectory((Path)Paths.get(bakFile.getParent(), new String[0]));
            }
            if (!(dir = new File(configFile.getParent())).exists()) {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            }
            StringWriter stringWriter = new StringWriter();
            this.write0(stringWriter);
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(config, "rw");){
                randomAccessFile.write(stringWriter.toString().getBytes(StandardCharsets.UTF_8));
                randomAccessFile.getChannel().force(true);
                MixAll.fsyncDirectory((Path)Paths.get(configFile.getParent(), new String[0]));
            }
        }
        catch (Throwable t) {
            log.error("Failed to persist", t);
        }
    }

    public static class Metric {
        private AtomicLong count = new AtomicLong(0L);
        private long timeStamp = System.currentTimeMillis();

        public AtomicLong getCount() {
            return this.count;
        }

        public void setCount(AtomicLong count) {
            this.count = count;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public String toString() {
            return String.format("[%d,%d]", this.count.get(), this.timeStamp);
        }
    }

    public static class TimerMetricsSerializeWrapper
    extends RemotingSerializable {
        private ConcurrentMap<String, Metric> timingCount = new ConcurrentHashMap<String, Metric>(1024);
        private DataVersion dataVersion = new DataVersion();

        public ConcurrentMap<String, Metric> getTimingCount() {
            return this.timingCount;
        }

        public void setTimingCount(ConcurrentMap<String, Metric> timingCount) {
            this.timingCount = timingCount;
        }

        public DataVersion getDataVersion() {
            return this.dataVersion;
        }

        public void setDataVersion(DataVersion dataVersion) {
            this.dataVersion = dataVersion;
        }
    }
}

