/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sedona.common.S2Geography.ShapeIndexGeography;
import org.apache.sedona.shaded.s2.S1ChordAngle;
import org.apache.sedona.shaded.s2.S2BestEdgesQueryBase;
import org.apache.sedona.shaded.s2.S2ClosestEdgeQuery;
import org.apache.sedona.shaded.s2.S2Edge;
import org.apache.sedona.shaded.s2.S2EdgeUtil;
import org.apache.sedona.shaded.s2.S2FurthestEdgeQuery;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Shape;
import org.apache.sedona.shaded.s2.S2ShapeIndex;

public class Distance {
    public double S2_distance(ShapeIndexGeography geo1, ShapeIndexGeography geo2) {
        S2ClosestEdgeQuery.ShapeIndexTarget<S1ChordAngle> queryTarget;
        S2ShapeIndex index1 = geo1.shapeIndex;
        S2ShapeIndex index2 = geo2.shapeIndex;
        S2ClosestEdgeQuery.Query query = S2ClosestEdgeQuery.builder().build(index1);
        Optional<S2BestEdgesQueryBase.Result<S1ChordAngle>> resultVisitor = query.findClosestEdge(queryTarget = S2ClosestEdgeQuery.createShapeIndexTarget(index2));
        if (!resultVisitor.isPresent()) {
            return Double.POSITIVE_INFINITY;
        }
        S2BestEdgesQueryBase.Result<S1ChordAngle> result = resultVisitor.get();
        S1ChordAngle chordAngle = result.distance();
        return chordAngle.toAngle().radians();
    }

    public double S2_maxDistance(ShapeIndexGeography geo1, ShapeIndexGeography geo2) {
        S2FurthestEdgeQuery.ShapeIndexTarget<S1ChordAngle> queryTarget;
        S2ShapeIndex index1 = geo1.shapeIndex;
        S2ShapeIndex index2 = geo2.shapeIndex;
        S2FurthestEdgeQuery.Query query = S2FurthestEdgeQuery.builder().build(index1);
        Optional<S2BestEdgesQueryBase.Result<S1ChordAngle>> resultVisitor = query.findFurthestEdge(queryTarget = S2FurthestEdgeQuery.createShapeIndexTarget(index2));
        if (!resultVisitor.isPresent()) {
            return Double.POSITIVE_INFINITY;
        }
        S2BestEdgesQueryBase.Result<S1ChordAngle> result = resultVisitor.get();
        S1ChordAngle chordAngle = result.distance();
        return chordAngle.toAngle().radians();
    }

    public S2Point S2_closestPoint(ShapeIndexGeography geo1, ShapeIndexGeography geo2) throws Exception {
        return this.S2_minimumClearanceLineBetween(geo1, geo2).getLeft();
    }

    public Pair<S2Point, S2Point> S2_minimumClearanceLineBetween(ShapeIndexGeography geo1, ShapeIndexGeography geo2) throws Exception {
        S2ClosestEdgeQuery.ShapeIndexTarget<S1ChordAngle> queryTarget;
        S2ShapeIndex index1 = geo1.shapeIndex;
        S2ShapeIndex index2 = geo2.shapeIndex;
        S2ClosestEdgeQuery.Query query = S2ClosestEdgeQuery.builder().setIncludeInteriors(false).build(index1);
        Optional<S2BestEdgesQueryBase.Result<S1ChordAngle>> resultVisitor = query.findClosestEdge(queryTarget = S2ClosestEdgeQuery.createShapeIndexTarget(index2));
        if (!resultVisitor.isPresent() || resultVisitor.get().edgeId() == -1) {
            return Pair.of(new S2Point(0.0, 0.0, 0.0), new S2Point(0.0, 0.0, 0.0));
        }
        S2BestEdgesQueryBase.Result<S1ChordAngle> edge = resultVisitor.get();
        int shapeId = edge.shapeId();
        int edgeNum = edge.edgeId();
        S2Shape.MutableEdge mutableEdge = new S2Shape.MutableEdge();
        index1.getShapes().get(shapeId).getEdge(edgeNum, mutableEdge);
        S2Edge s2edge = new S2Edge(mutableEdge.getStart(), mutableEdge.getEnd());
        S2ClosestEdgeQuery.Query queryReverse = S2ClosestEdgeQuery.builder().setIncludeInteriors(false).build(index2);
        S2ClosestEdgeQuery.EdgeTarget queryTargetReverse = new S2ClosestEdgeQuery.EdgeTarget(s2edge.getStart(), s2edge.getEnd());
        Optional resultVisitorReverse = queryReverse.findClosestEdge(queryTargetReverse);
        if (resultVisitorReverse.get().isInterior()) {
            throw new Exception("S2ClosestEdgeQuery result is interior!");
        }
        S2BestEdgesQueryBase.Result edge2 = resultVisitorReverse.get();
        int shapeId2 = edge2.shapeId();
        int edgeNum2 = edge2.edgeId();
        S2Shape.MutableEdge mutableEdge2 = new S2Shape.MutableEdge();
        index2.getShapes().get(shapeId2).getEdge(edgeNum2, mutableEdge2);
        S2Edge s2edge2 = new S2Edge(mutableEdge2.getStart(), mutableEdge2.getEnd());
        S2Edge s2edgeReverse = new S2Edge(s2edge2.getStart(), s2edge2.getEnd());
        return Distance.getEdgePairClosestPoints(s2edge.getStart(), s2edge.getEnd(), s2edgeReverse.getStart(), s2edgeReverse.getEnd());
    }

    public static Pair<S2Point, S2Point> getEdgePairClosestPoints(S2Point a0, S2Point a1, S2Point b0, S2Point b1) {
        S2Shape.MutableEdge resultEdge = new S2Shape.MutableEdge();
        S2EdgeUtil.getEdgePairClosestPoints(a0, a1, b0, b1, resultEdge);
        return Pair.of(resultEdge.getStart(), resultEdge.getEnd());
    }
}

