/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.geopackage.transform;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.sedona.sql.datasources.geopackage.errors.GeopackageException;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKBReader;
import scala.Array$;
import scala.Tuple3;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GeometryReader$ {
    public static GeometryReader$ MODULE$;

    static {
        new GeometryReader$();
    }

    public byte[] extractWKB(byte[] gpkgGeom) {
        ByteBuffer reader = ByteBuffer.wrap(gpkgGeom);
        byte[] magic = new byte[2];
        reader.get(magic);
        if (magic[0] != 71 || magic[1] != 80) {
            throw new GeopackageException("Invalid GeoPackage geometry magic number");
        }
        byte[] versionByte = (byte[])Array$.MODULE$.ofDim(1, ClassTag$.MODULE$.Byte());
        reader.get(versionByte);
        byte[] flagsByte = (byte[])Array$.MODULE$.ofDim(1, ClassTag$.MODULE$.Byte());
        reader.get(flagsByte);
        Tuple3<Object, ByteOrder, Object> resolvedFlags = this.readFlags(flagsByte[0]);
        reader.order((ByteOrder)resolvedFlags._2());
        int srid = reader.getInt();
        this.skipEnvelope(resolvedFlags._1(), reader);
        byte[] wkb = new byte[reader.remaining()];
        reader.get(wkb);
        WKBReader wkbReader = new WKBReader(new GeometryFactory(new PrecisionModel(), srid));
        Geometry geom = wkbReader.read(wkb);
        return GeometryUDT$.MODULE$.serialize(geom);
    }

    public Object skipEnvelope(Object value, ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        Object object = value;
        if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)0), (Object)object)) {
            byteBuffer = null;
        } else {
            boolean bl = BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)1), (Object)object) ? true : BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)3), (Object)object);
            if (bl) {
                byteBuffer = buffer.get(new byte[32]);
            } else if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)2), (Object)object)) {
                byteBuffer = buffer.get(new byte[48]);
            } else if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)4), (Object)object)) {
                byteBuffer = buffer.get(new byte[64]);
            } else {
                throw new GeopackageException(new StringBuilder(99).append("Unexpected GeoPackage Geometry flags. Envelope contents indicator must be between 0 and 4. Actual: ").append(value).toString());
            }
        }
        return byteBuffer;
    }

    private Tuple3<Object, ByteOrder, Object> readFlags(byte flags) {
        int reserved7 = flags >> 7 & 1;
        int reserved6 = flags >> 6 & 1;
        if (reserved7 != 0 || reserved6 != 0) {
            throw new GeopackageException(new StringBuilder(79).append("Unexpected GeoPackage Geometry flags. Flag bit 7 and 6 should both be 0, 7=").append(reserved7).append(", 6=").append(reserved6).toString());
        }
        int binaryType = flags >> 5 & 1;
        boolean extended = binaryType == 1;
        int emptyValue = flags >> 4 & 1;
        boolean empty = emptyValue == 1;
        int envelopeIndicator = flags >> 1 & 7;
        if (envelopeIndicator > 4) {
            throw new GeopackageException(new StringBuilder(99).append("Unexpected GeoPackage Geometry flags. Envelope contents indicator must be between 0 and 4. Actual: ").append(envelopeIndicator).toString());
        }
        int byteOrderValue = flags & 1;
        ByteOrder byteOrder = byteOrderValue == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)envelopeIndicator), (Object)byteOrder, (Object)BoxesRunTime.boxToBoolean((boolean)extended));
    }

    private GeometryReader$() {
        MODULE$ = this;
    }
}

