/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2.primitives;

import java.util.BitSet;

public class CountingBitset {
    private final BitSet bits;
    private int size = 0;
    private int numSet = 0;

    public CountingBitset() {
        this(0);
    }

    public CountingBitset(int size) {
        this.bits = new BitSet(size);
        this.size = size;
    }

    public void reset(int size) {
        this.clear();
        this.size = size;
    }

    public void clear() {
        this.bits.clear();
        this.numSet = 0;
    }

    public int bits() {
        return this.size;
    }

    public int numSet() {
        return this.numSet;
    }

    public boolean empty() {
        return this.numSet == 0;
    }

    public boolean full() {
        return this.numSet == this.size;
    }

    public boolean get(int bitIndex) {
        if (bitIndex >= this.size) {
            throw new IndexOutOfBoundsException("bitIndex >= size: " + bitIndex);
        }
        return this.bits.get(bitIndex);
    }

    public void set(int bitIndex) {
        this.set(bitIndex, true);
    }

    public void set(int bitIndex, boolean value) {
        if (bitIndex >= this.size) {
            throw new IndexOutOfBoundsException("bitIndex >= size: " + bitIndex);
        }
        boolean old = this.bits.get(bitIndex);
        if (old != value) {
            this.bits.set(bitIndex, value);
            this.numSet += value ? 1 : -1;
        }
    }
}

