/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import org.apache.sedona.shaded.s2.R2Vector;
import org.apache.sedona.shaded.s2.S2;
import org.apache.sedona.shaded.s2.S2Point;
import org.jspecify.annotations.Nullable;

public final class S2Projections {
    private static final double MIN_AREA_DERIV = 8.0 * Math.sqrt(2.0) / 9.0;
    private static final double MAX_AREA_DERIV = 2.6357992569631614;
    private static final double MIN_ANGLE_SPAN_DERIV = 1.3333333333333333;
    private static final double MAX_ANGLE_SPAN_DERIV = 1.7048971791992185;
    private static final double MIN_WIDTH_DERIV = 2.0 * Math.sqrt(2.0) / 3.0;
    private static final double AVG_WIDTH_DERIV = 1.4345236728860995;
    private static final double MIN_EDGE_DERIV = 2.0 * Math.sqrt(2.0) / 3.0;
    private static final double AVG_EDGE_DERIV = 1.4592137463861061;
    private static final double MIN_DIAG_DERIV = 8.0 * Math.sqrt(2.0) / 9.0;
    private static final double MAX_DIAG_DERIV = 2.438654594434021;
    private static final double AVG_DIAG_DERIV = 2.0604227389984717;
    private static final double MAX_EDGE_ASPECT_QUADRATIC = 1.442615274452683;
    public static final int LIMIT_IJ = 0x40000000;
    public static final long MAX_SITI = 0x80000000L;
    public static final double MAX_XYZ_TO_UV_ERROR = (double)1.110223E-16f;
    private static final S2Point[][] FACE_UVW_AXES = new S2Point[][]{{S2Point.Y_POS, S2Point.Z_POS, S2Point.X_POS}, {S2Point.X_NEG, S2Point.Z_POS, S2Point.Y_POS}, {S2Point.X_NEG, S2Point.Y_NEG, S2Point.Z_POS}, {S2Point.Z_NEG, S2Point.Y_NEG, S2Point.X_NEG}, {S2Point.Z_NEG, S2Point.X_POS, S2Point.Y_NEG}, {S2Point.Y_POS, S2Point.X_POS, S2Point.Z_NEG}};
    private static final int[][][] FACE_UVW_FACES = new int[][][]{new int[][]{{4, 1}, {5, 2}, {3, 0}}, new int[][]{{0, 3}, {5, 2}, {4, 1}}, new int[][]{{0, 3}, {1, 4}, {5, 2}}, new int[][]{{2, 5}, {1, 4}, {0, 3}}, new int[][]{{2, 5}, {3, 0}, {1, 4}}, new int[][]{{4, 1}, {3, 0}, {2, 5}}};
    private static final UvTransform[] UV_TRANSFORMS = new UvTransform[]{new UvTransform(){

        @Override
        public double xyzToU(double x, double y, double z) {
            return y / x;
        }

        @Override
        public double xyzToV(double x, double y, double z) {
            return z / x;
        }
    }, new UvTransform(){

        @Override
        public double xyzToU(double x, double y, double z) {
            return -x / y;
        }

        @Override
        public double xyzToV(double x, double y, double z) {
            return z / y;
        }
    }, new UvTransform(){

        @Override
        public double xyzToU(double x, double y, double z) {
            return -x / z;
        }

        @Override
        public double xyzToV(double x, double y, double z) {
            return -y / z;
        }
    }, new UvTransform(){

        @Override
        public double xyzToU(double x, double y, double z) {
            return z / x;
        }

        @Override
        public double xyzToV(double x, double y, double z) {
            return y / x;
        }
    }, new UvTransform(){

        @Override
        public double xyzToU(double x, double y, double z) {
            return z / y;
        }

        @Override
        public double xyzToV(double x, double y, double z) {
            return -x / y;
        }
    }, new UvTransform(){

        @Override
        public double xyzToU(double x, double y, double z) {
            return -y / z;
        }

        @Override
        public double xyzToV(double x, double y, double z) {
            return -x / z;
        }
    }};
    private static final XyzTransform[] XYZ_TRANSFORMS = new XyzTransform[]{new XyzTransform(){

        @Override
        public double uvToX(double u, double v) {
            return 1.0;
        }

        @Override
        public double uvToY(double u, double v) {
            return u;
        }

        @Override
        public double uvToZ(double u, double v) {
            return v;
        }
    }, new XyzTransform(){

        @Override
        public double uvToX(double u, double v) {
            return -u;
        }

        @Override
        public double uvToY(double u, double v) {
            return 1.0;
        }

        @Override
        public double uvToZ(double u, double v) {
            return v;
        }
    }, new XyzTransform(){

        @Override
        public double uvToX(double u, double v) {
            return -u;
        }

        @Override
        public double uvToY(double u, double v) {
            return -v;
        }

        @Override
        public double uvToZ(double u, double v) {
            return 1.0;
        }
    }, new XyzTransform(){

        @Override
        public double uvToX(double u, double v) {
            return -1.0;
        }

        @Override
        public double uvToY(double u, double v) {
            return -v;
        }

        @Override
        public double uvToZ(double u, double v) {
            return -u;
        }
    }, new XyzTransform(){

        @Override
        public double uvToX(double u, double v) {
            return v;
        }

        @Override
        public double uvToY(double u, double v) {
            return -1.0;
        }

        @Override
        public double uvToZ(double u, double v) {
            return -u;
        }
    }, new XyzTransform(){

        @Override
        public double uvToX(double u, double v) {
            return v;
        }

        @Override
        public double uvToY(double u, double v) {
            return u;
        }

        @Override
        public double uvToZ(double u, double v) {
            return -1.0;
        }
    }};
    public static final S2.Metric MIN_AREA = new S2.Metric(2, MIN_AREA_DERIV);
    public static final S2.Metric MAX_AREA = new S2.Metric(2, 2.6357992569631614);
    public static final S2.Metric AVG_AREA = new S2.Metric(2, 2.0943951023931953);
    public static final S2.Metric MIN_ANGLE_SPAN = new S2.Metric(1, 1.3333333333333333);
    public static final S2.Metric MAX_ANGLE_SPAN = new S2.Metric(1, 1.7048971791992185);
    public static final S2.Metric AVG_ANGLE_SPAN = new S2.Metric(1, 1.5707963267948966);
    public static final S2.Metric MIN_WIDTH = new S2.Metric(1, MIN_WIDTH_DERIV);
    public static final S2.Metric MAX_WIDTH = new S2.Metric(1, 1.7048971791992185);
    public static final S2.Metric AVG_WIDTH = new S2.Metric(1, 1.4345236728860995);
    public static final S2.Metric MIN_EDGE = new S2.Metric(1, MIN_EDGE_DERIV);
    public static final S2.Metric MAX_EDGE = new S2.Metric(1, 1.7048971791992185);
    public static final S2.Metric AVG_EDGE = new S2.Metric(1, 1.4592137463861061);
    public static final S2.Metric MIN_DIAG = new S2.Metric(1, MIN_DIAG_DERIV);
    public static final S2.Metric MAX_DIAG = new S2.Metric(1, 2.438654594434021);
    public static final S2.Metric AVG_DIAG = new S2.Metric(1, 2.0604227389984717);
    public static final double MAX_EDGE_ASPECT = 1.442615274452683;
    public static final double MAX_DIAG_ASPECT = Math.sqrt(3.0);

    public static double stToUV(double s2) {
        if (s2 >= 0.5) {
            return 0.3333333333333333 * (4.0 * s2 * s2 - 1.0);
        }
        return 0.3333333333333333 * (1.0 - 4.0 * (1.0 - s2) * (1.0 - s2));
    }

    public static double uvToST(double u) {
        if (u >= 0.0) {
            return 0.5 * Math.sqrt(1.0 + 3.0 * u);
        }
        return 1.0 - 0.5 * Math.sqrt(1.0 - 3.0 * u);
    }

    public static int stToIj(double s2) {
        return Math.max(0, Math.min(0x3FFFFFFF, (int)Math.round(1.073741824E9 * s2 - 0.5)));
    }

    public static double ijToStMin(int i) {
        assert (i >= 0 && i <= 0x40000000);
        return 9.313225746154785E-10 * (double)i;
    }

    public static double ijToUV(int ij, int cellSize) {
        return S2Projections.stToUV(S2Projections.ijToStMin(ij & -cellSize));
    }

    public static double siTiToSt(long si) {
        assert (si >= 0L && si <= 0x80000000L);
        return 4.656612873077393E-10 * (double)si;
    }

    public static long stToSiTi(double s2) {
        return Math.round(s2 * 2.147483648E9);
    }

    public static S2Point faceUvToXyz(int face, double u, double v) {
        XyzTransform t = S2Projections.faceToXyzTransform(face);
        return new S2Point(t.uvToX(u, v), t.uvToY(u, v), t.uvToZ(u, v));
    }

    public static S2Point faceUvToXyz(int face, R2Vector uv) {
        return S2Projections.faceUvToXyz(face, uv.x(), uv.y());
    }

    static XyzTransform faceToXyzTransform(int face) {
        return XYZ_TRANSFORMS[Math.min(5, face)];
    }

    public static @Nullable R2Vector faceXyzToUv(int face, S2Point p) {
        if (face < 3 ? p.get(face) <= 0.0 : p.get(face - 3) >= 0.0) {
            return null;
        }
        return S2Projections.validFaceXyzToUv(face, p);
    }

    public static R2Vector validFaceXyzToUv(int face, S2Point p) {
        R2Vector result = new R2Vector();
        S2Projections.validFaceXyzToUv(face, p, result);
        return result;
    }

    static void validFaceXyzToUv(int face, S2Point p, R2Vector result) {
        UvTransform t = S2Projections.faceToUvTransform(face);
        result.set(t.xyzToU(p.x, p.y, p.z), t.xyzToV(p.x, p.y, p.z));
    }

    public static UvTransform faceToUvTransform(int face) {
        return UV_TRANSFORMS[face];
    }

    public static S2Point faceXyzToUvw(int face, S2Point p) {
        switch (face) {
            case 0: {
                return new S2Point(p.y, p.z, p.x);
            }
            case 1: {
                return new S2Point(-p.x, p.z, p.y);
            }
            case 2: {
                return new S2Point(-p.x, -p.y, p.z);
            }
            case 3: {
                return new S2Point(-p.z, -p.y, -p.x);
            }
            case 4: {
                return new S2Point(-p.z, p.x, -p.y);
            }
        }
        return new S2Point(p.y, p.x, -p.z);
    }

    private static final int siTiToLevel(long siTi) {
        return 30 - Long.numberOfTrailingZeros(siTi | 0x80000000L);
    }

    public static S2Point faceSiTiToXyz(int face, long si, long ti) {
        double u = S2Projections.stToUV(S2Projections.siTiToSt(si));
        double v = S2Projections.stToUV(S2Projections.siTiToSt(ti));
        return S2Projections.faceUvToXyz(face, u, v);
    }

    public static FaceSiTi xyzToFaceSiTi(S2Point p) {
        int face = S2Projections.xyzToFace(p);
        R2Vector uv = S2Projections.validFaceXyzToUv(face, p);
        long si = S2Projections.stToSiTi(S2Projections.uvToST(uv.x()));
        long ti = S2Projections.stToSiTi(S2Projections.uvToST(uv.y()));
        return new FaceSiTi(face, si, ti);
    }

    public static int levelIfCenter(FaceSiTi fst, S2Point p) {
        int level = S2Projections.siTiToLevel(fst.si);
        if (level < 0 || level != S2Projections.siTiToLevel(fst.ti)) {
            return -1;
        }
        assert (level <= 30);
        S2Point center = S2Projections.faceSiTiToXyz(fst.face, fst.si, fst.ti).normalize();
        if (p.equals(center)) {
            return level;
        }
        return -1;
    }

    public static int xyzToFace(S2Point p) {
        return S2Projections.xyzToFace(p.x, p.y, p.z);
    }

    static int xyzToFace(double x, double y, double z) {
        switch (S2Point.largestAbsComponent(x, y, z)) {
            case 0: {
                return x < 0.0 ? 3 : 0;
            }
            case 1: {
                return y < 0.0 ? 4 : 1;
            }
        }
        return z < 0.0 ? 5 : 2;
    }

    public static S2Point getUNorm(int face, double u) {
        switch (face) {
            case 0: {
                return new S2Point(u, -1.0, 0.0);
            }
            case 1: {
                return new S2Point(1.0, u, 0.0);
            }
            case 2: {
                return new S2Point(1.0, 0.0, u);
            }
            case 3: {
                return new S2Point(-u, 0.0, 1.0);
            }
            case 4: {
                return new S2Point(0.0, -u, 1.0);
            }
        }
        return new S2Point(0.0, -1.0, -u);
    }

    public static S2Point getVNorm(int face, double v) {
        switch (face) {
            case 0: {
                return new S2Point(-v, 0.0, 1.0);
            }
            case 1: {
                return new S2Point(0.0, -v, 1.0);
            }
            case 2: {
                return new S2Point(0.0, -1.0, -v);
            }
            case 3: {
                return new S2Point(v, -1.0, 0.0);
            }
            case 4: {
                return new S2Point(1.0, v, 0.0);
            }
        }
        return new S2Point(1.0, 0.0, v);
    }

    public static S2Point getUAxis(int face) {
        return S2Projections.getUVWAxis(face, 0);
    }

    public static S2Point getVAxis(int face) {
        return S2Projections.getUVWAxis(face, 1);
    }

    public static S2Point getNorm(int face) {
        return S2Projections.getUVWAxis(face, 2);
    }

    static S2Point getUVWAxis(int face, int axis) {
        return FACE_UVW_AXES[face][axis];
    }

    static int getUVWFace(int face, int axis, int direction) {
        assert (face >= 0 && face <= 5);
        assert (axis >= 0 && axis <= 2);
        assert (direction >= 0 && direction <= 1);
        return FACE_UVW_FACES[face][axis][direction];
    }

    private S2Projections() {
    }

    static final class FaceSiTi {
        public final int face;
        public final long si;
        public final long ti;

        FaceSiTi(int face, long si, long ti) {
            this.face = face;
            this.si = si;
            this.ti = ti;
        }
    }

    static interface XyzTransform {
        public double uvToX(double var1, double var3);

        public double uvToY(double var1, double var3);

        public double uvToZ(double var1, double var3);
    }

    public static abstract class UvTransform {
        private UvTransform() {
        }

        public abstract double xyzToU(double var1, double var3, double var5);

        public final double xyzToU(S2Point p) {
            return this.xyzToU(p.x, p.y, p.z);
        }

        public abstract double xyzToV(double var1, double var3, double var5);

        public final double xyzToV(S2Point p) {
            return this.xyzToV(p.x, p.y, p.z);
        }
    }
}

