/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springframework.util.CollectionUtils;

public class SpecPropertiesCustomizer
implements GlobalOpenApiCustomizer {
    private final OpenAPI openApiProperties;

    public SpecPropertiesCustomizer(SpringDocConfigProperties springDocConfigProperties) {
        this.openApiProperties = springDocConfigProperties.getOpenApi();
    }

    public SpecPropertiesCustomizer(OpenAPI openApiProperties) {
        this.openApiProperties = openApiProperties;
    }

    @Override
    public void customise(OpenAPI openApi) {
        this.customizeOpenApi(openApi, this.openApiProperties);
    }

    private void customizeOpenApi(OpenAPI openApi, OpenAPI openApiProperties) {
        if (openApiProperties != null) {
            Paths pathsProperties;
            Components componentsProperties;
            Info infoProperties = openApiProperties.getInfo();
            if (infoProperties != null) {
                this.customizeInfo(openApi, infoProperties);
            }
            if ((componentsProperties = openApiProperties.getComponents()) != null) {
                this.customizeComponents(openApi, componentsProperties);
            }
            if ((pathsProperties = openApiProperties.getPaths()) != null) {
                this.customizePaths(openApi, pathsProperties);
            }
        }
    }

    private void customizePaths(OpenAPI openApi, Paths pathsProperties) {
        Paths paths = openApi.getPaths();
        if (paths == null) {
            openApi.paths(pathsProperties);
        } else {
            paths.forEach((path, pathItem) -> {
                PathItem pathItemProperties;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ((pathItemProperties = (PathItem)pathsProperties.get(path)) != null) {
                    this.resolveString(arg_0 -> ((PathItem)pathItem).description(arg_0), () -> ((PathItem)pathItemProperties).getDescription());
                    this.resolveString(arg_0 -> ((PathItem)pathItem).summary(arg_0), () -> ((PathItem)pathItemProperties).getSummary());
                    Map operationMap = pathItem.readOperationsMap();
                    Map operationMapProperties = pathItemProperties.readOperationsMap();
                    operationMapProperties.forEach((httpMethod, operationProperties) -> {
                        Operation operationToCustomize = (Operation)operationMap.get(httpMethod);
                        if (operationToCustomize != null) {
                            this.resolveString(arg_0 -> ((Operation)operationToCustomize).description(arg_0), () -> ((Operation)operationProperties).getDescription());
                            this.resolveString(arg_0 -> ((Operation)operationToCustomize).summary(arg_0), () -> ((Operation)operationProperties).getSummary());
                            this.resolveSet(arg_0 -> ((Operation)operationToCustomize).tags(arg_0), () -> ((Operation)operationProperties).getTags());
                        }
                    });
                }
            });
        }
    }

    private void customizeComponents(OpenAPI openApi, Components componentsProperties) {
        Components components = openApi.getComponents();
        if (components == null || CollectionUtils.isEmpty((Map)components.getSchemas())) {
            openApi.components(componentsProperties);
        } else {
            Map schemaMap = components.getSchemas();
            schemaMap.forEach((key, schema) -> {
                Schema schemaProperties = (Schema)componentsProperties.getSchemas().get(key);
                if (schemaProperties != null) {
                    this.resolveString(arg_0 -> ((Schema)schema).setDescription(arg_0), () -> ((Schema)schemaProperties).getDescription());
                    Map properties = schema.getProperties();
                    if (CollectionUtils.isEmpty((Map)properties)) {
                        return;
                    }
                    properties.forEach((propKey, propSchema) -> {
                        Schema propSchemaProperties = (Schema)schemaProperties.getProperties().get(propKey);
                        if (propSchemaProperties != null) {
                            this.resolveString(arg_0 -> ((Schema)propSchema).description(arg_0), () -> ((Schema)propSchemaProperties).getDescription());
                            this.resolveString(arg_0 -> ((Schema)propSchema).title(arg_0), () -> ((Schema)propSchemaProperties).getTitle());
                            this.resolveString(arg_0 -> ((Schema)propSchema).example(arg_0), () -> ((Schema)propSchemaProperties).getExample());
                        }
                    });
                }
            });
        }
    }

    private void customizeInfo(OpenAPI openApi, Info infoProperties) {
        Info info = openApi.getInfo();
        if (info != null) {
            this.resolveString(arg_0 -> ((Info)info).title(arg_0), () -> ((Info)infoProperties).getTitle());
            this.resolveString(arg_0 -> ((Info)info).description(arg_0), () -> ((Info)infoProperties).getDescription());
            this.resolveString(arg_0 -> ((Info)info).version(arg_0), () -> ((Info)infoProperties).getVersion());
            this.resolveString(arg_0 -> ((Info)info).termsOfService(arg_0), () -> ((Info)infoProperties).getTermsOfService());
            this.resolveString(arg_0 -> ((Info)info).summary(arg_0), () -> ((Info)infoProperties).getSummary());
            License license = info.getLicense();
            License licenseProperties = infoProperties.getLicense();
            if (license != null) {
                this.resolveString(arg_0 -> ((License)license).name(arg_0), () -> ((License)licenseProperties).getName());
                this.resolveString(arg_0 -> ((License)license).url(arg_0), () -> ((License)licenseProperties).getUrl());
            } else {
                info.license(licenseProperties);
            }
            Contact contact = info.getContact();
            Contact contactProperties = infoProperties.getContact();
            if (contact != null) {
                this.resolveString(arg_0 -> ((Contact)contact).name(arg_0), () -> ((Contact)contactProperties).getName());
                this.resolveString(arg_0 -> ((Contact)contact).email(arg_0), () -> ((Contact)contactProperties).getEmail());
                this.resolveString(arg_0 -> ((Contact)contact).url(arg_0), () -> ((Contact)contactProperties).getUrl());
            } else {
                info.contact(contactProperties);
            }
        } else {
            openApi.info(infoProperties);
        }
    }

    private void resolveString(Consumer<String> setter, Supplier<Object> getter) {
        String value = (String)getter.get();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            setter.accept(value);
        }
    }

    private void resolveSet(Consumer<List> setter, Supplier<List> getter) {
        List value = getter.get();
        if (!CollectionUtils.isEmpty((Collection)value)) {
            setter.accept(value);
        }
    }
}

