/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import com.ecwid.consul.v1.ConsulClient;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.config.properties.ConsulProperties;
import org.apache.shenyu.admin.listener.DataChangedInit;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.admin.listener.consul.ConsulDataChangedInit;
import org.apache.shenyu.admin.listener.consul.ConsulDataChangedListener;
import org.apache.shenyu.common.exception.ShenyuException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="shenyu.sync.consul", name={"url"})
@EnableConfigurationProperties(value={ConsulProperties.class})
public class ConsulSyncConfiguration {
    @Bean
    public ConsulClient consulClient(ConsulProperties consulProperties) {
        String url = consulProperties.getUrl();
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new ShenyuException("sync.consul.url can not be null.");
        }
        try {
            URL consulUrl = new URL(url);
            return consulUrl.getPort() < 0 ? new ConsulClient(consulUrl.getHost()) : new ConsulClient(consulUrl.getHost(), consulUrl.getPort());
        }
        catch (MalformedURLException e) {
            throw new ShenyuException("sync.consul.url formatter is not incorrect.");
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={ConsulDataChangedListener.class})
    public DataChangedListener consulDataChangedListener(ConsulClient consulClient) {
        return new ConsulDataChangedListener(consulClient);
    }

    @Bean
    @ConditionalOnMissingBean(value={ConsulDataChangedInit.class})
    public DataChangedInit consulDataChangedInit(ConsulClient consulClient) {
        return new ConsulDataChangedInit(consulClient);
    }
}

