/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.register;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.register.common.config.ShenyuDiscoveryConfig;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.config.RegisterConfig;
import org.apache.shenyu.registry.api.entity.InstanceEntity;
import org.apache.shenyu.spi.ExtensionLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

public class InstanceRegisterListener
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceRegisterListener.class);
    private final DiscoveryUpstreamData currentInstanceUpstream;
    private final RegisterConfig discoveryConfig;
    private ShenyuInstanceRegisterRepository discoveryService;
    private final String path;

    public InstanceRegisterListener(DiscoveryUpstreamData discoveryUpstream, ShenyuDiscoveryConfig shenyuDiscoveryConfig) {
        this.currentInstanceUpstream = discoveryUpstream;
        this.currentInstanceUpstream.setProps("{\"warmupTime\":\"10\"}");
        this.discoveryConfig = new RegisterConfig();
        this.discoveryConfig.setServerLists(shenyuDiscoveryConfig.getServerList());
        this.discoveryConfig.setRegisterType(shenyuDiscoveryConfig.getType());
        this.discoveryConfig.setProps(Optional.ofNullable(shenyuDiscoveryConfig.getProps()).orElse(new Properties()));
        this.path = shenyuDiscoveryConfig.getRegisterPath();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOGGER.info("unregister upstream server by jvm runtime hook");
            if (Objects.nonNull(this.discoveryService)) {
                this.discoveryService.close();
            }
        }));
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        try {
            if (StringUtils.isBlank((CharSequence)this.discoveryConfig.getRegisterType()) || StringUtils.equalsIgnoreCase((CharSequence)this.discoveryConfig.getRegisterType(), (CharSequence)"local")) {
                return;
            }
            this.discoveryService = (ShenyuInstanceRegisterRepository)ExtensionLoader.getExtensionLoader(ShenyuInstanceRegisterRepository.class).getJoin(this.discoveryConfig.getRegisterType());
            this.discoveryConfig.getProps().put("watchPath", this.path);
            this.discoveryService.init(this.discoveryConfig);
            InstanceEntity instance = new InstanceEntity();
            instance.setStatus(this.currentInstanceUpstream.getStatus());
            instance.setWeight(this.currentInstanceUpstream.getWeight());
            URI uri = URI.create(this.currentInstanceUpstream.getProtocol() + this.currentInstanceUpstream.getUrl());
            instance.setPort(Integer.valueOf(uri.getPort()));
            instance.setHost(uri.getHost());
            instance.setAppName(this.discoveryConfig.getProps().getProperty("name"));
            this.discoveryService.persistInstance(instance);
            LOGGER.info("shenyu register into ShenyuDiscoveryService {} success", (Object)this.discoveryConfig.getRegisterType());
        }
        catch (Exception e) {
            LOGGER.error("shenyu register into ShenyuDiscoveryService  {} type find error", (Object)this.discoveryConfig.getRegisterType(), (Object)e);
            throw new ShenyuException(String.format("shenyu register into ShenyuDiscoveryService %s type find error", this.discoveryConfig.getRegisterType()));
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

