/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.pojo;

import java.util.Map;

public class CircuitBreakerStatus {
    private final String circuitBreaker;
    private final Status status;
    private final long startTimeMs;
    private final FallbackInfo fallbackInfo;

    public CircuitBreakerStatus(String circuitBreaker, Status status, long startTimeMs) {
        this(circuitBreaker, status, startTimeMs, null);
    }

    public CircuitBreakerStatus(String circuitBreaker, Status status, long startTimeMs, FallbackInfo fallbackInfo) {
        this.circuitBreaker = circuitBreaker;
        this.status = status;
        this.startTimeMs = startTimeMs;
        this.fallbackInfo = fallbackInfo;
    }

    public String getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public Status getStatus() {
        return this.status;
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public FallbackInfo getFallbackInfo() {
        return this.fallbackInfo;
    }

    public boolean isAvailable() {
        if (this.status == Status.CLOSE) {
            return true;
        }
        return this.status != Status.OPEN;
    }

    public String toString() {
        return "CircuitBreakerStatus{circuitBreaker='" + this.circuitBreaker + '\'' + ", status=" + (Object)((Object)this.status) + ", startTimeMs=" + this.startTimeMs + '}';
    }

    public static class FallbackInfo {
        private final int code;
        private final Map<String, String> headers;
        private final String body;

        public FallbackInfo(int code, Map<String, String> headers, String body) {
            this.code = code;
            this.headers = headers;
            this.body = body;
        }

        public int getCode() {
            return this.code;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getBody() {
            return this.body;
        }

        public String toString() {
            return "FallbackInfo{code=" + this.code + ", headers=" + this.headers + ", body='" + this.body + '\'' + '}';
        }
    }

    public static enum Status {
        CLOSE,
        HALF_OPEN,
        OPEN;

    }
}

