/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.client.pojo;

import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.api.pojo.DetectResult;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.InstanceLocalValue;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.specification.api.v1.service.manage.ServiceProto;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import shade.polaris.com.google.protobuf.UInt32Value;

public class InstanceByProto
implements Instance {
    private final ServiceKey serviceKey;
    private final ServiceProto.Instance instance;
    private final InstanceLocalValue instanceLocalValue;
    private final int hashCode;

    public InstanceByProto(ServiceKey serviceKey, ServiceProto.Instance instance, InstanceLocalValue localValue) {
        this.serviceKey = serviceKey;
        this.instance = instance;
        this.instanceLocalValue = localValue;
        this.hashCode = Objects.hash(instance.getHost(), instance.getPort());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceByProto that = (InstanceByProto)o;
        return Objects.equals(this.instance.getHost(), that.instance.getHost()) && Objects.equals(this.instance.getPort(), that.instance.getPort());
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String getNamespace() {
        return this.serviceKey.getNamespace();
    }

    @Override
    public String getService() {
        return this.serviceKey.getService();
    }

    @Override
    public String getRevision() {
        return this.instance.getRevision().getValue();
    }

    @Override
    public CircuitBreakerStatus getCircuitBreakerStatus() {
        if (null == this.instanceLocalValue) {
            return null;
        }
        return this.instanceLocalValue.getCircuitBreakerStatus(StatusDimension.EMPTY_DIMENSION);
    }

    @Override
    public Collection<StatusDimension> getStatusDimensions() {
        if (null == this.instanceLocalValue) {
            return Collections.emptySet();
        }
        return this.instanceLocalValue.getStatusDimensions();
    }

    @Override
    public CircuitBreakerStatus getCircuitBreakerStatus(StatusDimension statusDimension) {
        if (null == this.instanceLocalValue) {
            return null;
        }
        return this.instanceLocalValue.getCircuitBreakerStatus(statusDimension);
    }

    public DetectResult getDetectResult() {
        if (null == this.instanceLocalValue) {
            return null;
        }
        return this.instanceLocalValue.getDetectResult();
    }

    @Override
    public boolean isHealthy() {
        return this.instance.getHealthy().getValue();
    }

    @Override
    public boolean isIsolated() {
        return this.instance.getIsolate().getValue();
    }

    @Override
    public String getProtocol() {
        return this.instance.getProtocol().getValue();
    }

    @Override
    public String getId() {
        return this.instance.getId().getValue();
    }

    @Override
    public String getHost() {
        return this.instance.getHost().getValue();
    }

    @Override
    public int getPort() {
        return this.instance.getPort().getValue();
    }

    @Override
    public String getVersion() {
        return this.instance.getVersion().getValue();
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.instance.getMetadataMap();
    }

    @Override
    public boolean isEnableHealthCheck() {
        return this.instance.hasHealthCheck();
    }

    @Override
    public String getRegion() {
        return this.instance.getLocation().getRegion().getValue();
    }

    @Override
    public String getZone() {
        return this.instance.getLocation().getZone().getValue();
    }

    @Override
    public String getCampus() {
        return this.instance.getLocation().getCampus().getValue();
    }

    @Override
    public int getPriority() {
        return this.instance.getPriority().getValue();
    }

    @Override
    public int getWeight() {
        int weight = 100;
        if (this.instance.hasWeight()) {
            UInt32Value weightValue = this.instance.getWeight();
            weight = weightValue.getValue();
        }
        return weight;
    }

    @Override
    public String getLogicSet() {
        return this.instance.getLogicSet().getValue();
    }

    public String toString() {
        return "InstanceByProto{serviceKey=" + this.serviceKey + ", instance=" + this.instance + '}';
    }

    public InstanceLocalValue getInstanceLocalValue() {
        return this.instanceLocalValue;
    }

    @Override
    public int compareTo(Instance instance) {
        String remoteHost;
        String curHost = this.getHost();
        int result = curHost.compareTo(remoteHost = instance.getHost());
        if (result != 0) {
            return result;
        }
        return this.getPort() - instance.getPort();
    }
}

